/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.data.Depot;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockDriverKeyDispenser;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateKeyDispenserConfig;
import org.mtr.mod.screen.MTRScreenBase;

public class DriverKeyDispenserScreen
extends MTRScreenBase
implements IGui {
    private final CheckboxWidgetExtension checkBoxDispenseBasicDriverKey;
    private final CheckboxWidgetExtension checkBoxDispenseAdvancedDriverKey;
    private final CheckboxWidgetExtension checkBoxDispenseGuardKey;
    private final TextFieldWidgetExtension textFieldTimeoutHours;
    private final TextFieldWidgetExtension textFieldTimeoutMinutes;
    private final BlockPos blockPos;
    private final long timeout;
    private static final int TEXT_FIELD_SIZE = 60;

    public DriverKeyDispenserScreen(BlockPos blockPos, BlockDriverKeyDispenser.BlockEntity blockEntity) {
        this.blockPos = blockPos;
        this.timeout = blockEntity.getTimeout();
        this.checkBoxDispenseBasicDriverKey = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.checkBoxDispenseBasicDriverKey.setMessage2(TranslationProvider.ITEM_MTR_BASIC_DRIVER_KEY.getText(new Object[0]));
        this.checkBoxDispenseBasicDriverKey.setChecked(blockEntity.getDispenseBasicDriverKey());
        this.checkBoxDispenseAdvancedDriverKey = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.checkBoxDispenseAdvancedDriverKey.setMessage2(TranslationProvider.ITEM_MTR_ADVANCED_DRIVER_KEY.getText(new Object[0]));
        this.checkBoxDispenseAdvancedDriverKey.setChecked(blockEntity.getDispenseAdvancedDriverKey());
        this.checkBoxDispenseGuardKey = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.checkBoxDispenseGuardKey.setMessage2(TranslationProvider.ITEM_MTR_GUARD_KEY.getText(new Object[0]));
        this.checkBoxDispenseGuardKey.setChecked(blockEntity.getDispenseGuardKey());
        this.textFieldTimeoutHours = new TextFieldWidgetExtension(0, 0, 0, 20, 4, TextCase.DEFAULT, "\\D", "1");
        this.textFieldTimeoutMinutes = new TextFieldWidgetExtension(0, 0, 0, 20, 2, TextCase.DEFAULT, "\\D", "0");
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.checkBoxDispenseBasicDriverKey, 20, 40, this.f_96543_ - 40);
        IDrawing.setPositionAndWidth(this.checkBoxDispenseAdvancedDriverKey, 20, 60, this.f_96543_ - 40);
        IDrawing.setPositionAndWidth(this.checkBoxDispenseGuardKey, 20, 80, this.f_96543_ - 40);
        IDrawing.setPositionAndWidth(this.textFieldTimeoutHours, 22, 122, 56);
        this.textFieldTimeoutHours.setText2(String.valueOf(this.timeout / 3600000L));
        IDrawing.setPositionAndWidth(this.textFieldTimeoutMinutes, 22, 146, 56);
        this.textFieldTimeoutMinutes.setText2(String.valueOf(this.timeout % 3600000L / 60L / 1000L));
        this.addChild(new ClickableWidget((AbstractWidget)this.checkBoxDispenseBasicDriverKey));
        this.addChild(new ClickableWidget((AbstractWidget)this.checkBoxDispenseAdvancedDriverKey));
        this.addChild(new ClickableWidget((AbstractWidget)this.checkBoxDispenseGuardKey));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldTimeoutHours));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldTimeoutMinutes));
    }

    @Override
    public void tick2() {
        super.tick2();
        this.textFieldTimeoutHours.tick2();
        this.textFieldTimeoutMinutes.tick2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        Depot depot = InitClient.findDepot(this.blockPos);
        graphicsHolder.drawText(depot == null ? TranslationProvider.GUI_MTR_DRIVING_KEYS_DEPOT_NOT_FOUND.getMutableText(new Object[0]).formatted(TextFormatting.RED) : TranslationProvider.GUI_MTR_DRIVING_KEYS_FOR_DEPOT.getMutableText(depot.getName()), 20, 26, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TranslationProvider.GUI_MTR_DRIVER_KEY_TIMEOUT.getMutableText(new Object[0]), 20, 106, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TranslationProvider.GUI_MTR_HOURS.getMutableText(""), 80, 128, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TranslationProvider.GUI_MTR_MINUTES.getMutableText(""), 80, 152, -1, false, GraphicsHolder.getDefaultLight());
    }

    @Override
    public void onClose2() {
        long newTimeout = 3600000L;
        try {
            newTimeout = Long.parseLong(this.textFieldTimeoutHours.getText2()) * 3600000L + Long.parseLong(this.textFieldTimeoutMinutes.getText2()) * 60L * 1000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateKeyDispenserConfig(this.blockPos, this.checkBoxDispenseBasicDriverKey.isChecked2(), this.checkBoxDispenseAdvancedDriverKey.isChecked2(), this.checkBoxDispenseGuardKey.isChecked2(), newTimeout));
        super.onClose2();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }
}

