/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockItemExtension;
import org.mtr.mapping.mapper.EntityExtension;
import org.mtr.mapping.registry.CreativeModeTabHolder;

public final class ModEventBus {
    final Map<Identifier, Supplier<Block>> BLOCKS = new HashMap<Identifier, Supplier<Block>>();
    final Map<Identifier, Supplier<BlockItemExtension>> BLOCK_ITEMS = new HashMap<Identifier, Supplier<BlockItemExtension>>();
    final Map<Identifier, Supplier<org.mtr.mapping.holder.Item>> ITEMS = new HashMap<Identifier, Supplier<org.mtr.mapping.holder.Item>>();
    final Map<Identifier, Supplier<BlockEntityType<? extends BlockEntityExtension>>> blockEntityTypes = new HashMap<Identifier, Supplier<BlockEntityType<? extends BlockEntityExtension>>>();
    final Map<Identifier, Supplier<EntityType<? extends EntityExtension>>> entityTypes = new HashMap<Identifier, Supplier<EntityType<? extends EntityExtension>>>();
    final Map<Identifier, Supplier<ParticleType<?>>> particleTypes = new HashMap();
    final Map<Identifier, Supplier<SoundEvent>> soundEvents = new HashMap<Identifier, Supplier<SoundEvent>>();
    final List<CreativeModeTabHolder> creativeModeTabs = new ArrayList<CreativeModeTabHolder>();

    @SubscribeEvent
    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> this.BLOCKS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.world.level.block.Block)((Block)supplier.get()).data))));
        event.register(ForgeRegistries.Keys.ITEMS, helper -> {
            this.BLOCK_ITEMS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((Item)supplier.get())));
            this.ITEMS.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((Item)((org.mtr.mapping.holder.Item)supplier.get()).data)));
        });
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> this.blockEntityTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((BlockEntityType)supplier.get()))));
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> this.entityTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((EntityType)supplier.get()))));
        event.register(ForgeRegistries.Keys.PARTICLE_TYPES, helper -> this.particleTypes.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((ParticleType)supplier.get()))));
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> this.soundEvents.forEach((identifier, supplier) -> helper.register((ResourceLocation)identifier.data, (Object)((net.minecraft.sounds.SoundEvent)((SoundEvent)supplier.get()).data))));
    }

    @SubscribeEvent
    public void buildContents(CreativeModeTabEvent.Register event) {
        this.creativeModeTabs.forEach(creativeModeTabHolder -> event.registerCreativeModeTab(creativeModeTabHolder.identifier, builder -> builder.m_257941_((Component)Component.m_237115_((String)String.format("itemGroup.%s.%s", creativeModeTabHolder.identifier.m_135827_(), creativeModeTabHolder.identifier.m_135815_()))).m_257737_(() -> (ItemStack)creativeModeTabHolder.iconSupplier.get().data).m_257501_((params, output) -> creativeModeTabHolder.itemSuppliers.forEach(itemSupplier -> output.m_246326_((ItemLike)((org.mtr.mapping.holder.Item)itemSupplier.get()).data))).m_257652_()));
    }
}

