/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.operation.BlockRails;
import org.mtr.core.tool.Angle;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.packet.PacketBlockRails;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;

public abstract class BlockSignalBase
extends BlockExtension
implements DirectionHelper,
BlockWithEntity {
    public static final EnumProperty<EnumBooleanInverted> IS_22_5 = EnumProperty.of("is_22_5", EnumBooleanInverted.class);
    public static final EnumProperty<EnumBooleanInverted> IS_45 = EnumProperty.of("is_45", EnumBooleanInverted.class);
    public static final IntegerProperty POWER = IntegerProperty.of("power", 0, 15);
    private static final int COOLDOWN_1 = 2000;
    private static final int COOLDOWN_2 = 4000;
    private static final int ACCEPT_REDSTONE_COOLDOWN = 800;

    public BlockSignalBase(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && entity.data instanceof BlockEntityBase) {
                ((BlockEntityBase)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenBlockEntityScreen(pos));
            }
        });
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        int quadrant = Angle.getQuadrant(ctx.getPlayerYaw(), true);
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockSignalBase.FACING.data), Direction.fromHorizontal((int)(quadrant / 4)).data).with(new org.mtr.mapping.holder.Property((Property)BlockSignalBase.IS_45.data), EnumBooleanInverted.fromBoolean(quadrant % 4 >= 2)).with(new org.mtr.mapping.holder.Property((Property)BlockSignalBase.IS_22_5.data), EnumBooleanInverted.fromBoolean(quadrant % 2 == 1));
    }

    @Override
    public boolean emitsRedstonePower2(BlockState blockState) {
        return true;
    }

    @Override
    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe(state, POWER);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(IS_22_5);
        properties.add(IS_45);
        properties.add(POWER);
    }

    public void power(World world, BlockState state, BlockPos pos, int level) {
        int oldPowered = IBlock.getStatePropertySafe(state, POWER);
        if (oldPowered != level) {
            world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)BlockSignalBase.POWER.data), level));
        }
    }

    public static float getAngle(BlockState state) {
        return IBlock.getStatePropertySafe(state, DirectionHelper.FACING).asRotation() + (IBlock.getStatePropertySafe((BlockState)state, BlockSignalBase.IS_22_5).booleanValue ? 22.5f : 0.0f) + (float)(IBlock.getStatePropertySafe((BlockState)state, BlockSignalBase.IS_45).booleanValue ? 45 : 0);
    }

    public static enum EnumBooleanInverted implements StringIdentifiable
    {
        FALSE(false),
        TRUE(true);

        public final boolean booleanValue;

        private EnumBooleanInverted(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        @Nonnull
        public String asString2() {
            return String.valueOf(this.booleanValue);
        }

        private static EnumBooleanInverted fromBoolean(boolean value) {
            return value ? TRUE : FALSE;
        }
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        private long lastOccupiedTime1;
        private long lastOccupiedTime2;
        private int oldRedstoneLevel;
        private long lastAcceptedRedstoneTime;
        private boolean acceptRedstone;
        private boolean outputRedstone;
        public final boolean isDoubleSided;
        private final IntAVLTreeSet signalColors1 = new IntAVLTreeSet();
        private final IntAVLTreeSet signalColors2 = new IntAVLTreeSet();
        private static final String KEY_ACCEPT_REDSTONE = "accept_redstone";
        private static final String KEY_OUTPUT_REDSTONE = "output_redstone";
        private static final String KEY_SIGNAL_COLORS_1 = "signal_colors_1";
        private static final String KEY_SIGNAL_COLORS_2 = "signal_colors_2";

        public BlockEntityBase(BlockEntityType<?> type, boolean isDoubleSided, BlockPos pos, BlockState state) {
            super(type, pos, state);
            this.isDoubleSided = isDoubleSided;
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.acceptRedstone = compoundTag.getBoolean(KEY_ACCEPT_REDSTONE);
            this.outputRedstone = compoundTag.getBoolean(KEY_OUTPUT_REDSTONE);
            this.signalColors1.clear();
            for (int color : compoundTag.getIntArray(KEY_SIGNAL_COLORS_1)) {
                this.signalColors1.add(color);
            }
            this.signalColors2.clear();
            for (int color : compoundTag.getIntArray(KEY_SIGNAL_COLORS_2)) {
                this.signalColors2.add(color);
            }
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putBoolean(KEY_ACCEPT_REDSTONE, this.acceptRedstone);
            compoundTag.putBoolean(KEY_OUTPUT_REDSTONE, this.outputRedstone);
            compoundTag.putIntArray(KEY_SIGNAL_COLORS_1, new ArrayList<Integer>(this.signalColors1));
            compoundTag.putIntArray(KEY_SIGNAL_COLORS_2, new ArrayList<Integer>(this.signalColors2));
            super.writeCompoundTag(compoundTag);
        }

        public void setData(boolean acceptRedstone, boolean outputRedstone, IntAVLTreeSet signalColors, boolean isBackSide) {
            this.acceptRedstone = acceptRedstone;
            this.outputRedstone = outputRedstone;
            this.getSignalColors(isBackSide).clear();
            this.getSignalColors(isBackSide).addAll(signalColors);
            this.markDirty2();
        }

        public boolean getAcceptRedstone() {
            return this.acceptRedstone;
        }

        public boolean getOutputRedstone() {
            return this.outputRedstone && !this.acceptRedstone;
        }

        public IntAVLTreeSet getSignalColors(boolean isBackSide) {
            return isBackSide ? this.signalColors2 : this.signalColors1;
        }

        public int getActualAspect(boolean occupied, boolean isBackSide) {
            long currentTime = System.currentTimeMillis();
            if (occupied) {
                if (isBackSide) {
                    this.lastOccupiedTime2 = currentTime;
                } else {
                    this.lastOccupiedTime1 = currentTime;
                }
                return 1;
            }
            long difference = currentTime - (isBackSide ? this.lastOccupiedTime2 : this.lastOccupiedTime1);
            if (difference >= 4000L) {
                return 0;
            }
            if (difference >= 2000L) {
                return 3;
            }
            return 2;
        }

        public void checkForRedstoneUpdate(int redstoneLevel, ObjectArrayList<String> railIds1, ObjectArrayList<String> railIds2) {
            int newRedstoneLevel;
            int n = newRedstoneLevel = this.getOutputRedstone() ? redstoneLevel : 0;
            if (this.oldRedstoneLevel != newRedstoneLevel) {
                this.oldRedstoneLevel = newRedstoneLevel;
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketTurnOnBlockEntity(this.getPos2(), newRedstoneLevel));
            }
            long currentTime = System.currentTimeMillis();
            World world = this.getWorld2();
            if (this.getAcceptRedstone() && currentTime - this.lastAcceptedRedstoneTime > 800L && world != null) {
                this.lastAcceptedRedstoneTime = currentTime;
                for (Direction direction : Direction.values()) {
                    if (!world.isEmittingRedstonePower(this.getPos2().offset(direction.getOpposite()), direction)) continue;
                    if (!railIds1.isEmpty()) {
                        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketBlockRails(new BlockRails(railIds1, new IntArrayList(this.signalColors1))));
                    }
                    if (railIds2.isEmpty()) break;
                    InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketBlockRails(new BlockRails(railIds2, new IntArrayList(this.signalColors2))));
                    break;
                }
            }
        }
    }
}

