/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.BiConsumer;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mod.generated.resource.PositionDefinitionsSchema;
import org.mtr.mod.resource.PartPosition;
import org.mtr.mod.resource.PositionDefinition;

public final class PositionDefinitions
extends PositionDefinitionsSchema {
    private final Object2ObjectOpenHashMap<String, PositionDefinition> nameToDefinition = new Object2ObjectOpenHashMap();

    public PositionDefinitions(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
        this.positionDefinitions.forEach(positionDefinition -> this.nameToDefinition.put(positionDefinition.getName(), (PositionDefinition)positionDefinition));
    }

    PositionDefinitions() {
        PositionDefinition positionDefinition = new PositionDefinition();
        this.positionDefinitions.add(positionDefinition);
        this.nameToDefinition.put("", positionDefinition);
    }

    PositionDefinitions(ObjectArrayList<PositionDefinition> positionDefinitions) {
        this.positionDefinitions.addAll(positionDefinitions);
        positionDefinitions.forEach(positionDefinition -> this.nameToDefinition.put(positionDefinition.getName(), (PositionDefinition)positionDefinition));
    }

    void getPositionDefinition(String name, BiConsumer<ObjectArrayList<PartPosition>, ObjectArrayList<PartPosition>> consumer) {
        PositionDefinition positionDefinition = this.nameToDefinition.get(name);
        if (positionDefinition != null) {
            positionDefinition.getPositionLists(consumer);
        }
    }
}

