/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.data;

import java.util.Map;
import javax.annotation.Nullable;
import org.mtr.core.data.ClientData;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.PathData;
import org.mtr.core.data.Position;
import org.mtr.core.data.Rail;
import org.mtr.core.data.Siding;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.data.VehicleExtraData;
import org.mtr.core.data.VehiclePosition;
import org.mtr.core.data.VehicleRidingEntity;
import org.mtr.core.generated.data.VehicleSchema;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.simulation.Simulator;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2LongAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;

public class Vehicle
extends VehicleSchema
implements Utilities {
    private long stoppingCoolDown;
    private long deviation;
    private int manualNotch;
    public final VehicleExtraData vehicleExtraData;
    private final Siding siding;
    private final boolean isClientside;
    public static final int DOOR_MOVE_TIME = 3200;
    private static final int DOOR_DELAY = 1000;

    public Vehicle(VehicleExtraData vehicleExtraData, @Nullable Siding siding, TransportMode transportMode, Data data) {
        super(transportMode, data);
        this.siding = siding;
        this.vehicleExtraData = vehicleExtraData;
        this.isCurrentlyManual = vehicleExtraData.getIsManualAllowed();
        this.isClientside = !(data instanceof Simulator);
    }

    public Vehicle(VehicleExtraData vehicleExtraData, @Nullable Siding siding, ReaderBase readerBase, Data data) {
        super(readerBase, data);
        this.siding = siding;
        this.vehicleExtraData = vehicleExtraData;
        this.isCurrentlyManual = vehicleExtraData.getIsManualAllowed();
        this.isClientside = !(data instanceof Simulator);
        this.updateData(readerBase);
    }

    @Deprecated
    public Vehicle(ReaderBase readerBase) {
        this(new VehicleExtraData(readerBase), null, readerBase, (Data)new ClientData());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean isMoving() {
        return this.speed != 0.0;
    }

    public double getAdjustedSpeed() {
        return this.speed * (1.0 + this.vehicleExtraData.getDelayedVehicleSpeedIncreasePercentage() / 100.0);
    }

    public boolean getIsOnRoute() {
        return this.railProgress > this.vehicleExtraData.getDefaultPosition();
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public boolean closeToDepot() {
        return !this.getIsOnRoute() || this.railProgress < this.vehicleExtraData.getTotalVehicleLength() + this.vehicleExtraData.getRailLength();
    }

    public boolean changeSpeedManual(boolean isAccelerate) {
        if (this.isCurrentlyManual) {
            this.manualNotch += isAccelerate ? 1 : -1;
            return true;
        }
        return false;
    }

    public boolean toggleDoorsManual() {
        if (this.isCurrentlyManual) {
            this.vehicleExtraData.toggleDoors();
            return true;
        }
        return false;
    }

    public void initVehiclePositions(Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>> vehiclePositions) {
        this.writeVehiclePositions(Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress), vehiclePositions);
    }

    public void simulate(long millisElapsed, @Nullable ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>> vehiclePositions, @Nullable Long2LongAVLTreeMap vehicleTimesAlongRoute) {
        int currentIndex;
        double oldElapsedDwellTime = this.elapsedDwellTime;
        double oldSpeed = this.speed;
        if (this.getIsOnRoute()) {
            if (this.vehicleExtraData.getRepeatIndex2() == 0 && this.railProgress >= this.vehicleExtraData.getTotalDistance() - (this.vehicleExtraData.getRailLength() - this.vehicleExtraData.getTotalVehicleLength()) / 2.0) {
                currentIndex = 0;
                this.manualNotch = 0;
                this.simulateInDepot();
            } else {
                currentIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress);
                if (this.speed <= 0.0) {
                    this.speed = 0.0;
                    this.simulateAutomaticStopped(millisElapsed, vehiclePositions, currentIndex);
                } else {
                    this.simulateAutomaticMoving(millisElapsed, vehiclePositions, currentIndex);
                }
            }
        } else {
            currentIndex = 0;
            this.simulateInDepot();
        }
        this.stoppingCoolDown = Math.max(0L, this.stoppingCoolDown - millisElapsed);
        if (vehiclePositions != null) {
            this.writeVehiclePositions(currentIndex, vehiclePositions.get(1));
        }
        if (this.siding != null && vehicleTimesAlongRoute != null) {
            long timeAlongRoute = (long)Math.floor(this.siding.getTimeAlongRoute(this.railProgress - (double)(this.speed == 0.0 ? 1 : 0)) + (double)this.elapsedDwellTime);
            vehicleTimesAlongRoute.put(this.departureIndex, timeAlongRoute);
            if (oldElapsedDwellTime == 0.0 && this.elapsedDwellTime > 0L || oldSpeed == 0.0 && this.speed > 0.0) {
                long l = this.deviation = this.transportMode.continuousMovement ? 0L : Utilities.circularDifference(this.data.getCurrentMillis() - this.sidingDepartureTime, timeAlongRoute, this.siding.getRepeatInterval(86400000L));
            }
        }
        if (!this.isClientside && this.data instanceof Simulator) {
            this.vehicleExtraData.removeRidingEntitiesIf(vehicleRidingEntity -> !((Simulator)this.data).isRiding(vehicleRidingEntity.uuid, this.id));
        }
    }

    public void startUp(long newDepartureIndex, long newSidingDepartureTime) {
        this.departureIndex = newDepartureIndex;
        this.sidingDepartureTime = newSidingDepartureTime;
        this.railProgress += 4.0E-6;
        this.elapsedDwellTime = 0L;
        this.speed = 4.0E-6;
        this.vehicleExtraData.closeDoors();
        this.nextStoppingIndex = this.vehicleExtraData.immutablePath.size() - 1;
        for (int i = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress); i < this.vehicleExtraData.immutablePath.size(); ++i) {
            if (this.vehicleExtraData.immutablePath.get(i).getDwellTime() <= 0L) continue;
            this.nextStoppingIndex = i;
            break;
        }
    }

    public long getDepartureIndex() {
        return this.departureIndex;
    }

    public ObjectArrayList<ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>> getVehicleCarsAndPositions() {
        ObjectArrayList<ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>> vehicleCarsAndPositions = new ObjectArrayList<ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>>();
        double checkRailProgress = this.railProgress - (this.reversed ? this.vehicleExtraData.getTotalVehicleLength() : 0.0);
        for (int i = 0; i < this.vehicleExtraData.immutableVehicleCars.size(); ++i) {
            VehicleCar vehicleCar = this.vehicleExtraData.immutableVehicleCars.get(i);
            double halfLength = vehicleCar.getLength() / 2.0;
            ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>> bogiePositionsList = new ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>();
            DoubleArrayList overrideY = new DoubleArrayList();
            bogiePositionsList.add(this.getBogiePositions((checkRailProgress += (double)(this.reversed ? 1 : -1) * vehicleCar.getCouplingPadding1(i == 0)) + (double)(this.reversed ? 1 : -1) * (halfLength + vehicleCar.getBogie1Position()), overrideY));
            if (!vehicleCar.hasOneBogie) {
                bogiePositionsList.add(this.getBogiePositions(checkRailProgress + (double)(this.reversed ? 1 : -1) * (halfLength + vehicleCar.getBogie2Position()), overrideY));
            }
            vehicleCarsAndPositions.add(new ObjectObjectImmutablePair(vehicleCar, bogiePositionsList));
            checkRailProgress += (double)(this.reversed ? 1 : -1) * vehicleCar.getTotalLength(true, false);
        }
        return vehicleCarsAndPositions;
    }

    public Vector getHeadPosition() {
        return this.getPosition(this.railProgress, new DoubleArrayList());
    }

    void updateRidingEntities(ObjectArrayList<VehicleRidingEntity> vehicleRidingEntities) {
        if (!this.isClientside && this.data instanceof Simulator) {
            ObjectOpenHashSet uuidToRemove = new ObjectOpenHashSet();
            ObjectOpenHashSet<VehicleRidingEntity> vehicleRidingEntitiesToAdd = new ObjectOpenHashSet<VehicleRidingEntity>();
            vehicleRidingEntities.forEach(vehicleRidingEntity -> {
                uuidToRemove.add(vehicleRidingEntity.uuid);
                if (vehicleRidingEntity.isOnVehicle()) {
                    vehicleRidingEntitiesToAdd.add((VehicleRidingEntity)vehicleRidingEntity);
                    ((Simulator)this.data).ride(vehicleRidingEntity.uuid, this.id);
                } else {
                    ((Simulator)this.data).stopRiding(vehicleRidingEntity.uuid);
                }
            });
            this.vehicleExtraData.removeRidingEntitiesIf(vehicleRidingEntity -> uuidToRemove.contains(vehicleRidingEntity.uuid));
            this.vehicleExtraData.addRidingEntities(vehicleRidingEntitiesToAdd);
        }
    }

    private void simulateInDepot() {
        this.railProgress = this.vehicleExtraData.getDefaultPosition();
        this.reversed = false;
        this.speed = 0.0;
        this.nextStoppingIndex = 0L;
        this.departureIndex = -1L;
        this.sidingDepartureTime = -1L;
        this.vehicleExtraData.closeDoors();
        if (this.isCurrentlyManual && this.manualNotch > 0) {
            this.startUp(-1L, -1L);
        }
    }

    private void simulateAutomaticStopped(long millisElapsed, @Nullable ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>> vehiclePositions, int currentIndex) {
        if (this.isClientside) {
            return;
        }
        PathData pathData = (PathData)Utilities.getElement(this.vehicleExtraData.immutablePath, currentIndex);
        if (pathData == null) {
            return;
        }
        this.vehicleExtraData.setStoppingPoint(this.railProgress);
        this.stoppingCoolDown = 0L;
        if (this.railProgress == pathData.getStartDistance()) {
            long deviationAdjustment;
            boolean railClear;
            PathData currentPathData = (PathData)Utilities.getElement(this.vehicleExtraData.immutablePath, currentIndex - 1);
            PathData nextPathData = (PathData)Utilities.getElement(this.vehicleExtraData.immutablePath, this.vehicleExtraData.getRepeatIndex2() > 0 && currentIndex >= this.vehicleExtraData.getRepeatIndex2() ? this.vehicleExtraData.getRepeatIndex1() : currentIndex);
            boolean isOpposite = currentPathData != null && nextPathData != null && currentPathData.isOppositeRail(nextPathData);
            double nextStartDistance = nextPathData == null ? 0.0 : nextPathData.getStartDistance();
            long totalDwellMillis = currentPathData == null ? 0L : currentPathData.getDwellTime();
            long doorCloseTime = Math.max(totalDwellMillis / 2L, totalDwellMillis - 3200L - 1000L);
            boolean bl = railClear = this.railBlockedDistance(currentIndex, nextStartDistance + (isOpposite ? this.vehicleExtraData.getTotalVehicleLength() : 0.0), 0.0, vehiclePositions, this.elapsedDwellTime >= doorCloseTime, false) < 0.0;
            if (Utilities.isBetween(this.elapsedDwellTime, 1000.0, doorCloseTime)) {
                this.vehicleExtraData.openDoors();
            } else {
                this.vehicleExtraData.closeDoors();
            }
            if (this.siding != null && this.elapsedDwellTime > 4200L) {
                deviationAdjustment = this.deviation > 0L ? Math.min(this.deviation, Math.max(0L, doorCloseTime - this.elapsedDwellTime) * (long)this.siding.getDelayedVehicleReduceDwellTimePercentage() / 100L) : Math.max(this.deviation, -millisElapsed * (long)this.siding.getDelayedVehicleReduceDwellTimePercentage() / 100L);
                this.deviation -= deviationAdjustment;
            } else {
                deviationAdjustment = 0L;
            }
            if (this.elapsedDwellTime + millisElapsed < doorCloseTime || railClear) {
                this.elapsedDwellTime += millisElapsed + deviationAdjustment;
            }
            if (this.elapsedDwellTime >= totalDwellMillis && railClear) {
                if (currentPathData != null && Math.abs(currentPathData.getEndDistance() - this.railProgress) < 0.01) {
                    this.railProgress = nextStartDistance;
                    if (isOpposite) {
                        this.railProgress += this.vehicleExtraData.getTotalVehicleLength();
                        this.reversed = !this.reversed;
                    }
                }
                this.startUp(this.departureIndex, this.sidingDepartureTime);
            }
        } else if (this.railBlockedDistance(currentIndex, this.railProgress, 0.0, vehiclePositions, true, false) < 0.0) {
            this.startUp(this.departureIndex, this.sidingDepartureTime);
        }
    }

    private void simulateAutomaticMoving(long millisElapsed, @Nullable ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>> vehiclePositions, int currentIndex) {
        double stoppingPoint;
        double newAcceleration = this.vehicleExtraData.getAcceleration() * (double)millisElapsed;
        double newDeceleration = this.vehicleExtraData.getDeceleration() * (double)millisElapsed;
        double safeStoppingDistance = 0.5 * this.speed * this.speed / this.vehicleExtraData.getDeceleration();
        double railBlockedDistance = this.railBlockedDistance(currentIndex, this.railProgress, safeStoppingDistance, vehiclePositions, true, false);
        if (this.transportMode.continuousMovement) {
            stoppingPoint = Double.MAX_VALUE;
            if (this.vehicleExtraData.immutablePath.get(currentIndex).getDwellTime() > 0L) {
                this.vehicleExtraData.openDoors();
            } else {
                this.vehicleExtraData.closeDoors();
            }
        } else if (this.isClientside || this.stoppingCoolDown > 0L) {
            stoppingPoint = this.vehicleExtraData.getStoppingPoint();
        } else if (railBlockedDistance < 0.0) {
            stoppingPoint = this.nextStoppingIndex >= (long)(this.vehicleExtraData.immutablePath.size() - 1) ? this.vehicleExtraData.getTotalDistance() - (this.vehicleExtraData.getRepeatIndex2() > 0 ? 0.0 : (this.vehicleExtraData.getRailLength() - this.vehicleExtraData.getTotalVehicleLength()) / 2.0) : this.vehicleExtraData.immutablePath.get((int)this.nextStoppingIndex).getEndDistance();
        } else {
            stoppingPoint = railBlockedDistance + this.railProgress;
            this.stoppingCoolDown = 1000L;
        }
        this.vehicleExtraData.setStoppingPoint(stoppingPoint);
        double stoppingDistance = stoppingPoint - this.railProgress;
        if (!this.isClientside) {
            this.vehicleExtraData.setDelayedVehicleSpeedIncreasePercentage(0.0);
        }
        if (stoppingDistance < safeStoppingDistance) {
            this.speed = stoppingDistance <= 0.0 ? 4.0E-6 : Math.max(this.speed - 0.5 * this.speed * this.speed / stoppingDistance * (double)millisElapsed, 4.0E-6);
        } else {
            double railSpeed = this.getRailSpeed(currentIndex);
            if (this.speed < railSpeed) {
                this.speed = Math.min(this.speed + newAcceleration, railSpeed);
            } else if (this.speed > railSpeed) {
                this.speed = Math.max(this.speed - newDeceleration, railSpeed);
            }
            if (this.deviation > 0L && this.siding != null) {
                this.deviation -= (long)this.siding.getDelayedVehicleSpeedIncreasePercentage() * millisElapsed / 100L;
                this.vehicleExtraData.setDelayedVehicleSpeedIncreasePercentage(this.siding.getDelayedVehicleSpeedIncreasePercentage());
            }
        }
        this.railProgress += this.getAdjustedSpeed() * (double)millisElapsed;
        if (this.railProgress >= stoppingPoint) {
            this.railProgress = stoppingPoint;
            this.speed = 0.0;
        } else if (this.vehicleExtraData.getRepeatIndex2() > 0 && this.railProgress >= this.vehicleExtraData.getTotalDistance()) {
            this.railProgress = this.vehicleExtraData.immutablePath.get(this.vehicleExtraData.getRepeatIndex1()).getStartDistance() + this.railProgress - this.vehicleExtraData.getTotalDistance();
        }
    }

    private double getRailSpeed(int currentIndex) {
        PathData thisPathData = this.vehicleExtraData.immutablePath.get(currentIndex);
        double railSpeed = thisPathData.canAccelerate() ? thisPathData.getSpeedLimitMetersPerMillisecond() : (this.transportMode.continuousMovement ? this.transportMode.defaultSpeedMetersPerMillisecond : Math.max(this.transportMode.defaultSpeedMetersPerMillisecond, this.speed));
        return railSpeed;
    }

    private void writeVehiclePositions(int currentIndex, Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>> vehiclePositions) {
        int index;
        Position[] minMaxPositions = new Position[]{null, null};
        for (index = currentIndex; index >= 0; --index) {
            DoubleDoubleImmutablePair blockedBounds;
            PathData pathData = this.vehicleExtraData.immutablePath.get(index);
            Position position1 = pathData.getOrderedPosition1();
            Position position2 = pathData.getOrderedPosition2();
            minMaxPositions[0] = Position.getMin(minMaxPositions[0], Position.getMin(position1, position2));
            minMaxPositions[1] = Position.getMax(minMaxPositions[1], Position.getMax(position1, position2));
            if (this.railProgress - this.vehicleExtraData.getTotalVehicleLength() > pathData.getEndDistance()) break;
            if (this.transportMode.continuousMovement || !((blockedBounds = Vehicle.getBlockedBounds(pathData, this.railProgress - this.vehicleExtraData.getTotalVehicleLength(), this.railProgress - 0.01)).rightDouble() - blockedBounds.leftDouble() > 0.01) || !this.getIsOnRoute() || index <= 0) continue;
            Data.put(vehiclePositions, position1, position2, vehiclePosition -> {
                VehiclePosition newVehiclePosition = vehiclePosition == null ? new VehiclePosition() : vehiclePosition;
                newVehiclePosition.addSegment(blockedBounds.leftDouble(), blockedBounds.rightDouble(), this.id);
                return newVehiclePosition;
            }, Object2ObjectAVLTreeMap::new);
            pathData.isSignalBlocked(this.id, Rail.BlockReservation.CURRENTLY_RESERVE);
        }
        if (this.siding != null) {
            if (this.siding.area != null && this.data instanceof Simulator) {
                boolean needsUpdate = this.vehicleExtraData.checkForUpdate();
                int pathUpdateIndex = this.transportMode.continuousMovement ? 0 : Math.max(0, index + 1);
                ((Simulator)this.data).clients.values().forEach(client -> {
                    Position position = client.getPosition();
                    double updateRadius = client.getUpdateRadius();
                    if (minMaxPositions[0] == null || minMaxPositions[1] == null ? ((Depot)this.siding.area).inArea(position, updateRadius) : Utilities.isBetween(position, minMaxPositions[0], minMaxPositions[1], updateRadius)) {
                        client.update(this, needsUpdate, pathUpdateIndex);
                    }
                });
            }
            this.vehicleExtraData.setRoutePlatformInfo((Depot)this.siding.area, currentIndex);
        }
    }

    private double railBlockedDistance(int currentIndex, double checkRailProgress, double checkDistance, @Nullable ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>> vehiclePositions, boolean reserveRail, boolean secondPass) {
        for (int index = currentIndex; vehiclePositions != null && index < this.vehicleExtraData.immutablePath.size(); ++index) {
            PathData pathData = this.vehicleExtraData.immutablePath.get(index);
            double checkRailProgressEnd = checkRailProgress + checkDistance + (double)this.transportMode.stoppingSpace;
            if (pathData.getStartDistance() >= checkRailProgressEnd) {
                return -1.0;
            }
            if (this.checkAndBlockSignal(index, vehiclePositions, reserveRail, secondPass)) {
                return Math.max(0.0, pathData.getStartDistance() - checkRailProgress);
            }
            if (!Utilities.isIntersecting(pathData.getStartDistance(), pathData.getEndDistance(), checkRailProgress, checkRailProgressEnd)) continue;
            DoubleDoubleImmutablePair blockedBounds = Vehicle.getBlockedBounds(pathData, checkRailProgress, checkRailProgressEnd);
            for (int i = 0; i < 2; ++i) {
                double overlap;
                VehiclePosition vehiclePosition = (VehiclePosition)Data.tryGet((Map)vehiclePositions.get(i), pathData.getOrderedPosition1(), pathData.getOrderedPosition2());
                if (vehiclePosition == null || !((overlap = vehiclePosition.getOverlap(blockedBounds.leftDouble(), blockedBounds.rightDouble(), this.id)) >= 0.0)) continue;
                return Math.max(0.0, checkDistance - overlap);
            }
        }
        return -1.0;
    }

    private boolean checkAndBlockSignal(int currentIndex, ObjectArrayList<Object2ObjectAVLTreeMap<Position, Object2ObjectAVLTreeMap<Position, VehiclePosition>>> vehiclePositions, boolean reserveRail, boolean secondPass) {
        PathData firstPathData = this.vehicleExtraData.immutablePath.get(currentIndex);
        if (secondPass) {
            return firstPathData.isSignalBlocked(this.id, Rail.BlockReservation.DO_NOT_RESERVE);
        }
        IntAVLTreeSet signalColors = firstPathData.getSignalColors();
        for (int index = currentIndex + 1; !signalColors.isEmpty() && index < this.vehicleExtraData.immutablePath.size(); ++index) {
            PathData pathData = this.vehicleExtraData.immutablePath.get(index);
            if (!pathData.getSignalColors().intStream().noneMatch(signalColors::contains)) continue;
            double railBlockedDistance = this.railBlockedDistance(index, pathData.getStartDistance(), this.vehicleExtraData.getTotalVehicleLength(), vehiclePositions, false, true);
            return railBlockedDistance >= 0.0 && railBlockedDistance < this.vehicleExtraData.getTotalVehicleLength() || firstPathData.isSignalBlocked(this.id, reserveRail ? Rail.BlockReservation.PRE_RESERVE : Rail.BlockReservation.DO_NOT_RESERVE);
        }
        return false;
    }

    @Nullable
    private Vector getPosition(double value, DoubleArrayList overrideY) {
        PathData pathData = (PathData)Utilities.getElement(this.vehicleExtraData.immutablePath, Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, value));
        if (pathData == null) {
            return null;
        }
        Vector vector = pathData.getPosition(value - pathData.getStartDistance());
        if (this.transportMode == TransportMode.AIRPLANE && pathData.getSpeedLimitKilometersPerHour() == 900L && pathData.isDescending()) {
            if (overrideY.isEmpty()) {
                overrideY.add(vector.y);
                return vector;
            }
            return new Vector(vector.x, overrideY.getDouble(0), vector.z);
        }
        return vector;
    }

    private ObjectObjectImmutablePair<Vector, Vector> getBogiePositions(double value, DoubleArrayList overrideY) {
        double lowerBound = this.railProgress - this.vehicleExtraData.getTotalVehicleLength();
        double clampedValue = Utilities.clamp(value, lowerBound, this.railProgress);
        double clamp = Utilities.clamp(Math.min(Math.abs(clampedValue - lowerBound), Math.abs(clampedValue - this.railProgress)), 0.1, 1.0);
        double value1 = Utilities.clamp(clampedValue + (this.reversed ? -clamp : clamp), lowerBound, this.railProgress);
        double value2 = Utilities.clamp(clampedValue - (this.reversed ? -clamp : clamp), lowerBound, this.railProgress);
        Vector position1 = this.getPosition(value1, overrideY);
        Vector position2 = this.getPosition(value2, overrideY);
        return position1 == null || position2 == null ? new ObjectObjectImmutablePair<Vector, Vector>(new Vector(value1, 0.0, 0.0), new Vector(value2, 0.0, 0.0)) : new ObjectObjectImmutablePair<Vector, Vector>(position1, position2);
    }

    private static DoubleDoubleImmutablePair getBlockedBounds(PathData pathData, double lowerRailProgress, double upperRailProgress) {
        double distanceFromStart = Utilities.clamp(lowerRailProgress, pathData.getStartDistance(), pathData.getEndDistance()) - pathData.getStartDistance();
        double distanceToEnd = pathData.getEndDistance() - Utilities.clamp(upperRailProgress, pathData.getStartDistance(), pathData.getEndDistance());
        return new DoubleDoubleImmutablePair(pathData.reversePositions ? distanceToEnd : distanceFromStart, pathData.getEndDistance() - pathData.getStartDistance() - (pathData.reversePositions ? distanceFromStart : distanceToEnd));
    }
}

