/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.block.RenderShape;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum BlockRenderType {
    INVISIBLE(RenderShape.INVISIBLE),
    ENTITYBLOCK_ANIMATED(RenderShape.ENTITYBLOCK_ANIMATED),
    MODEL(RenderShape.MODEL);

    public final RenderShape data;

    private BlockRenderType(RenderShape data) {
        this.data = data;
    }

    public static BlockRenderType convert(@Nullable RenderShape data) {
        return data == null ? null : BlockRenderType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable BlockRenderType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static BlockRenderType getInvisibleMapped() {
        return BlockRenderType.convert(RenderShape.INVISIBLE);
    }

    @Nonnull
    @MappedMethod
    public static BlockRenderType getModelMapped() {
        return BlockRenderType.convert(RenderShape.MODEL);
    }

    @Nonnull
    @MappedMethod
    public static BlockRenderType getEntityblockAnimatedMapped() {
        return BlockRenderType.convert(RenderShape.ENTITYBLOCK_ANIMATED);
    }
}

