/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.GameMode;
import org.mtr.mapping.holder.Team;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class PlayerListEntry
extends HolderBase<PlayerInfo> {
    public PlayerListEntry(PlayerInfo data) {
        super(data);
    }

    @MappedMethod
    public static PlayerListEntry cast(HolderBase<?> data) {
        return new PlayerListEntry((PlayerInfo)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof PlayerInfo;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((PlayerInfo)this.data).equals(((HolderBase)data).data);
    }

    @Deprecated
    public PlayerListEntry(ClientboundPlayerInfoPacket.PlayerUpdate arg0) {
        super(new PlayerInfo(arg0));
    }

    @Nullable
    @MappedMethod
    public GameMode getGameMode() {
        GameType tempData = ((PlayerInfo)this.data).m_105325_();
        return tempData == null ? null : GameMode.convert(tempData);
    }

    @MappedMethod
    public int getLatency() {
        return ((PlayerInfo)this.data).m_105330_();
    }

    @Nullable
    @MappedMethod
    public Team getScoreboardTeam() {
        PlayerTeam tempData = ((PlayerInfo)this.data).m_105340_();
        return tempData == null ? null : new Team(tempData);
    }

    @Nullable
    @MappedMethod
    public Text getDisplayName() {
        Component tempData = ((PlayerInfo)this.data).m_105342_();
        return tempData == null ? null : new Text(tempData);
    }

    @Nonnull
    @MappedMethod
    public GameProfile getProfile() {
        return ((PlayerInfo)this.data).m_105312_();
    }

    @MappedMethod
    public void setDisplayName(@Nullable Text arg0) {
        ((PlayerInfo)this.data).m_105323_(arg0 == null ? null : (Component)arg0.data);
    }
}

