/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmlserverevents.FMLServerStartedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppingEvent;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.WorldChunk;

public final class MainEventBus {
    Consumer<MinecraftServer> serverStartingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStartedConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppedConsumer = minecraftServer -> {};
    Runnable startServerTickRunnable = () -> {};
    Runnable endServerTickRunnable = () -> {};
    Consumer<ServerWorld> startWorldTickRunnable = world -> {};
    Consumer<ServerWorld> endWorldTickRunnable = world -> {};
    BiConsumer<MinecraftServer, ServerPlayerEntity> playerJoinRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<MinecraftServer, ServerPlayerEntity> playerDisconnectRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<ServerWorld, WorldChunk> chunkLoadConsumer = (world, chunk) -> {};
    BiConsumer<ServerWorld, WorldChunk> chunkUnloadConsumer = (world, chunk) -> {};
    final List<Consumer<CommandDispatcher<CommandSourceStack>>> commands = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        this.serverStartingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent event) {
        this.serverStartedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        this.serverStoppingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent event) {
        this.serverStoppedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.startServerTickRunnable.run();
                break;
            }
            case END: {
                this.endServerTickRunnable.run();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.world instanceof ServerLevel) {
            switch (event.phase) {
                case START: {
                    this.startWorldTickRunnable.accept(new ServerWorld((ServerLevel)event.world));
                    break;
                }
                case END: {
                    this.endWorldTickRunnable.accept(new ServerWorld((ServerLevel)event.world));
                }
            }
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player playerEntity = event.getPlayer();
        Player player = playerEntity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            this.playerJoinRunnable.accept(new MinecraftServer(serverPlayerEntity.f_8924_), new ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player playerEntity = event.getPlayer();
        Player player = playerEntity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            this.playerDisconnectRunnable.accept(new MinecraftServer(serverPlayerEntity.f_8924_), new ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkLoadConsumer.accept(new ServerWorld((ServerLevel)event.getWorld()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkUnloadConsumer.accept(new ServerWorld((ServerLevel)event.getWorld()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        this.commands.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }
}

