/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.mtr.mapping.holder.SpriteProvider;
import org.mtr.mapping.mapper.ParticleFactoryExtension;
import org.mtr.mapping.registry.ParticleTypeRegistryObject;

public final class ModEventBusClient {
    Runnable resourceReloadRunnable = () -> {};
    final List<Runnable> clientObjectsToRegister = new ArrayList<Runnable>();
    final List<Runnable> clientObjectsToRegisterQueued = new ArrayList<Runnable>();
    final List<Consumer<EntityRenderersEvent.RegisterRenderers>> blockEntityRenderers = new ArrayList<Consumer<EntityRenderersEvent.RegisterRenderers>>();
    final List<Consumer<ColorHandlerEvent.Block>> blockColors = new ArrayList<Consumer<ColorHandlerEvent.Block>>();
    final List<Consumer<ColorHandlerEvent.Item>> itemColors = new ArrayList<Consumer<ColorHandlerEvent.Item>>();
    final List<Tuple<ParticleTypeRegistryObject, Function<SpriteProvider, ParticleFactoryExtension>>> particleFactories = new ArrayList<Tuple<ParticleTypeRegistryObject, Function<SpriteProvider, ParticleFactoryExtension>>>();

    @SubscribeEvent
    public void registerClient(FMLClientSetupEvent event) {
        this.clientObjectsToRegister.forEach(Runnable::run);
        event.enqueueWork(() -> this.clientObjectsToRegisterQueued.forEach(Runnable::run));
    }

    @SubscribeEvent
    public void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        this.blockEntityRenderers.forEach(consumer -> consumer.accept(event));
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        this.blockColors.forEach(consumer -> consumer.accept(event));
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        this.itemColors.forEach(consumer -> consumer.accept(event));
    }

    @SubscribeEvent
    public void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        this.particleFactories.forEach(tuple -> Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)((ParticleTypeRegistryObject)tuple.m_14418_()).get().data, spriteProvider -> (ParticleProvider)((Function)tuple.m_14419_()).apply(new SpriteProvider(spriteProvider))));
    }

    @SubscribeEvent
    public void resourceReload(TextureStitchEvent.Post event) {
        if (event.getMap().m_118330_().m_135815_().endsWith("blocks.png")) {
            this.resourceReloadRunnable.run();
        }
    }
}

