/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.obj;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mtr.libraries.de.javagl.obj.FloatTuple;
import org.mtr.libraries.de.javagl.obj.Mtl;
import org.mtr.libraries.de.javagl.obj.MtlReader;
import org.mtr.libraries.de.javagl.obj.Obj;
import org.mtr.libraries.de.javagl.obj.ObjFace;
import org.mtr.libraries.de.javagl.obj.ObjReader;
import org.mtr.libraries.de.javagl.obj.ObjSplitting;
import org.mtr.libraries.de.javagl.obj.ObjUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.model.Face;
import org.mtr.mapping.render.model.RawMesh;
import org.mtr.mapping.render.obj.AtlasManager;
import org.mtr.mapping.render.vertex.Vertex;
import org.mtr.mapping.tool.DummyClass;

public final class ObjModelLoader {
    public static Map<String, List<RawMesh>> loadModel(String objString, Function<String, String> mtlResolver, Function<String, Identifier> textureResolver, AtlasManager atlasManager, boolean splitModel) {
        HashMap<String, List<RawMesh>> result = new HashMap<String, List<RawMesh>>();
        try {
            Obj sourceObj = ObjReader.read(IOUtils.toInputStream((String)objString, (Charset)StandardCharsets.UTF_8));
            HashMap<String, Mtl> materials = new HashMap<String, Mtl>();
            sourceObj.getMtlFileNames().forEach(mtlFileName -> {
                try {
                    MtlReader.read(IOUtils.toInputStream((String)((String)mtlResolver.apply(mtlFileName.replace("\\\\", "/").replace("\\", "/"))), (Charset)StandardCharsets.UTF_8)).forEach(mtl -> materials.put(mtl.getName(), (Mtl)mtl));
                }
                catch (Exception e) {
                    DummyClass.logException(e);
                }
            });
            if (splitModel) {
                ObjSplitting.splitByGroups(sourceObj).forEach((key, obj) -> result.put((String)key, ObjModelLoader.loadModel(obj, materials, textureResolver, atlasManager)));
            } else {
                result.put("", ObjModelLoader.loadModel(sourceObj, materials, textureResolver, atlasManager));
            }
        }
        catch (Exception e) {
            DummyClass.logException(e);
        }
        return result;
    }

    private static List<RawMesh> loadModel(Obj sourceObj, Map<String, Mtl> materials, Function<String, Identifier> textureResolver, AtlasManager atlasManager) {
        ArrayList<RawMesh> rawMeshes = new ArrayList<RawMesh>();
        ObjSplitting.splitByMaterialGroups(sourceObj).forEach((key, obj) -> {
            if (obj.getNumFaces() > 0) {
                int i;
                Integer color;
                String texture;
                Map<String, String> materialOptions = ObjModelLoader.splitMaterialOptions(key);
                String materialGroupName = materialOptions.get("");
                OptimizedModel.ShaderType shaderType = ObjModelLoader.legacyMapping(materialOptions.getOrDefault("#", ""));
                boolean flipTextureV = materialOptions.getOrDefault("flipv", "0").equals("1");
                if (!materials.isEmpty()) {
                    Mtl objMaterial = materials.getOrDefault(key, null);
                    if (objMaterial == null) {
                        texture = "";
                        color = null;
                    } else {
                        texture = StringUtils.isEmpty((CharSequence)objMaterial.getMapKd()) ? "" : objMaterial.getMapKd();
                        FloatTuple kd = objMaterial.getKd();
                        color = kd == null ? ObjModelLoader.mergeColor(255, 255, 255, 255) : ObjModelLoader.mergeColor((int)(kd.getX() * 255.0f), (int)(kd.getY() * 255.0f), (int)(kd.getZ() * 255.0f), objMaterial.getD() == null ? 255 : (int)(objMaterial.getD().floatValue() * 255.0f));
                    }
                } else {
                    texture = materialGroupName.equals("_") ? "" : materialGroupName;
                    color = ObjModelLoader.mergeColor(255, 255, 255, 255);
                }
                Obj renderObjMesh = ObjUtils.convertToRenderable(obj);
                RawMesh mesh = new RawMesh(new MaterialProperties(shaderType, (Identifier)textureResolver.apply(texture.replace("\\\\", "/").replace("\\", "/")), color));
                for (i = 0; i < renderObjMesh.getNumVertices(); ++i) {
                    FloatTuple pos = renderObjMesh.getVertex(i);
                    FloatTuple normal = i < renderObjMesh.getNumNormals() ? renderObjMesh.getNormal(i) : ZeroFloatTuple.ZERO3;
                    FloatTuple uv = i < renderObjMesh.getNumTexCoords() ? renderObjMesh.getTexCoord(i) : ZeroFloatTuple.ZERO2;
                    Vertex seVertex = new Vertex();
                    seVertex.position = new Vector3f(pos.getX(), pos.getY(), pos.getZ());
                    seVertex.normal = new Vector3f(normal.getX(), normal.getY(), normal.getZ());
                    seVertex.u = uv.getX();
                    seVertex.v = flipTextureV ? 1.0f - uv.getY() : uv.getY();
                    mesh.vertices.add(seVertex);
                }
                for (i = 0; i < renderObjMesh.getNumFaces(); ++i) {
                    ObjFace face = renderObjMesh.getFace(i);
                    mesh.faces.add(new Face(new int[]{face.getVertexIndex(0), face.getVertexIndex(1), face.getVertexIndex(2)}));
                }
                atlasManager.applyToMesh(mesh);
                mesh.validateVertexIndex();
                rawMeshes.add(mesh);
            }
        });
        return rawMeshes;
    }

    private static Map<String, String> splitMaterialOptions(String source2) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] majorParts = source2.split("#", 2);
        result.put("", majorParts[0]);
        if (majorParts.length > 1) {
            for (String minorPart : majorParts[1].split(",")) {
                String[] tokens = minorPart.split("=", 2);
                if (tokens.length > 1) {
                    result.put(tokens[0], tokens[1]);
                    continue;
                }
                if (!result.containsKey("#")) {
                    result.put("#", tokens[0]);
                    continue;
                }
                result.put(tokens[0].toLowerCase(Locale.ROOT), "1");
            }
        }
        return result;
    }

    private static int mergeColor(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static Identifier resolveRelativePath(Identifier baseFile, String relative, @Nullable String expectExtension) {
        Object result = relative.toLowerCase(Locale.ROOT).replace('\\', '/');
        if (((String)result).contains(":")) {
            result = ((String)result).replaceAll("[^a-z0-9/.:_-]", "_");
            return new Identifier((String)result);
        }
        if (((String)(result = ((String)result).replaceAll("[^a-z0-9/._-]", "_"))).endsWith(".jpg") || ((String)result).endsWith(".bmp") || ((String)result).endsWith(".tga")) {
            result = ((String)result).substring(0, ((String)result).length() - 4) + ".png";
        }
        if (expectExtension != null && !((String)result).endsWith(expectExtension)) {
            result = (String)result + expectExtension;
        }
        return new Identifier(baseFile.getNamespace(), FileSystems.getDefault().getPath(baseFile.getPath(), new String[0]).getParent().resolve((String)result).normalize().toString().replace('\\', '/'));
    }

    private static OptimizedModel.ShaderType legacyMapping(String type) {
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "light": {
                return OptimizedModel.ShaderType.CUTOUT_GLOWING;
            }
            case "always_on_light": {
                return OptimizedModel.ShaderType.TRANSLUCENT_GLOWING;
            }
            case "interior": {
                return OptimizedModel.ShaderType.CUTOUT_BRIGHT;
            }
            case "interior_translucent": {
                return OptimizedModel.ShaderType.TRANSLUCENT_BRIGHT;
            }
        }
        return OptimizedModel.ShaderType.CUTOUT;
    }

    private static class ZeroFloatTuple
    implements FloatTuple {
        private final int dimensions;
        public static final ZeroFloatTuple ZERO2 = new ZeroFloatTuple(2);
        public static final ZeroFloatTuple ZERO3 = new ZeroFloatTuple(3);

        public ZeroFloatTuple(int dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public float getX() {
            return 0.0f;
        }

        @Override
        public float getY() {
            return 0.0f;
        }

        @Override
        public float getZ() {
            return 0.0f;
        }

        @Override
        public float getW() {
            return 0.0f;
        }

        @Override
        public float get(int index) {
            return 0.0f;
        }

        @Override
        public int getDimensions() {
            return this.dimensions;
        }
    }
}

