/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.tool;

import com.mojang.math.Matrix3f;
import com.mojang.math.Vector4f;
import java.nio.FloatBuffer;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.render.shader.ModShaderHandler;
import org.mtr.mapping.render.tool.GlStateTracker;

public final class Utilities {
    public static int exchangeLightmapUVBits(int light) {
        return light >>> 16 | (short)light << 16;
    }

    public static Matrix4f create() {
        Matrix4f matrix4f = new Matrix4f();
        ((com.mojang.math.Matrix4f)matrix4f.data).m_27624_();
        return matrix4f;
    }

    public static Matrix4f copy(Matrix4f matrix4f) {
        return new Matrix4f(new com.mojang.math.Matrix4f((com.mojang.math.Matrix4f)matrix4f.data));
    }

    public static void store(Matrix4f matrix4f, FloatBuffer buffer) {
        ((com.mojang.math.Matrix4f)matrix4f.data).m_27650_(buffer);
    }

    public static Vector3f transformPosition(Matrix4f matrix4f, Vector3f src) {
        Vector4f vector4f = new Vector4f(src.getX(), src.getY(), src.getZ(), 1.0f);
        vector4f.m_123607_((com.mojang.math.Matrix4f)matrix4f.data);
        return new Vector3f(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_());
    }

    public static Vector3f transformDirection(Matrix4f matrix4f, Vector3f src) {
        Vector3f vector3f = Utilities.copy(src);
        ((com.mojang.math.Vector3f)vector3f.data).m_122249_(new Matrix3f((com.mojang.math.Matrix4f)matrix4f.data));
        return vector3f;
    }

    public static Vector3f copy(Vector3f vector3f) {
        return new Vector3f(vector3f.getX(), vector3f.getY(), vector3f.getZ());
    }

    public static boolean canUseCustomShader() {
        return ModShaderHandler.getInternalHandler().noShaderPackInUse() && !GlStateTracker.isGl4ES();
    }
}

