/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockTrainPoweredSensorBase;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.data.ArrivalsCacheClient;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;

public class BlockTrainScheduleSensor
extends BlockTrainPoweredSensorBase {
    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockTrainSensorBase.BlockEntityBase {
        private int seconds = 10;
        private boolean realtimeOnly = false;
        private static final String KEY_SECONDS = "seconds";
        private static final String KEY_REALTIME_ONLY = "realtime_only";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.TRAIN_SCHEDULE_SENSOR.get(), pos, state);
        }

        @Override
        public void blockEntityTick() {
            BlockEntity.tick(this.getWorld2(), this.getPos2(), this);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.seconds = compoundTag.getInt(KEY_SECONDS);
            this.realtimeOnly = compoundTag.getBoolean(KEY_REALTIME_ONLY);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putInt(KEY_SECONDS, this.seconds);
            compoundTag.putBoolean(KEY_REALTIME_ONLY, this.realtimeOnly);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly, int seconds, boolean realtimeOnly) {
            this.seconds = seconds;
            this.realtimeOnly = realtimeOnly;
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public int getSeconds() {
            return this.seconds;
        }

        public boolean getRealtimeOnly() {
            return this.realtimeOnly;
        }

        public static <T extends BlockEntityExtension> void tick(@Nullable World world, BlockPos pos, T blockEntity) {
            if (world != null && world.isClient() && blockEntity instanceof BlockEntity) {
                InitClient.findClosePlatform(pos.up(), 5, platform -> {
                    ObjectArrayList<ArrivalResponse> arrivalResponseList = ArrivalsCacheClient.INSTANCE.requestArrivals(LongArrayList.of(new long[]{platform.getId()}));
                    for (ArrivalResponse arrival : arrivalResponseList) {
                        if (((BlockEntity)blockEntity).realtimeOnly && !arrival.getRealtime() || !BlockTrainSensorBase.matchesFilter(world, pos, arrival.getRouteId(), 1.0) || (arrival.getArrival() - ArrivalsCacheClient.INSTANCE.getMillisOffset() - System.currentTimeMillis()) / 1000L != (long)((BlockEntity)blockEntity).seconds) continue;
                        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketTurnOnBlockEntity(pos));
                        break;
                    }
                });
            }
        }
    }
}

