/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.Items;

public interface IBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.of("half", DoubleBlockHalf.class);
    public static final EnumProperty<EnumThird> THIRD = EnumProperty.of("third", EnumThird.class);
    public static final EnumProperty<EnumSide> SIDE_EXTENDED = EnumProperty.of("side", EnumSide.class);
    public static final EnumProperty<EnumSide> SIDE = EnumProperty.of("side", EnumSide.class, side -> side != EnumSide.MIDDLE && side != EnumSide.SINGLE);

    default public <T extends Comparable<T>> void propagate(World world, BlockPos pos, org.mtr.mapping.holder.Direction direction, org.mtr.mapping.holder.Property<T> property, int maxBlocksAway) {
        Object originalPropertyValue = IBlock.getStatePropertySafe(new BlockView((BlockGetter)world.data), pos, property);
        this.propagate(world, pos, direction, (BlockPos offsetPos) -> world.setBlockState((BlockPos)offsetPos, world.getBlockState((BlockPos)offsetPos).with(property, originalPropertyValue)), maxBlocksAway);
    }

    default public void propagate(World world, BlockPos pos, org.mtr.mapping.holder.Direction direction, Consumer<BlockPos> callback, int maxBlocksAway) {
        for (int i = 1; i <= maxBlocksAway; ++i) {
            BlockPos offsetPos = pos.offset(direction, i);
            if (this != world.getBlockState((BlockPos)offsetPos).getBlock().data) continue;
            callback.accept(offsetPos);
            this.propagate(world, offsetPos, direction, callback, maxBlocksAway);
            return;
        }
    }

    public static ActionResult checkHoldingBrush(World world, PlayerEntity player, Runnable callbackBrush, @Nullable Runnable callbackNoBrush) {
        return IBlock.checkHoldingItem(world, player, item -> callbackBrush.run(), callbackNoBrush, Items.BRUSH.get().asItem());
    }

    public static ActionResult checkHoldingItem(World world, PlayerEntity player, Consumer<Item> callbackItem, @Nullable Runnable callbackNoItem, Item ... items) {
        Item holdingItem = null;
        for (Item item : items) {
            if (!player.isHolding(item)) continue;
            holdingItem = item;
            break;
        }
        if (holdingItem != null) {
            if (!world.isClient()) {
                callbackItem.accept(holdingItem);
            }
            return ActionResult.SUCCESS;
        }
        if (callbackNoItem == null) {
            return ActionResult.FAIL;
        }
        if (!world.isClient()) {
            callbackNoItem.run();
            return ActionResult.CONSUME;
        }
        return ActionResult.SUCCESS;
    }

    public static ActionResult checkHoldingBrush(World world, PlayerEntity player, Runnable callbackBrush) {
        return IBlock.checkHoldingBrush(world, player, callbackBrush, null);
    }

    public static VoxelShape getVoxelShapeByDirection(double x1, double y1, double z1, double x2, double y2, double z2, org.mtr.mapping.holder.Direction facing) {
        switch (facing) {
            case NORTH: {
                return Block.createCuboidShape(x1, y1, z1, x2, y2, z2);
            }
            case EAST: {
                return Block.createCuboidShape(16.0 - z2, y1, x1, 16.0 - z1, y2, x2);
            }
            case SOUTH: {
                return Block.createCuboidShape(16.0 - x2, y1, 16.0 - z2, 16.0 - x1, y2, 16.0 - z1);
            }
            case WEST: {
                return Block.createCuboidShape(z1, y1, 16.0 - x2, z2, y2, 16.0 - x1);
            }
        }
        return VoxelShapes.fullCube();
    }

    public static boolean isReplaceable(ItemPlacementContext context, org.mtr.mapping.holder.Direction direction, int totalLength) {
        for (int i = 0; i < totalLength; ++i) {
            if (context.getWorld().getBlockState(context.getBlockPos().offset(direction, i)).canReplace(context)) continue;
            return false;
        }
        return true;
    }

    public static void onBreakCreative(World world, @Nullable PlayerEntity player, BlockPos pos) {
        if (!world.isClient() && (player == null || player.isCreative())) {
            world.setBlockState(pos, Blocks.getAirMapped().getDefaultState(), 35);
            BlockState state = world.getBlockState(pos);
            if (player != null) {
                world.syncWorldEvent(player, 2001, pos, Block.getRawIdFromState(state));
            }
        }
    }

    public static org.mtr.mapping.holder.Direction getSideDirection(BlockState state) {
        org.mtr.mapping.holder.Direction facing = IBlock.getStatePropertySafe(state, DirectionHelper.FACING);
        return IBlock.getStatePropertySafe(state, SIDE) == EnumSide.LEFT ? facing.rotateYClockwise() : facing.rotateYCounterclockwise();
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(BlockView world, BlockPos pos, org.mtr.mapping.holder.Property<T> property) {
        return IBlock.getStatePropertySafe(world.getBlockState(pos), property);
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(World world, BlockPos pos, org.mtr.mapping.holder.Property<T> property) {
        return IBlock.getStatePropertySafe(world.getBlockState(pos), property);
    }

    public static boolean getStatePropertySafe(World world, BlockPos pos, BooleanProperty property) {
        return (Boolean)IBlock.getStatePropertySafe(world.getBlockState(pos), new org.mtr.mapping.holder.Property((Property)property.data));
    }

    public static org.mtr.mapping.holder.Direction getStatePropertySafe(World world, BlockPos pos, DirectionProperty property) {
        return org.mtr.mapping.holder.Direction.convert((Direction)IBlock.getStatePropertySafe(world.getBlockState(pos), new org.mtr.mapping.holder.Property((Property)property.data)));
    }

    public static <T extends Enum<T>> T getStatePropertySafe(World world, BlockPos pos, EnumProperty<T> property) {
        return (T)((Enum)IBlock.getStatePropertySafe(world.getBlockState(pos), new org.mtr.mapping.holder.Property((Property)property.data)));
    }

    public static int getStatePropertySafe(World world, BlockPos pos, IntegerProperty property) {
        return (Integer)IBlock.getStatePropertySafe(world.getBlockState(pos), new org.mtr.mapping.holder.Property((Property)property.data));
    }

    public static boolean getStatePropertySafe(BlockState state, BooleanProperty property) {
        return (Boolean)IBlock.getStatePropertySafe(state, new org.mtr.mapping.holder.Property((Property)property.data));
    }

    public static org.mtr.mapping.holder.Direction getStatePropertySafe(BlockState state, DirectionProperty property) {
        return org.mtr.mapping.holder.Direction.convert((Direction)IBlock.getStatePropertySafe(state, new org.mtr.mapping.holder.Property((Property)property.data)));
    }

    public static <T extends Enum<T>> T getStatePropertySafe(BlockState state, EnumProperty<T> property) {
        return (T)((Enum)IBlock.getStatePropertySafe(state, new org.mtr.mapping.holder.Property((Property)property.data)));
    }

    public static int getStatePropertySafe(BlockState state, IntegerProperty property) {
        return (Integer)IBlock.getStatePropertySafe(state, new org.mtr.mapping.holder.Property((Property)property.data));
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(BlockState state, org.mtr.mapping.holder.Property<T> property) {
        try {
            return (T)(state.contains(property) ? state.get(property) : (Comparable)new ArrayList<T>(property.getValues()).get(0));
        }
        catch (Exception exception) {
            return (T)((Comparable)new ArrayList<T>(property.getValues()).get(0));
        }
    }

    public static enum EnumSide implements StringIdentifiable
    {
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        SINGLE("single");

        private final String name;

        private EnumSide(String name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static enum DoubleBlockHalf implements StringIdentifiable
    {
        UPPER("upper"),
        LOWER("lower");

        private final String name;

        private DoubleBlockHalf(String name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static enum EnumThird implements StringIdentifiable
    {
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private EnumThird(String name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

