/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.core.servlet.MessageQueue;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.AbstractTexture;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.RouteMapGenerator;
import org.mtr.mod.config.Config;
import org.mtr.mod.config.LanguageDisplay;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.MoreRenderLayers;

public class DynamicTextureCache
implements IGui {
    private Font font;
    private Font fontCjk;
    private final Object2ObjectLinkedOpenHashMap<String, DynamicResource> dynamicResources = new Object2ObjectLinkedOpenHashMap();
    private final ObjectOpenHashSet<String> generatingResources = new ObjectOpenHashSet();
    private final MessageQueue<Runnable> resourceRegistryQueue = new MessageQueue();
    private final Object2LongArrayMap<Identifier> deletedResources = new Object2LongArrayMap();
    public static DynamicTextureCache instance = new DynamicTextureCache();
    public static final float LINE_HEIGHT_MULTIPLIER = 1.25f;
    private static final int COOLDOWN_TIME = 10000;
    private static final Identifier DEFAULT_BLACK_RESOURCE = new Identifier("mtr", "textures/block/black.png");
    private static final Identifier DEFAULT_WHITE_RESOURCE = new Identifier("mtr", "textures/block/white.png");
    private static final Identifier DEFAULT_TRANSPARENT_RESOURCE = new Identifier("mtr", "textures/block/transparent.png");

    public void reload() {
        this.font = null;
        this.fontCjk = null;
        Init.LOGGER.debug("Refreshing dynamic resources; {} textures in memory; {} textures queued to be destroyed", (Object)this.dynamicResources.size(), (Object)this.deletedResources.size());
        this.dynamicResources.values().forEach(dynamicResource -> {
            dynamicResource.needsRefresh = true;
        });
        this.generatingResources.clear();
    }

    public void tick() {
        ObjectArrayList<String> keysToRemove = new ObjectArrayList<String>();
        this.dynamicResources.forEach((checkKey, checkDynamicResource) -> {
            if (checkDynamicResource.expiryTime < System.currentTimeMillis()) {
                checkDynamicResource.remove();
                this.deletedResources.put(checkDynamicResource.identifier, System.currentTimeMillis() + 10000L);
                keysToRemove.add((String)checkKey);
            }
        });
        keysToRemove.forEach(this.dynamicResources::remove);
        ObjectArrayList<Identifier> deletedResourcesToRemove = new ObjectArrayList<Identifier>();
        this.deletedResources.forEach((identifier, expiryTime) -> {
            if (expiryTime < System.currentTimeMillis()) {
                MinecraftClient.getInstance().getTextureManager().destroyTexture((Identifier)identifier);
                deletedResourcesToRemove.add((Identifier)identifier);
            }
        });
        deletedResourcesToRemove.forEach(this.deletedResources::removeLong);
    }

    public DynamicResource getPixelatedText(String text, int textColor, int maxWidth, double cjkSizeRatio, boolean fullPixel) {
        return this.getResource(String.format("pixelated_text_%s_%s_%s_%s_%s", text, textColor, maxWidth, cjkSizeRatio, fullPixel), () -> RouteMapGenerator.generatePixelatedText(text, textColor, maxWidth, cjkSizeRatio, fullPixel), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getColorStrip(long platformId) {
        return this.getResource(String.format("color_%s", platformId), () -> RouteMapGenerator.generateColorStrip(platformId), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationName(String stationName, float aspectRatio) {
        return this.getResource(String.format("station_name_%s_%s", stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationName(stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getTallStationName(int textColor, String stationName, int stationColor, float aspectRatio) {
        return this.getResource(String.format("tall_station_name_%s_%s_%s_%s", textColor, stationName, stationColor, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateTallStationName(textColor, stationName, stationColor, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNameEntrance(int textColor, String stationName, float aspectRatio) {
        return this.getResource(String.format("station_name_entrance_%s_%s_%s", textColor, stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationNameEntrance(textColor, stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getSingleRowStationName(long platformId, float aspectRatio) {
        return this.getResource(String.format("single_row_station_name_%s_%s", platformId, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateSingleRowStationName(platformId, aspectRatio), DefaultRenderingColor.WHITE);
    }

    public DynamicResource getSignText(String text, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        return this.getResource(String.format("sign_text_%s_%s_%s_%s_%s", new Object[]{text, horizontalAlignment, Float.valueOf(paddingScale), backgroundColor, textColor}), () -> RouteMapGenerator.generateSignText(text, horizontalAlignment, paddingScale, backgroundColor, textColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getLiftPanelDisplay(String originalText, int textColor) {
        return this.getResource(String.format("lift_panel_display_%s", originalText), () -> RouteMapGenerator.generateLiftPanel(originalText, textColor), DefaultRenderingColor.BLACK);
    }

    public DynamicResource getExitSignLetter(String exitLetter, String exitNumber, int backgroundColor) {
        return this.getResource(String.format("exit_sign_letter_%s_%s", exitLetter, exitNumber), () -> RouteMapGenerator.generateExitSignLetter(exitLetter, exitNumber, backgroundColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        return this.getResource(String.format("route_square_%s_%s_%s", new Object[]{color, routeName, horizontalAlignment}), () -> RouteMapGenerator.generateRouteSquare(color, routeName, horizontalAlignment), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("direction_arrow_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", new Object[]{platformId, hasLeft, hasRight, horizontalAlignment, showToString, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor}), () -> RouteMapGenerator.generateDirectionArrow(platformId, hasLeft, hasRight, horizontalAlignment, showToString, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("route_map_%s_%s_%s_%s_%s", platformId, vertical, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMap(platformId, vertical, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int fontSizeCjk, int fontSize) {
        return this.getTextPixels(text, dimensions, Integer.MAX_VALUE, (int)((float)Math.max(fontSizeCjk, fontSize) * 1.25f), fontSizeCjk, fontSize, 0, null);
    }

    public byte[] getTextPixels(String text, int[] dimensions, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, @Nullable IGui.HorizontalAlignment horizontalAlignment) {
        String[] tempTextSplit;
        if (maxWidth <= 0) {
            dimensions[0] = 0;
            dimensions[1] = 0;
            return new byte[0];
        }
        boolean oneRow = horizontalAlignment == null;
        String[] defaultTextSplit = IGui.textOrUntitled(text).split("\\|");
        String[] textSplit = Config.getClient().getLanguageDisplay() == LanguageDisplay.NORMAL ? defaultTextSplit : ((tempTextSplit = (String[])Arrays.stream(IGui.textOrUntitled(text).split("\\|")).filter(textPart -> IGui.isCjk(textPart) == (Config.getClient().getLanguageDisplay() == LanguageDisplay.CJK_ONLY)).toArray(String[]::new)).length == 0 ? defaultTextSplit : tempTextSplit);
        AttributedString[] attributedStrings = new AttributedString[textSplit.length];
        int[] textWidths = new int[textSplit.length];
        int[] fontSizes = new int[textSplit.length];
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        int width = 0;
        int height = 0;
        for (int index = 0; index < textSplit.length; ++index) {
            int newFontSize = IGui.isCjk(textSplit[index]) || this.font.canDisplayUpTo(textSplit[index]) >= 0 ? fontSizeCjk : fontSize;
            attributedStrings[index] = new AttributedString(textSplit[index]);
            fontSizes[index] = newFontSize;
            Font fontSized = this.font.deriveFont(0, newFontSize);
            Font fontCjkSized = this.fontCjk.deriveFont(0, newFontSize);
            for (int characterIndex = 0; characterIndex < textSplit[index].length(); ++characterIndex) {
                Font newFont;
                char character = textSplit[index].charAt(characterIndex);
                if (fontSized.canDisplay(character)) {
                    newFont = fontSized;
                } else if (fontCjkSized.canDisplay(character)) {
                    newFont = fontCjkSized;
                } else {
                    Font defaultFont = null;
                    for (Font testFont : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                        if (!testFont.canDisplay(character)) continue;
                        defaultFont = testFont;
                        break;
                    }
                    newFont = (defaultFont == null ? new Font(null) : defaultFont).deriveFont(0, newFontSize);
                }
                int n = index;
                textWidths[n] = textWidths[n] + newFont.getStringBounds((String)textSplit[index].substring((int)characterIndex, (int)(characterIndex + 1)), (FontRenderContext)context).getBounds().width;
                attributedStrings[index].addAttribute(TextAttribute.FONT, newFont, characterIndex, characterIndex + 1);
            }
            if (oneRow) {
                if (index > 0) {
                    width += padding;
                }
                width += textWidths[index];
                height = Math.max(height, (int)((float)fontSizes[index] * 1.25f));
                continue;
            }
            width = Math.max(width, Math.min(maxWidth, textWidths[index]));
            height += (int)((float)fontSizes[index] * 1.25f);
        }
        int textOffset = 0;
        int imageHeight = Math.min(height, maxHeight);
        BufferedImage image = new BufferedImage(width + (oneRow ? 0 : padding * 2), imageHeight + (oneRow ? 0 : padding * 2), 10);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int index = 0; index < textSplit.length; ++index) {
            if (oneRow) {
                graphics2D.drawString(attributedStrings[index].getIterator(), (float)textOffset, (float)height / 1.25f);
                textOffset += textWidths[index] + padding;
                continue;
            }
            float scaleY = (float)imageHeight / (float)height;
            float textWidth = Math.min((float)maxWidth, (float)textWidths[index] * scaleY);
            float scaleX = textWidth / (float)textWidths[index];
            AffineTransform stretch = new AffineTransform();
            stretch.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            graphics2D.setTransform(stretch);
            graphics2D.drawString(attributedStrings[index].getIterator(), horizontalAlignment.getOffset(0.0f, textWidth - (float)width) / scaleY + (float)padding / scaleX, (float)(textOffset + fontSizes[index]) + (float)padding / scaleY);
            textOffset += (int)((float)fontSizes[index] * 1.25f);
        }
        dimensions[0] = width + (oneRow ? 0 : padding * 2);
        dimensions[1] = imageHeight + (oneRow ? 0 : padding * 2);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        graphics2D.dispose();
        image.flush();
        return pixels;
    }

    private DynamicResource getResource(String key, Supplier<NativeImage> supplier, DefaultRenderingColor defaultRenderingColor) {
        this.resourceRegistryQueue.process(Runnable::run);
        DynamicResource dynamicResource = this.dynamicResources.get(key);
        if (dynamicResource != null && !dynamicResource.needsRefresh) {
            dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
            return dynamicResource;
        }
        if (this.generatingResources.contains(key)) {
            return defaultRenderingColor.dynamicResource;
        }
        MainRenderer.WORKER_THREAD.scheduleDynamicTextures(() -> {
            while (this.font == null) {
                ResourceManagerHelper.readResource(new Identifier("mtr", "font/noto-sans-semibold.ttf"), inputStream2 -> {
                    try {
                        this.font = Font.createFont(0, inputStream2);
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                });
            }
            while (this.fontCjk == null) {
                ResourceManagerHelper.readResource(new Identifier("mtr", "font/noto-serif-cjk-tc-semibold.ttf"), inputStream2 -> {
                    try {
                        this.fontCjk = Font.createFont(0, inputStream2);
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                });
            }
            NativeImage nativeImage = (NativeImage)supplier.get();
            this.resourceRegistryQueue.put(() -> {
                DynamicResource staticTextureProviderOld = this.dynamicResources.get(key);
                if (staticTextureProviderOld != null) {
                    staticTextureProviderOld.remove();
                    this.deletedResources.put(staticTextureProviderOld.identifier, System.currentTimeMillis() + 10000L);
                }
                if (nativeImage != null) {
                    NativeImageBackedTexture nativeImageBackedTexture = new NativeImageBackedTexture(nativeImage);
                    Identifier identifier = new Identifier("mtr", "id_" + Init.randomString());
                    MinecraftClient.getInstance().getTextureManager().registerTexture(identifier, new AbstractTexture((net.minecraft.client.renderer.texture.AbstractTexture)nativeImageBackedTexture.data));
                    DynamicResource dynamicResourceNew = new DynamicResource(identifier, nativeImageBackedTexture);
                    this.dynamicResources.put(key, dynamicResourceNew);
                }
                this.generatingResources.remove(key);
            });
        });
        RouteMapGenerator.setConstants();
        this.generatingResources.add(key);
        if (dynamicResource == null) {
            return defaultRenderingColor.dynamicResource;
        }
        dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
        dynamicResource.needsRefresh = false;
        return dynamicResource;
    }

    private static enum DefaultRenderingColor {
        BLACK(DEFAULT_BLACK_RESOURCE),
        WHITE(DEFAULT_WHITE_RESOURCE),
        TRANSPARENT(DEFAULT_TRANSPARENT_RESOURCE);

        private final DynamicResource dynamicResource;

        private DefaultRenderingColor(Identifier identifier) {
            this.dynamicResource = new DynamicResource(identifier, null);
        }
    }

    public static class DynamicResource {
        private long expiryTime;
        private boolean needsRefresh;
        public final int width;
        public final int height;
        public final Identifier identifier;

        private DynamicResource(Identifier identifier, @Nullable NativeImageBackedTexture nativeImageBackedTexture) {
            this.identifier = identifier;
            if (nativeImageBackedTexture != null) {
                NativeImage nativeImage = nativeImageBackedTexture.getImage();
                if (nativeImage != null) {
                    this.width = nativeImage.getWidth();
                    this.height = nativeImage.getHeight();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        private void remove() {
            MainRenderer.cancelRender(this.identifier);
            MoreRenderLayers.removeFromCache(this.identifier);
        }
    }
}

