/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.mtr.core.data.Data;
import org.mtr.core.data.PathData;
import org.mtr.core.data.Vehicle;
import org.mtr.core.operation.VehicleUpdate;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextColor;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockTrainAnnouncer;
import org.mtr.mod.block.BlockTrainRedstoneSensor;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.PersistentVehicleData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketCheckRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;
import org.mtr.mod.resource.VehicleResource;

public class VehicleExtension
extends Vehicle
implements Utilities {
    private double oldSpeed;
    public final PersistentVehicleData persistentVehicleData;

    public VehicleExtension(VehicleUpdate vehicleUpdate, Data data) {
        super(vehicleUpdate.getVehicleExtraData(), null, new JsonReader(Utilities.getJsonObjectFromData(vehicleUpdate.getVehicle())), data);
        PersistentVehicleData tempPersistentVehicleData = MinecraftClientData.getInstance().vehicleIdToPersistentVehicleData.get(this.getId());
        if (tempPersistentVehicleData == null) {
            this.persistentVehicleData = new PersistentVehicleData(this.vehicleExtraData.immutableVehicleCars, this.getTransportMode());
            MinecraftClientData.getInstance().vehicleIdToPersistentVehicleData.put(this.getId(), this.persistentVehicleData);
        } else {
            this.persistentVehicleData = tempPersistentVehicleData;
        }
    }

    public void updateData(@Nullable JsonObject jsonObject) {
        if (jsonObject != null) {
            this.updateData(new JsonReader(jsonObject.getAsJsonObject("vehicle")));
            this.vehicleExtraData.updateData(new JsonReader(jsonObject.getAsJsonObject("data")));
        }
    }

    public void simulate(long millisElapsed) {
        double oldRailProgress = this.railProgress;
        this.oldSpeed = this.speed;
        this.simulate(millisElapsed, null, null);
        this.persistentVehicleData.tick(this.railProgress, millisElapsed, this.vehicleExtraData);
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        int thisRouteColor = this.vehicleExtraData.getThisRouteColor();
        String thisRouteName = VehicleExtension.formatRouteName(this.vehicleExtraData.getThisRouteName());
        int nextRouteColor = this.vehicleExtraData.getNextRouteColor();
        String nextRouteName = VehicleExtension.formatRouteName(this.vehicleExtraData.getNextRouteName());
        String thisStationName = this.vehicleExtraData.getThisStationName();
        String nextStationName = this.vehicleExtraData.getNextStationName();
        String thisRouteDestination = this.vehicleExtraData.getThisRouteDestination();
        String nextRouteDestination = this.vehicleExtraData.getNextRouteDestination();
        long thisRouteId = this.vehicleExtraData.getThisRouteId();
        if (VehicleRidingMovement.isRiding(this.id)) {
            if (!(!VehicleRidingMovement.showShiftProgressBar() || this.isCurrentlyManual && VehicleExtension.isHoldingKey(clientPlayerEntity))) {
                double adjustedSpeed = this.getAdjustedSpeed();
                if (adjustedSpeed * 1000.0 > 5.0 || thisRouteName.isEmpty() || thisStationName.isEmpty() || thisRouteDestination.isEmpty()) {
                    clientPlayerEntity.sendMessage(TranslationProvider.GUI_MTR_VEHICLE_SPEED.getText(Utilities.round(adjustedSpeed * 1000.0, 1), Utilities.round(adjustedSpeed * (double)3.6f * 1000.0, 1)), true);
                } else {
                    MutableText text = switch ((int)(System.currentTimeMillis() / 1000L % 3L)) {
                        default -> VehicleExtension.getStationText(thisStationName, TranslationProvider.GUI_MTR_THIS_STATION_CJK, TranslationProvider.GUI_MTR_THIS_STATION);
                        case 1 -> {
                            if (nextStationName.isEmpty()) {
                                yield VehicleExtension.getStationText(thisStationName, TranslationProvider.GUI_MTR_THIS_STATION_CJK, TranslationProvider.GUI_MTR_THIS_STATION);
                            }
                            yield VehicleExtension.getStationText(nextStationName, TranslationProvider.GUI_MTR_NEXT_STATION_CJK, TranslationProvider.GUI_MTR_NEXT_STATION);
                        }
                        case 2 -> {
                            switch (this.transportMode) {
                                case TRAIN: {
                                    yield VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_TRAIN_STATION_CJK, TranslationProvider.GUI_MTR_LAST_TRAIN_STATION);
                                }
                                case BOAT: {
                                    yield VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_BOAT_STATION_CJK, TranslationProvider.GUI_MTR_LAST_BOAT_STATION);
                                }
                                case CABLE_CAR: {
                                    yield VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_CABLE_CAR_STATION_CJK, TranslationProvider.GUI_MTR_LAST_CABLE_CAR_STATION);
                                }
                                case AIRPLANE: {
                                    yield VehicleExtension.getStationText(thisRouteDestination, TranslationProvider.GUI_MTR_LAST_AIRPLANE_STATION_CJK, TranslationProvider.GUI_MTR_LAST_AIRPLANE_STATION);
                                }
                            }
                            yield TextHelper.literal("");
                        }
                    };
                    clientPlayerEntity.sendMessage(new Text((Component)text.data), true);
                }
            }
            if (this.persistentVehicleData.canAnnounce(oldRailProgress, this.railProgress)) {
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketCheckRouteIdHasDisabledAnnouncements(thisRouteId, routeIdHasDisabledAnnouncements -> {
                    if (!routeIdHasDisabledAnnouncements.booleanValue()) {
                        ObjectArrayList<String> narrateText = new ObjectArrayList<String>();
                        ObjectArrayList<MutableText> chatText = new ObjectArrayList<MutableText>();
                        if (!nextStationName.isEmpty()) {
                            String nextStationFormatted = IGui.insertTranslation(TranslationProvider.GUI_MTR_NEXT_STATION_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_NEXT_STATION_ANNOUNCEMENT, 1, nextStationName);
                            narrateText.add(nextStationFormatted);
                            chatText.add(TextHelper.literal(IGui.formatStationName(nextStationFormatted)));
                        }
                        ObjectArrayList narrateTextThisStation = new ObjectArrayList();
                        ObjectArrayList narrateTextOtherStations = new ObjectArrayList();
                        ObjectArrayList chatTextThisStation = new ObjectArrayList();
                        ObjectArrayList chatTextOtherStations = new ObjectArrayList();
                        this.vehicleExtraData.iterateInterchanges((stationName, interchangeColors) -> {
                            ObjectArrayList<String> combinedRouteNames = new ObjectArrayList<String>();
                            ObjectArrayList globalVisitedRouteNames = new ObjectArrayList();
                            boolean isThisStation = stationName.equals(nextStationName);
                            boolean[] addedStationName = new boolean[]{false};
                            interchangeColors.forEach((color, routeNames) -> {
                                ObjectArrayList visitedRouteNames = new ObjectArrayList();
                                routeNames.forEach(routeName -> {
                                    String routeNameFormatted = VehicleExtension.formatRouteName(routeName);
                                    if (!(routeName.isEmpty() || visitedRouteNames.contains(routeNameFormatted) || color == thisRouteColor && routeNameFormatted.equals(thisRouteName) || color == nextRouteColor && routeNameFormatted.equals(nextRouteName))) {
                                        if (!isThisStation && !addedStationName[0]) {
                                            chatTextOtherStations.add(TextHelper.literal(IGui.formatStationName(IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_ANNOUNCEMENT, 1, stationName))));
                                        }
                                        if (!globalVisitedRouteNames.contains(routeNameFormatted)) {
                                            combinedRouteNames.add(routeNameFormatted);
                                        }
                                        (isThisStation ? chatTextThisStation : chatTextOtherStations).add(TextHelper.append(TextHelper.setStyle(TextHelper.literal("-"), Style.getEmptyMapped().withColor(TextColor.fromRgb(color))), TextHelper.setStyle(TextHelper.literal(" " + IGui.formatStationName(routeNameFormatted)), Style.getEmptyMapped().withColor(TextFormatting.getWhiteMapped()))));
                                        addedStationName[0] = true;
                                        globalVisitedRouteNames.add(routeNameFormatted);
                                        visitedRouteNames.add(routeNameFormatted);
                                    }
                                });
                            });
                            if (addedStationName[0]) {
                                if (isThisStation) {
                                    narrateTextThisStation.add(IGui.insertTranslation(TranslationProvider.GUI_MTR_INTERCHANGE_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_INTERCHANGE_ANNOUNCEMENT, 1, VehicleExtension.getInterchangeText(combinedRouteNames)));
                                } else {
                                    narrateTextOtherStations.add(IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_PART_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_PART, 1, IGui.insertTranslation(TranslationProvider.GUI_MTR_CONNECTING_STATION_INTERCHANGE_ANNOUNCEMENT_PART_CJK, TranslationProvider.GUI_MTR_CONNECTING_STATION_INTERCHANGE_ANNOUNCEMENT_PART, 2, VehicleExtension.getInterchangeText(combinedRouteNames), stationName)));
                                }
                            }
                        });
                        narrateText.addAll(narrateTextThisStation);
                        narrateText.addAll(narrateTextOtherStations);
                        chatText.addAll(chatTextThisStation);
                        chatText.addAll(chatTextOtherStations);
                        if (!(nextRouteName.isEmpty() || nextRouteColor == thisRouteColor && nextRouteName.equals(thisRouteName))) {
                            String changeRouteText = IGui.insertTranslation(TranslationProvider.GUI_MTR_NEXT_ROUTE_TRAIN_ANNOUNCEMENT_CJK, TranslationProvider.GUI_MTR_NEXT_ROUTE_TRAIN_ANNOUNCEMENT, 2, nextRouteName, nextRouteDestination);
                            chatText.add(TextHelper.append(TextHelper.setStyle(TextHelper.literal("*"), Style.getEmptyMapped().withColor(TextColor.fromRgb(nextRouteColor))), TextHelper.setStyle(TextHelper.literal(" " + IGui.formatStationName(changeRouteText)), Style.getEmptyMapped().withColor(TextFormatting.getWhiteMapped()))));
                            narrateText.add(changeRouteText);
                        }
                        IDrawing.narrateOrAnnounce(IGui.formatStationName(IGui.mergeStations(narrateText, " ", " ")), chatText);
                    }
                }));
            }
        }
        Vector headPosition = this.getHeadPosition();
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    BlockEntity blockEntity;
                    BlockPos offsetBlockPos = Init.newBlockPos(headPosition.x + (double)xOffset, headPosition.y + (double)yOffset, headPosition.z + (double)zOffset);
                    BlockState blockState = clientWorld.getBlockState(offsetBlockPos);
                    Block block = blockState.getBlock();
                    if (!BlockTrainSensorBase.matchesFilter(new World((Level)clientWorld.data), offsetBlockPos, thisRouteId, this.speed)) continue;
                    if (block.data instanceof BlockTrainRedstoneSensor && IBlock.getStatePropertySafe(blockState, BlockTrainRedstoneSensor.POWERED) < 2) {
                        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketTurnOnBlockEntity(offsetBlockPos));
                        continue;
                    }
                    if (!(block.data instanceof BlockTrainAnnouncer) || !VehicleRidingMovement.isRiding(this.id) || (blockEntity = clientWorld.getBlockEntity(offsetBlockPos)) == null || !(blockEntity.data instanceof BlockTrainAnnouncer.BlockEntity)) continue;
                    ((BlockTrainAnnouncer.BlockEntity)blockEntity.data).announce();
                }
            }
        }
        double totalLength = 0.0;
        for (int i = 0; i < this.vehicleExtraData.immutableVehicleCars.size(); ++i) {
            int carNumber;
            int currentIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, oldRailProgress - totalLength);
            if (currentIndex < 0 || currentIndex >= this.vehicleExtraData.immutablePath.size()) continue;
            int n = carNumber = this.reversed ? this.vehicleExtraData.immutableVehicleCars.size() - i - 1 : i;
            if (this.speed * 1000.0 > 5.0 && Math.random() < 0.01) {
                this.persistentVehicleData.getOscillation(carNumber).startOscillation(Math.sqrt(this.speed) * Math.random());
            }
            if (this.railProgress - totalLength >= this.vehicleExtraData.immutablePath.get(currentIndex).getEndDistance()) {
                this.persistentVehicleData.getOscillation(carNumber).startOscillation(Math.sqrt(this.speed) * 2.0 * (Math.random() + 0.5));
            }
            totalLength += this.vehicleExtraData.immutableVehicleCars.get(carNumber).getLength();
        }
        double padding = 0.5 * this.speed * this.speed / this.vehicleExtraData.getDeceleration() + (double)this.transportMode.stoppingSpace;
        int headIndexPadded = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress + padding);
        int headIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress);
        int endIndex = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress - totalLength);
        int endIndexPadded = Utilities.getIndexFromConditionalList(this.vehicleExtraData.immutablePath, this.railProgress - totalLength - padding);
        for (int i = Math.max(0, endIndexPadded); i <= Math.min(this.vehicleExtraData.immutablePath.size() - 1, headIndexPadded); ++i) {
            PathData pathData = this.vehicleExtraData.immutablePath.get(i);
            if (i > endIndexPadded && i <= headIndex) {
                MinecraftClientData.getInstance().blockedRailIds.add(pathData.getHexId(false));
            }
            if (i >= headIndexPadded || i < endIndex) continue;
            MinecraftClientData.getInstance().blockedRailIds.add(pathData.getHexId(true));
        }
    }

    public void playMotorSound(VehicleResource vehicleResource, int carNumber, Vector bogiePosition) {
        this.persistentVehicleData.playMotorSound(vehicleResource, carNumber, Init.newBlockPos(bogiePosition.x, bogiePosition.y, bogiePosition.z), (float)this.speed, (float)(this.speed - this.oldSpeed), (float)this.vehicleExtraData.getAcceleration(), this.getIsOnRoute());
    }

    public void playDoorSound(VehicleResource vehicleResource, int carNumber, Vector vehiclePosition) {
        this.persistentVehicleData.playDoorSound(vehicleResource, carNumber, Init.newBlockPos(vehiclePosition.x, vehiclePosition.y, vehiclePosition.z));
    }

    public static boolean isHoldingKey(@Nullable ClientPlayerEntity clientPlayerEntity) {
        return clientPlayerEntity != null && clientPlayerEntity.isHolding(Items.DRIVER_KEY.get());
    }

    private static MutableText getStationText(String text, TranslationProvider.TranslationHolder keyCjk, TranslationProvider.TranslationHolder key) {
        return TextHelper.literal(text.isEmpty() ? "" : IGui.formatStationName(IGui.insertTranslation(keyCjk, key, 1, IGui.textOrUntitled(text))));
    }

    private static String formatRouteName(String routeName) {
        return routeName.split("\\|\\|")[0];
    }

    private static String getInterchangeText(ObjectArrayList<String> names) {
        ObjectArrayList<String> newNamesCjk = new ObjectArrayList<String>();
        ObjectArrayList<String> newNames = new ObjectArrayList<String>();
        names.forEach(name -> {
            for (String nameSplit : name.split("\\|")) {
                (IGui.isCjk(nameSplit) ? newNamesCjk : newNames).add(nameSplit);
            }
        });
        String combinedCjk = VehicleExtension.mergeNames(newNamesCjk, TranslationProvider.GUI_MTR_COMMA_CJK, TranslationProvider.GUI_MTR_COMMA_LAST_CJK);
        String combined = VehicleExtension.mergeNames(newNames, TranslationProvider.GUI_MTR_COMMA, TranslationProvider.GUI_MTR_COMMA_LAST);
        return String.format("%s%s%s", combinedCjk, !combinedCjk.isEmpty() && !combined.isEmpty() ? "|" : "", combined);
    }

    private static String mergeNames(ObjectArrayList<String> names, TranslationProvider.TranslationHolder keyComma, TranslationProvider.TranslationHolder keyCommaLast) {
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            stringBuilder.append(names.get(i));
            if (i <= names.size() - 3) {
                stringBuilder.append(keyComma.getString(new Object[0]));
                continue;
            }
            if (i != names.size() - 2) continue;
            stringBuilder.append(keyCommaLast.getString(new Object[0]));
        }
        return stringBuilder.toString();
    }

    public void dispose() {
        this.persistentVehicleData.dispose();
    }
}

