/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftFloor;
import org.mtr.core.data.Position;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockLiftTrackBase;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketOpenLiftCustomizationScreen;

public class ItemLiftRefresher
extends ItemExtension
implements DirectionHelper {
    public ItemLiftRefresher(ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
    }

    @Override
    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        ObjectOpenHashSet<BlockPos> blacklistedBlockPos;
        ObjectArrayList<LiftFloor> liftFloors1;
        World world = context.getWorld();
        PlayerEntity playerEntity = context.getPlayer();
        if (world.isClient() || playerEntity == null) {
            return super.useOnBlock2(context);
        }
        BlockPos blockPos = context.getBlockPos();
        if (!ItemLiftRefresher.findPath(world, blockPos, null, liftFloors1 = new ObjectArrayList<LiftFloor>(), new ObjectArrayList<Vector>(), blacklistedBlockPos = new ObjectOpenHashSet<BlockPos>(), true, false)) {
            playerEntity.sendMessage(TranslationProvider.GUI_MTR_LIFT_TRACK_REQUIRED.getText(new Object[0]), true);
            return ActionResult.getFailMapped();
        }
        blacklistedBlockPos.remove(blockPos);
        ObjectArrayList<LiftFloor> liftFloors2 = new ObjectArrayList<LiftFloor>();
        ItemLiftRefresher.findPath(world, blockPos, null, liftFloors2, new ObjectArrayList<Vector>(), blacklistedBlockPos, false, false);
        if (liftFloors1.isEmpty() && liftFloors2.isEmpty()) {
            return ActionResult.getFailMapped();
        }
        ObjectArrayList<LiftFloor> liftFloors = new ObjectArrayList<LiftFloor>();
        liftFloors.addAll((ObjectList<LiftFloor>)ItemLiftRefresher.reverseList(liftFloors1));
        liftFloors.addAll((ObjectList<LiftFloor>)liftFloors2);
        boolean needsReverse = ((LiftFloor)Utilities.getElement(liftFloors, -1)).getPosition().getY() < ((LiftFloor)Utilities.getElement(liftFloors, 0)).getPosition().getY();
        ItemLiftRefresher.sendUpdate(ServerWorld.cast(world), needsReverse ? ItemLiftRefresher.reverseList(liftFloors) : liftFloors);
        Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(playerEntity), new PacketOpenLiftCustomizationScreen(Init.positionToBlockPos(liftFloors.get(0).getPosition())));
        return ActionResult.getSuccessMapped();
    }

    public static ObjectArrayList<Vector> findPath(World world, Position startPosition, Position endPosition) {
        ObjectOpenHashSet<BlockPos> blacklistedBlockPos = new ObjectOpenHashSet<BlockPos>();
        BlockPos startBlockPos = Init.positionToBlockPos(startPosition);
        for (int i = 0; i < 2; ++i) {
            ObjectArrayList<LiftFloor> liftFloors = new ObjectArrayList<LiftFloor>();
            ObjectArrayList<Vector> liftTrackPositions = new ObjectArrayList<Vector>();
            if (!ItemLiftRefresher.findPath(world, startBlockPos, null, liftFloors, liftTrackPositions, blacklistedBlockPos, false, true)) continue;
            if (liftFloors.size() == 1 && liftFloors.get(0).getPosition().equals(endPosition)) {
                return liftTrackPositions;
            }
            blacklistedBlockPos.remove(startBlockPos);
        }
        return ObjectArrayList.of(new Vector[]{new Vector(startPosition.getX(), startPosition.getY(), startPosition.getZ()), new Vector(endPosition.getX(), endPosition.getY(), endPosition.getZ())});
    }

    private static boolean findPath(World world, BlockPos blockPos, @Nullable Direction direction, ObjectArrayList<LiftFloor> liftFloors, ObjectArrayList<Vector> liftTrackPositions, ObjectOpenHashSet<BlockPos> blacklistedBlockPos, boolean addFirstFloor, boolean findOneFloorOnly) {
        Direction connectingDirection;
        if (blacklistedBlockPos.contains(blockPos)) {
            return false;
        }
        blacklistedBlockPos.add(blockPos);
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (!(block.data instanceof BlockLiftTrackBase)) {
            return false;
        }
        ObjectArrayList<Direction> connectingDirections = ((BlockLiftTrackBase)block.data).getConnectingDirections(blockState);
        if (direction != null && !connectingDirections.contains((Object)direction.getOpposite())) {
            return false;
        }
        liftTrackPositions.add(((BlockLiftTrackBase)block.data).getCenterPoint(blockPos, blockState));
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (addFirstFloor && blockEntity != null && blockEntity.data instanceof BlockLiftTrackFloor.BlockEntity) {
            liftFloors.add(new LiftFloor(Init.blockPosToPosition(blockPos), ((BlockLiftTrackFloor.BlockEntity)((Object)blockEntity.data)).getFloorNumber(), ((BlockLiftTrackFloor.BlockEntity)((Object)blockEntity.data)).getFloorDescription()));
            if (findOneFloorOnly) {
                return true;
            }
        }
        ObjectIterator objectIterator = connectingDirections.iterator();
        while (objectIterator.hasNext() && !ItemLiftRefresher.findPath(world, blockPos.offset(connectingDirection = (Direction)((Object)objectIterator.next())), connectingDirection, liftFloors, liftTrackPositions, blacklistedBlockPos, true, findOneFloorOnly)) {
        }
        return true;
    }

    private static ObjectArrayList<LiftFloor> reverseList(ObjectArrayList<LiftFloor> liftFloors) {
        ObjectArrayList<LiftFloor> liftFloorsReversed = new ObjectArrayList<LiftFloor>();
        for (LiftFloor liftFloor : liftFloors) {
            liftFloorsReversed.add(0, liftFloor);
        }
        return liftFloorsReversed;
    }

    private static void sendUpdate(ServerWorld serverWorld, ObjectArrayList<LiftFloor> liftFloors) {
        Lift lift = new Lift(new MinecraftClientData());
        lift.setFloors(liftFloors);
        lift.setDimensions(3.0, 2.0, 2.0, 0.0, 0.0, 0.0);
        Init.sendMessageC2S("generate_by_lift", serverWorld.getServer(), new World((Level)serverWorld.data), lift, null, null);
    }
}

