/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Lift;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Siding;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockEyeCandy;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.block.BlockRailwaySign;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.block.BlockSignalBase;
import org.mtr.mod.block.BlockTrainAnnouncer;
import org.mtr.mod.block.BlockTrainScheduleSensor;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketOpenDashboardScreen;
import org.mtr.mod.screen.DashboardScreen;
import org.mtr.mod.screen.EditDepotScreen;
import org.mtr.mod.screen.EditStationScreen;
import org.mtr.mod.screen.EyeCandyScreen;
import org.mtr.mod.screen.LiftCustomizationScreen;
import org.mtr.mod.screen.LiftTrackFloorScreen;
import org.mtr.mod.screen.PIDSConfigScreen;
import org.mtr.mod.screen.PlatformScreen;
import org.mtr.mod.screen.RailModifierScreen;
import org.mtr.mod.screen.RailwaySignScreen;
import org.mtr.mod.screen.SidingScreen;
import org.mtr.mod.screen.SignalColorScreen;
import org.mtr.mod.screen.TicketMachineScreen;
import org.mtr.mod.screen.TrainAnnouncerScreen;
import org.mtr.mod.screen.TrainBasicSensorScreen;
import org.mtr.mod.screen.TrainScheduleSensorScreen;

public final class ClientPacketHelper {
    public static void openBlockEntityScreen(BlockPos blockPos) {
        ClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockTrainAnnouncer.BlockEntity) {
                ClientPacketHelper.openScreen(new TrainAnnouncerScreen(blockPos, (BlockTrainAnnouncer.BlockEntity)blockEntity.data), screenExtension -> screenExtension instanceof TrainAnnouncerScreen);
            } else if (blockEntity.data instanceof BlockTrainScheduleSensor.BlockEntity) {
                ClientPacketHelper.openScreen(new TrainScheduleSensorScreen(blockPos, (BlockTrainScheduleSensor.BlockEntity)((Object)((Object)blockEntity.data))), screenExtension -> screenExtension instanceof TrainScheduleSensorScreen);
            } else if (blockEntity.data instanceof BlockTrainSensorBase.BlockEntityBase) {
                ClientPacketHelper.openScreen(new TrainBasicSensorScreen(blockPos), screenExtension -> screenExtension instanceof TrainBasicSensorScreen);
            } else if (blockEntity.data instanceof BlockRailwaySign.BlockEntity || blockEntity.data instanceof BlockRouteSignBase.BlockEntityBase) {
                ClientPacketHelper.openScreen(new RailwaySignScreen(blockPos), screenExtension -> screenExtension instanceof RailwaySignScreen);
            } else if (blockEntity.data instanceof BlockLiftTrackFloor.BlockEntity) {
                ClientPacketHelper.openScreen(new LiftTrackFloorScreen(blockPos, (BlockLiftTrackFloor.BlockEntity)((Object)((Object)blockEntity.data))), screenExtension -> screenExtension instanceof LiftTrackFloorScreen);
            } else if (blockEntity.data instanceof BlockSignalBase.BlockEntityBase) {
                ClientPacketHelper.openScreen(new SignalColorScreen(blockPos, (BlockSignalBase.BlockEntityBase)((Object)((Object)blockEntity.data))), screenExtension -> screenExtension instanceof SignalColorScreen);
            } else if (blockEntity.data instanceof BlockEyeCandy.BlockEntity) {
                ClientPacketHelper.openScreen(new EyeCandyScreen(blockPos, (BlockEyeCandy.BlockEntity)((Object)((Object)blockEntity.data))), screenExtension -> screenExtension instanceof EyeCandyScreen);
            }
        });
    }

    public static void openDashboardScreen(TransportMode transportMode, PacketOpenDashboardScreen.ScreenType screenType, long id) {
        switch (screenType) {
            case STATION: {
                ClientPacketHelper.openScreen(new EditStationScreen((Station)MinecraftClientData.getDashboardInstance().stationIdMap.get(id), new DashboardScreen(transportMode)), screenExtension -> screenExtension instanceof EditStationScreen);
                break;
            }
            case DEPOT: {
                ClientPacketHelper.openScreen(new EditDepotScreen((Depot)MinecraftClientData.getDashboardInstance().depotIdMap.get(id), transportMode, new DashboardScreen(transportMode)), screenExtension -> screenExtension instanceof EditDepotScreen);
                break;
            }
            case PLATFORM: {
                ClientPacketHelper.openScreen(new PlatformScreen((Platform)MinecraftClientData.getDashboardInstance().platformIdMap.get(id), transportMode, new DashboardScreen(transportMode)), screenExtension -> screenExtension instanceof PlatformScreen);
                break;
            }
            case SIDING: {
                ClientPacketHelper.openScreen(new SidingScreen((Siding)MinecraftClientData.getDashboardInstance().sidingIdMap.get(id), transportMode, new DashboardScreen(transportMode)), screenExtension -> screenExtension instanceof SidingScreen);
                break;
            }
            default: {
                ClientPacketHelper.openScreen(new DashboardScreen(transportMode), screenExtension -> screenExtension instanceof DashboardScreen);
            }
        }
    }

    public static void openLiftCustomizationScreen(BlockPos blockPos) {
        for (Lift lift : MinecraftClientData.getInstance().lifts) {
            if (lift.getFloorIndex(Init.blockPosToPosition(blockPos)) < 0) continue;
            MinecraftClient.getInstance().openScreen(new Screen(new LiftCustomizationScreen(lift)));
            break;
        }
    }

    public static void openPIDSConfigScreen(BlockPos blockPos, int maxArrivals) {
        ClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockPIDSBase.BlockEntityBase) {
                ClientPacketHelper.openScreen(new PIDSConfigScreen(blockPos, maxArrivals), screenExtension -> screenExtension instanceof PIDSConfigScreen);
            }
        });
    }

    public static void openRailShapeModifierScreen(String railId) {
        ClientPacketHelper.openScreen(new RailModifierScreen(railId), screenExtension -> screenExtension instanceof RailModifierScreen);
    }

    public static void openTicketMachineScreen(int balance) {
        ClientPacketHelper.openScreen(new TicketMachineScreen(balance), screenExtension -> screenExtension instanceof TicketMachineScreen);
    }

    private static void openScreen(ScreenExtension screenExtension, Predicate<ScreenExtension> isInstance) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        Screen screen = minecraftClient.getCurrentScreenMapped();
        if (screen == null || screen.data instanceof ScreenExtension && !isInstance.test((ScreenExtension)((Object)screen.data))) {
            minecraftClient.openScreen(new Screen(screenExtension));
        }
    }

    private static void getBlockEntity(BlockPos blockPos, Consumer<BlockEntity> consumer) {
        BlockEntity blockEntity;
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null && (blockEntity = clientWorld.getBlockEntity(blockPos)) != null) {
            consumer.accept(blockEntity);
        }
    }
}

