/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.mapper.PersistenceStateExtension;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.data.PersistentStateData;

public final class PacketSetRouteIdHasDisabledAnnouncements
extends PacketHandler {
    private final long routeId;
    private final boolean isDisabled;

    public PacketSetRouteIdHasDisabledAnnouncements(PacketBufferReceiver packetBufferReceiver) {
        this.routeId = packetBufferReceiver.readLong();
        this.isDisabled = packetBufferReceiver.readBoolean();
    }

    public PacketSetRouteIdHasDisabledAnnouncements(long routeId, boolean isDisabled) {
        this.routeId = routeId;
        this.isDisabled = isDisabled;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.routeId);
        packetBufferSender.writeBoolean(this.isDisabled);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        PersistentStateData persistentStateData = (PersistentStateData)PersistenceStateExtension.register(serverPlayerEntity.getServerWorld(), PersistentStateData::new, "mtr");
        persistentStateData.setRouteIdHasDisabledAnnouncements(this.routeId, this.isDisabled);
    }
}

