/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import net.minecraft.world.level.Level;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockTrainPoweredSensorBase;
import org.mtr.mod.block.IBlock;

public final class PacketTurnOnBlockEntity
extends PacketHandler {
    private final BlockPos blockPos;

    public PacketTurnOnBlockEntity(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
    }

    public PacketTurnOnBlockEntity(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = new World((Level)serverPlayerEntity.getServerWorld().data);
        if (!Init.isChunkLoaded(world, this.blockPos)) {
            return;
        }
        BlockState blockState = world.getBlockState(this.blockPos);
        Block block = blockState.getBlock();
        if (block.data instanceof BlockTrainPoweredSensorBase && (IBlock.getStatePropertySafe(blockState, BlockTrainPoweredSensorBase.POWERED) <= 1 || !BlockExtension.hasScheduledBlockTick(world, this.blockPos, block))) {
            ((BlockTrainPoweredSensorBase)block.data).power(world, blockState, this.blockPos);
        }
    }
}

