/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.awt.Color;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.InterchangeColorsForStationName;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Frustum;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.EntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.ArrivalsCacheClient;
import org.mtr.mod.data.IGui;
import org.mtr.mod.entity.EntityRendering;
import org.mtr.mod.render.MoreRenderLayers;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.RenderVehicles;
import org.mtr.mod.render.WorkerThread;

public class MainRenderer
extends EntityRenderer<EntityRendering>
implements IGui {
    private static long lastRenderedMillis;
    public static final int PLAYER_RENDER_OFFSET = 1000;
    public static final WorkerThread WORKER_THREAD;
    private static final int FLASHING_INTERVAL = 1000;
    private static final int TOTAL_RENDER_STAGES = 2;
    private static final ObjectArrayList<ObjectArrayList<Object2ObjectArrayMap<Identifier, ObjectArrayList<BiConsumer<GraphicsHolder, Vector3d>>>>> RENDERS;
    private static final ObjectArrayList<ObjectArrayList<Object2ObjectArrayMap<Identifier, ObjectArrayList<BiConsumer<GraphicsHolder, Vector3d>>>>> CURRENT_RENDERS;

    public MainRenderer(EntityRenderer.Argument argument) {
        super(argument);
    }

    @Override
    public void render(EntityRendering entityRendering, float yaw, float tickDelta, GraphicsHolder graphicsHolder, int i) {
        MainRenderer.render(graphicsHolder, entityRendering.getCameraPosVec2(tickDelta));
    }

    @Override
    public boolean shouldRender2(EntityRendering entity, Frustum frustum, double x, double y, double z) {
        return true;
    }

    @Override
    @Nonnull
    public Identifier getTexture2(EntityRendering entityRendering) {
        return new Identifier("");
    }

    public static void render(GraphicsHolder graphicsHolder, Vector3d offset) {
        int j;
        int i;
        long millisElapsed;
        if (OptimizedRenderer.renderingShadows()) {
            if (Config.getClient().getDisableShadowsForShaders()) {
                return;
            }
            millisElapsed = 0L;
        } else {
            millisElapsed = MainRenderer.getMillisElapsed();
            MinecraftClientData.getInstance().blockedRailIds.clear();
            MinecraftClientData.getInstance().vehicles.forEach(vehicle -> vehicle.simulate(millisElapsed));
            MinecraftClientData.getInstance().lifts.forEach(lift -> lift.tick(millisElapsed));
            lastRenderedMillis = InitClient.getGameMillis();
            WORKER_THREAD.start();
            DynamicTextureCache.instance.tick();
            VehicleRidingMovement.tick();
            ArrivalsCacheClient.INSTANCE.tick();
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        Vector3d cameraShakeOffset = clientPlayerEntity.getPos().subtract(offset);
        RenderVehicles.render(millisElapsed, cameraShakeOffset);
        RenderLifts.render(millisElapsed, cameraShakeOffset);
        RenderRails.render();
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                CURRENT_RENDERS.get(i).get(j).clear();
                CURRENT_RENDERS.get(i).get(j).putAll((Map<Identifier, ObjectArrayList<BiConsumer<GraphicsHolder, Vector3d>>>)RENDERS.get(i).get(j));
                RENDERS.get(i).get(j).clear();
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < QueuedRenderLayer.values().length; ++j) {
                QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.values()[j];
                CURRENT_RENDERS.get(i).get(j).forEach((key, value) -> {
                    RenderLayer renderLayer = switch (queuedRenderLayer) {
                        case QueuedRenderLayer.LIGHT -> MoreRenderLayers.getLight(key, false);
                        case QueuedRenderLayer.LIGHT_TRANSLUCENT -> MoreRenderLayers.getLight(key, true);
                        case QueuedRenderLayer.LIGHT_2 -> MoreRenderLayers.getLight2(key);
                        case QueuedRenderLayer.INTERIOR -> MoreRenderLayers.getInterior(key);
                        case QueuedRenderLayer.INTERIOR_TRANSLUCENT -> MoreRenderLayers.getInteriorTranslucent(key);
                        case QueuedRenderLayer.EXTERIOR -> MoreRenderLayers.getExterior(key);
                        case QueuedRenderLayer.EXTERIOR_TRANSLUCENT -> MoreRenderLayers.getExteriorTranslucent(key);
                        case QueuedRenderLayer.LINES -> RenderLayer.getLines();
                        default -> null;
                    };
                    if (renderLayer != null) {
                        graphicsHolder.createVertexConsumer(renderLayer);
                    }
                    value.forEach(renderer -> renderer.accept(graphicsHolder, offset));
                });
            }
        }
        CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.render(!Config.getClient().getHideTranslucentParts());
    }

    public static void scheduleRender(@Nullable Identifier identifier, boolean priority, QueuedRenderLayer queuedRenderLayer, BiConsumer<GraphicsHolder, Vector3d> callback) {
        if (identifier != null) {
            RENDERS.get(priority ? 1 : 0).get(queuedRenderLayer.ordinal()).computeIfAbsent(identifier, key -> new ObjectArrayList()).add(callback);
        }
    }

    public static void scheduleRender(QueuedRenderLayer queuedRenderLayer, BiConsumer<GraphicsHolder, Vector3d> callback) {
        MainRenderer.scheduleRender(new Identifier(""), false, queuedRenderLayer, callback);
    }

    public static void cancelRender(Identifier identifier) {
        RENDERS.forEach((Consumer<ObjectArrayList<Object2ObjectArrayMap<Identifier, ObjectArrayList<BiConsumer<GraphicsHolder, Vector3d>>>>>)((Consumer<ObjectArrayList>)renderForPriority -> renderForPriority.forEach(renderForPriorityAndQueuedRenderLayer -> renderForPriorityAndQueuedRenderLayer.remove(identifier))));
        CURRENT_RENDERS.forEach((Consumer<ObjectArrayList<Object2ObjectArrayMap<Identifier, ObjectArrayList<BiConsumer<GraphicsHolder, Vector3d>>>>>)((Consumer<ObjectArrayList>)renderForPriority -> renderForPriority.forEach(renderForPriorityAndQueuedRenderLayer -> renderForPriorityAndQueuedRenderLayer.remove(identifier))));
    }

    public static String getInterchangeRouteNames(Consumer<BiConsumer<String, InterchangeColorsForStationName>> getInterchanges) {
        ObjectArrayList<String> interchangeRouteNames = new ObjectArrayList<String>();
        getInterchanges.accept((connectingStationName, interchangeColorsForStationName) -> interchangeColorsForStationName.forEach((color, interchangeRouteNamesForColor) -> interchangeRouteNamesForColor.forEach(interchangeRouteNames::add)));
        return IGui.mergeStationsWithCommas(interchangeRouteNames);
    }

    public static int getFlashingLight() {
        int light = (int)Math.round((Math.sin(Math.PI * 2 * (double)(System.currentTimeMillis() % 1000L) / 1000.0) + 1.0) / 2.0 * 15.0);
        return LightmapTextureManager.pack(light, light);
    }

    public static int getFlashingColor(int color, int multiplier) {
        double flashingProgress = (Math.sin(Math.PI * 2 * (double)(System.currentTimeMillis() % 1000L) / 1000.0) + 1.0) / 2.0;
        Color oldColor = new Color(color);
        return new Color((int)((double)oldColor.getRed() * Math.min(1.0, flashingProgress * (double)multiplier)), (int)((double)oldColor.getGreen() * Math.min(1.0, flashingProgress * (double)multiplier)), (int)((double)oldColor.getBlue() * Math.min(1.0, flashingProgress * (double)multiplier))).getRGB();
    }

    private static long getMillisElapsed() {
        long millisElapsed = InitClient.getGameMillis() - lastRenderedMillis;
        long gameMillisElapsed = (long)(MinecraftClient.getInstance().getLastFrameDuration() * 50.0f);
        return Math.abs(gameMillisElapsed - millisElapsed) < 50L ? gameMillisElapsed : millisElapsed;
    }

    static {
        WORKER_THREAD = new WorkerThread();
        RENDERS = new ObjectArrayList(2);
        CURRENT_RENDERS = new ObjectArrayList(2);
        for (int i = 0; i < 2; ++i) {
            int renderStageCount = QueuedRenderLayer.values().length;
            ObjectArrayList rendersList = new ObjectArrayList(renderStageCount);
            ObjectArrayList currentRendersList = new ObjectArrayList(renderStageCount);
            for (int j = 0; j < renderStageCount; ++j) {
                rendersList.add(j, new Object2ObjectArrayMap());
                currentRendersList.add(j, new Object2ObjectArrayMap());
            }
            RENDERS.add(i, rendersList);
            CURRENT_RENDERS.add(i, currentRendersList);
        }
    }
}

