/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockLiftButtons;
import org.mtr.mod.block.BlockLiftPanelBase;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.item.ItemLiftButtonsLinkModifier;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderLiftButtons;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderLiftPanel<T extends BlockLiftPanelBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private final boolean isOdd;
    private final boolean isFlat;
    private static final Identifier ARROW_TEXTURE = new Identifier("mtr", "textures/block/lift_arrow.png");
    private static final float ARROW_SPEED = 0.04f;
    private static final int SLIDE_TIME = 5;
    private static final int SLIDE_INTERVAL = 50;
    private static final float PANEL_WIDTH = 1.125f;

    public RenderLiftPanel(BlockEntityRenderer.Argument dispatcher, boolean isOdd, boolean isFlat) {
        super(dispatcher);
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    @Override
    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)blockEntity)).getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos trackPosition = ((BlockLiftPanelBase.BlockEntityBase)((Object)blockEntity)).getTrackPosition();
        if (trackPosition == null || !(world.getBlockState((BlockPos)trackPosition).getBlock().data instanceof BlockLiftTrackFloor)) {
            return;
        }
        BlockPos blockPos = ((BlockEntityAbstractMapping)((Object)blockEntity)).getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe(blockState, FACING);
        boolean holdingLinker = PlayerHelper.isHolding(PlayerEntity.cast(clientPlayerEntity), item -> item.data instanceof ItemLiftButtonsLinkModifier || Block.getBlockFromItem((Item)item).data instanceof BlockLiftButtons);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
        Direction trackFacing = IBlock.getStatePropertySafe(world, trackPosition, FACING);
        RenderLiftButtons.renderLiftObjectLink(storedMatrixTransformations1, world, new Vector3d((double)((float)facing.getOffsetX() / 2.0f) + (double)facing.rotateYClockwise().getOffsetX() * (this.isOdd ? 1.0 : 0.5), 0.5, (double)((float)facing.getOffsetZ() / 2.0f) + (double)facing.rotateYClockwise().getOffsetZ() * (this.isOdd ? 1.0 : 0.5)), new Vector3d((float)(trackPosition.getX() - blockPos.getX()) + (float)trackFacing.getOffsetX() / 2.0f, (double)(trackPosition.getY() - blockPos.getY()) + 0.5, (float)(trackPosition.getZ() - blockPos.getZ()) + (float)trackFacing.getOffsetZ() / 2.0f), holdingLinker);
        Lift lift = null;
        for (Lift checkLift : MinecraftClientData.getInstance().lifts) {
            if (checkLift.getFloorIndex(Init.blockPosToPosition(trackPosition)) < 0) continue;
            lift = checkLift;
            break;
        }
        if (lift != null) {
            String currentFloorNumber = RenderLifts.getLiftDetails(world, lift, trackPosition).right().left();
            ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = RenderLifts.getLiftDetails(world, lift, Init.positionToBlockPos(lift.getCurrentFloor().getPosition()));
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
            storedMatrixTransformations2.add(graphicsHolder -> {
                graphicsHolder.rotateYDegrees(-facing.asRotation());
                graphicsHolder.translate(this.isOdd ? -1.0 : -0.5, 0.0, 0.0);
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.translate(0.0, 0.0, (this.isFlat ? 0.4375f : 0.25f) - 0.00625f);
            });
            MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                storedMatrixTransformations2.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawStringWithFont(graphicsHolder, currentFloorNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0.0f, -0.47f, 0.1875f, 0.1875f, 1.0f, -16777216, false, GraphicsHolder.getDefaultLight(), null);
                graphicsHolder.pop();
            });
            this.renderLiftDisplay(storedMatrixTransformations2, liftDetails);
        }
    }

    private void renderLiftDisplay(StoredMatrixTransformations storedMatrixTransformations, ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails) {
        LiftDirection liftDirection = liftDetails.left();
        String floorNumber = liftDetails.right().left();
        String floorDescription = liftDetails.right().right();
        boolean noFloorNumber = floorNumber.isEmpty();
        boolean noFloorDisplay = floorDescription.isEmpty();
        int lineCount = (noFloorNumber ? 0 : floorNumber.split("\\|").length) + (noFloorDisplay ? 0 : floorDescription.split("\\|").length);
        float lineHeight = 1.0f / (float)lineCount;
        float gameTick = InitClient.getGameTick();
        boolean goingUp = liftDirection == LiftDirection.UP;
        float arrowSize = 0.1875f;
        float y = -0.3125f;
        if (liftDirection != LiftDirection.NONE) {
            float uv = gameTick * 0.04f % 1.0f;
            int color = goingUp ? -16711936 : -65536;
            MainRenderer.scheduleRender(ARROW_TEXTURE, false, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.75f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, Direction.UP, color, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolder, 0.5625f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, Direction.UP, color, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
        if (!noFloorNumber || !noFloorDisplay) {
            float uvOffset = 0.0f;
            if (lineCount > 1) {
                uvOffset = (float)Math.floor(gameTick % (float)(50 * lineCount) / 50.0f) * lineHeight;
                if (gameTick % 50.0f > 45.0f) {
                    uvOffset += lineHeight * (gameTick % 50.0f - 50.0f + 5.0f) / 5.0f;
                }
            }
            float uv = (float)(goingUp ? -1 : 1) * uvOffset;
            String text = String.format("%s%s%s", floorNumber, noFloorNumber || noFloorDisplay ? "" : "|", floorDescription);
            MainRenderer.scheduleRender(DynamicTextureCache.instance.getLiftPanelDisplay((String)text, (int)0xFFAA00).identifier, false, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.5625f, -0.3125f, 1.125f, 0.1875f, 0.0f, uv, 1.0f, lineHeight + uv, Direction.UP, -1, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }
}

