/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import net.minecraft.world.level.Level;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.LiftFloor;
import org.mtr.core.data.Position;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectBooleanImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.IGui;
import org.mtr.mod.item.ItemLiftRefresher;
import org.mtr.mod.model.ModelLift1;
import org.mtr.mod.model.ModelSmallCube;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderVehicleHelper;
import org.mtr.mod.render.RenderVehicleTransformationHelper;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderLifts
implements IGui {
    private static final int LIFT_DISPLAY_COLOR = -65536;
    private static final Identifier LIFT_TEXTURE = new Identifier("mtr", "textures/vehicle/lift_1.png");
    private static final ModelSmallCube MODEL_SMALL_CUBE = new ModelSmallCube(new Identifier("textures/block/redstone_block.png"));
    private static final float LIFT_DOOR_VALUE = 0.75f;
    private static final float LIFT_FLOOR_PADDING = 0.25f;

    public static void render(long millisElapsed, Vector3d cameraShakeOffset) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        ObjectArrayList cullingTasks = new ObjectArrayList();
        Vector3d cameraPosition = minecraftClient.getGameRendererMapped().getCamera().getPos();
        Vec3d camera = new Vec3d(cameraPosition.getXMapped(), cameraPosition.getYMapped(), cameraPosition.getZMapped());
        boolean canRide = !clientPlayerEntity.isSpectator();
        boolean isHoldingRefresher = clientPlayerEntity.isHolding(Items.LIFT_REFRESHER.get());
        MinecraftClientData.getInstance().liftWrapperList.values().forEach(liftWrapper -> {
            Lift lift = liftWrapper.getLift();
            if (isHoldingRefresher) {
                LiftFloor[] previousLiftFloor = new LiftFloor[]{null};
                lift.iterateFloors(liftFloor -> {
                    Position position = liftFloor.getPosition();
                    StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(position.getX(), position.getY(), position.getZ());
                    MODEL_SMALL_CUBE.render(storedMatrixTransformations, GraphicsHolder.getDefaultLight());
                    if (previousLiftFloor[0] != null) {
                        Position position1 = liftFloor.getPosition();
                        Position position2 = previousLiftFloor[0].getPosition();
                        MainRenderer.scheduleRender(QueuedRenderLayer.LINES, (graphicsHolder, offset) -> {
                            ObjectArrayList<Vector> trackPositions = ItemLiftRefresher.findPath(new World((Level)clientWorld.data), position1, position2);
                            for (int i = 1; i < trackPositions.size(); ++i) {
                                graphicsHolder.drawLineInWorld((float)(trackPositions.get((int)(i - 1)).x - offset.getXMapped() + 0.5), (float)(trackPositions.get((int)(i - 1)).y - offset.getYMapped() + 0.5), (float)(trackPositions.get((int)(i - 1)).z - offset.getZMapped() + 0.5), (float)(trackPositions.get((int)i).x - offset.getXMapped() + 0.5), (float)(trackPositions.get((int)i).y - offset.getYMapped() + 0.5), (float)(trackPositions.get((int)i).z - offset.getZMapped() + 0.5), -1);
                            }
                        });
                    }
                    previousLiftFloor[0] = liftFloor;
                });
            }
            RenderVehicleHelper.VehicleProperties vehicleProperties = RenderVehicleHelper.getTransformedVehiclePropertiesList(lift, ObjectArrayList.of(new RenderVehicleHelper.VehicleProperties[]{new RenderVehicleHelper.VehicleProperties(new ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>(new VehicleCar("", lift.getDepth(), lift.getWidth(), 0.0, 0.0, 0.0, 0.0), ObjectArrayList.of(new ObjectObjectImmutablePair[]{RenderLifts.getVirtualBogiePositions(clientWorld, lift)})), true)}), cameraShakeOffset).get(0);
            RenderVehicleTransformationHelper renderVehicleTransformationHelperAbsolute = vehicleProperties.renderVehicleTransformationHelperAbsolute;
            RenderVehicleTransformationHelper renderVehicleTransformationHelperOffset = vehicleProperties.renderVehicleTransformationHelperOffset;
            cullingTasks.add(occlusionCullingInstance -> {
                double longestDimension = Math.max(lift.getHeight(), Math.max(lift.getWidth(), lift.getDepth()));
                boolean shouldRender = occlusionCullingInstance.isAABBVisible(new Vec3d(renderVehicleTransformationHelperAbsolute.pivotPosition.x - longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.y - longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.z - longestDimension), new Vec3d(renderVehicleTransformationHelperAbsolute.pivotPosition.x + longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.y + longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.z + longestDimension), camera);
                return () -> {
                    liftWrapper.shouldRender = shouldRender;
                };
            });
            if (liftWrapper.shouldRender) {
                boolean doorway2Open;
                boolean doorway1Open;
                ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsAndDoorways = new ObjectArrayList<ObjectBooleanImmutablePair<Box>>();
                ObjectArrayList<Box> openDoorways = new ObjectArrayList<Box>();
                Box doorway1 = new Box(-0.75, 0.0, -lift.getDepth() / 2.0 + 0.25, 0.75, 0.0, -lift.getDepth() / 2.0);
                Box doorway2 = new Box(-0.75, 0.0, lift.getDepth() / 2.0 - 0.25, 0.75, 0.0, lift.getDepth() / 2.0);
                if (lift.hasCoolDown()) {
                    doorway1Open = RenderVehicleHelper.canOpenDoors(doorway1, renderVehicleTransformationHelperAbsolute, Math.min(lift.getDoorValue(), 0.75f) / 2.0f, true);
                    boolean bl = doorway2Open = lift.getIsDoubleSided() && RenderVehicleHelper.canOpenDoors(doorway2, renderVehicleTransformationHelperAbsolute, Math.min(lift.getDoorValue(), 0.75f) / 2.0f, true);
                    if (doorway1Open) {
                        openDoorways.add(doorway1);
                    }
                    if (doorway2Open) {
                        openDoorways.add(doorway2);
                    }
                } else {
                    doorway1Open = false;
                    doorway2Open = false;
                }
                if (canRide) {
                    Vector3d playerPosition = renderVehicleTransformationHelperAbsolute.transformBackwards(clientPlayerEntity.getPos(), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
                    VehicleRidingMovement.startRiding(openDoorways, 0L, lift.getId(), 0, playerPosition.getXMapped(), playerPosition.getYMapped(), playerPosition.getZMapped(), renderVehicleTransformationHelperAbsolute.yaw);
                    Box floor = new Box(-lift.getWidth() / 2.0 + 0.25, 0.0, -lift.getDepth() / 2.0 + 0.25, lift.getWidth() / 2.0 - 0.25, 0.0, lift.getDepth() / 2.0 - 0.25);
                    floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(floor, true));
                    RenderVehicleHelper.renderFloorOrDoorway(floor, -1, playerPosition, renderVehicleTransformationHelperOffset);
                    openDoorways.forEach(doorway -> {
                        floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>((Box)doorway, false));
                        RenderVehicleHelper.renderFloorOrDoorway(doorway, -65536, playerPosition, renderVehicleTransformationHelperOffset);
                    });
                }
                RenderVehicleHelper.renderModel(renderVehicleTransformationHelperOffset, 0.0, storedMatrixTransformations -> {
                    new ModelLift1((int)Math.round(lift.getHeight() * 2.0), (int)Math.round(lift.getWidth()), (int)Math.round(lift.getDepth()), lift.getIsDoubleSided()).render((StoredMatrixTransformations)storedMatrixTransformations, null, LIFT_TEXTURE, renderVehicleTransformationHelperOffset.light, doorway1Open ? lift.getDoorValue() / 0.75f : 0.0f, doorway2Open ? lift.getDoorValue() / 0.75f : 0.0f, false, 0, 1, true, true, false, true, false);
                    for (int i = 0; i < (lift.getIsDoubleSided() ? 2 : 1); ++i) {
                        boolean shouldRotate = i == 0;
                        StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
                        storedMatrixTransformationsNew.add(graphicsHolder -> {
                            if (shouldRotate) {
                                graphicsHolder.rotateYDegrees(180.0f);
                            }
                            graphicsHolder.translate(0.875, -1.5, lift.getDepth() / 2.0 - 0.25 - (double)0.003125f);
                        });
                        RenderLifts.renderLiftDisplay(storedMatrixTransformationsNew, new World((Level)clientWorld.data), lift, 0.1875f, 0.3125f);
                    }
                });
                if (canRide) {
                    VehicleRidingMovement.movePlayer(millisElapsed, lift.getId(), 0, floorsAndDoorways, null, null, null, renderVehicleTransformationHelperAbsolute);
                }
            }
        });
        if (!OptimizedRenderer.renderingShadows()) {
            MainRenderer.WORKER_THREAD.scheduleLifts(occlusionCullingInstance -> {
                ObjectArrayList tasks = new ObjectArrayList();
                cullingTasks.forEach(occlusionCullingInstanceRunnableFunction -> tasks.add((Runnable)occlusionCullingInstanceRunnableFunction.apply(occlusionCullingInstance)));
                minecraftClient.execute(() -> tasks.forEach(Runnable::run));
            });
        }
    }

    public static void renderLiftDisplay(StoredMatrixTransformations storedMatrixTransformations, World world, Lift lift, float width, float height) {
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = RenderLifts.getLiftDetails(world, lift, Init.positionToBlockPos(lift.getCurrentFloor().getPosition()));
        LiftDirection liftDirection = liftDetails.left();
        MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            IDrawing.drawStringWithFont(graphicsHolder, (String)((ObjectObjectImmutablePair)liftDetails.right()).left(), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0.0f, height, width, -1.0f, 18.0f / width, -65536, false, GraphicsHolder.getDefaultLight(), null);
            graphicsHolder.pop();
        });
        if (liftDirection != LiftDirection.NONE) {
            MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/lift_arrow.png"), false, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -width / 6.0f, 0.0f, width / 3.0f, width / 3.0f, 0.0f, liftDirection == LiftDirection.UP ? 0.0f : 1.0f, 1.0f, liftDirection == LiftDirection.UP ? 1.0f : 0.0f, Direction.UP, -65536, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }

    public static ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> getLiftDetails(World world, Lift lift, BlockPos blockPos) {
        String floorDescription;
        String floorNumber;
        LiftFloor liftFloor = lift.getCurrentFloor();
        BlockEntity floorEntity = world.getBlockEntity(blockPos);
        if (floorEntity != null && floorEntity.data instanceof BlockLiftTrackFloor.BlockEntity) {
            floorNumber = ((BlockLiftTrackFloor.BlockEntity)((Object)floorEntity.data)).getFloorNumber();
            floorDescription = ((BlockLiftTrackFloor.BlockEntity)((Object)floorEntity.data)).getFloorDescription();
        } else {
            floorNumber = liftFloor.getNumber();
            floorDescription = liftFloor.getDescription();
        }
        return new ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>>(lift.getDirection(), new ObjectObjectImmutablePair<String, String>(floorNumber, floorDescription));
    }

    private static ObjectObjectImmutablePair<Vector, Vector> getVirtualBogiePositions(ClientWorld clientWorld, Lift lift) {
        Vector position = lift.getPosition((floorPosition1, floorPosition2) -> ItemLiftRefresher.findPath(new World((Level)clientWorld.data), floorPosition1, floorPosition2));
        Angle angle = lift.getAngle();
        double x = position.x + lift.getOffsetX();
        double y = position.y + lift.getOffsetY();
        double z = position.z + lift.getOffsetZ();
        return new ObjectObjectImmutablePair<Vector, Vector>(new Vector(x + angle.cos, y, z + angle.sin), new Vector(x - angle.cos, y, z - angle.sin));
    }
}

