/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.BlockbenchModel;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.ResourceProvider;

public interface StoredModelResourceBase {
    default public ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> load(String modelResource, String textureResource, boolean flipTextureV, double modelYOffset, ResourceProvider resourceProvider) {
        ObjectObjectImmutablePair<Object, Object> models;
        CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.beginReload();
        boolean isBlockbench = modelResource.endsWith(".bbmodel");
        boolean isObj = modelResource.endsWith(".obj");
        Identifier textureId = CustomResourceTools.formatIdentifierWithDefault(textureResource, "png");
        if (isBlockbench) {
            Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroups = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
            DynamicVehicleModel tempDynamicVehicleModel = new DynamicVehicleModel(new BlockbenchModel(new JsonReader(Utilities.parseJson(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(modelResource, "bbmodel"))))), textureId, new ModelProperties(modelYOffset), new PositionDefinitions(), "");
            tempDynamicVehicleModel.writeFloorsAndDoorways(new ObjectArrayList<Box>(), new ObjectArrayList<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroups, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>());
            models = new ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>(OptimizedModelWrapper.fromMaterialGroups(materialGroups.get((Object)PartCondition.NORMAL)), tempDynamicVehicleModel);
        } else if (isObj) {
            Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModels = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
            Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel> rawModels = new Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel>(OptimizedModel.ObjModel.loadModel(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(modelResource, "obj")), mtlString -> resourceProvider.get(CustomResourceTools.getResourceFromSamePath(modelResource, mtlString, "mtl")), textureString -> StringUtils.isEmpty((CharSequence)textureString) ? textureId : CustomResourceTools.getResourceFromSamePath(modelResource, textureString, "png"), null, true, flipTextureV));
            this.transform((ObjectCollection<OptimizedModel.ObjModel>)rawModels.values());
            DynamicVehicleModel dynamicVehicleModel = new DynamicVehicleModel(rawModels, textureId, new ModelProperties(modelYOffset), new PositionDefinitions(), "");
            dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArrayList<Box>(), new ObjectArrayList<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModels);
            models = new ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel>(OptimizedModelWrapper.fromObjModels(objModels.get((Object)PartCondition.NORMAL)), dynamicVehicleModel);
        } else {
            models = new ObjectObjectImmutablePair<Object, Object>(null, null);
        }
        CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.finishReload();
        return models;
    }

    default public void render(StoredMatrixTransformations storedMatrixTransformations, int light) {
        OptimizedModelWrapper optimizedModel = this.getOptimizedModel();
        DynamicVehicleModel dynamicVehicleModel = this.getDynamicVehicleModel();
        if (OptimizedRenderer.hasOptimizedRendering()) {
            if (optimizedModel != null) {
                MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue(optimizedModel, (GraphicsHolder)graphicsHolder, light);
                    graphicsHolder.pop();
                });
            }
        } else if (dynamicVehicleModel != null) {
            dynamicVehicleModel.render(storedMatrixTransformations, null, 0, new int[]{0}, light, new ObjectArrayList<Box>(), false);
        }
    }

    @Nullable
    public OptimizedModelWrapper getOptimizedModel();

    @Nullable
    public DynamicVehicleModel getDynamicVehicleModel();

    public void preload();

    default public void transform(ObjectCollection<OptimizedModel.ObjModel> values2) {
    }
}

