/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.generated.resource.VehicleModelSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.resource.BlockbenchModel;
import org.mtr.mod.resource.CachedResource;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.ModelPropertiesPartWrapper;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.VehicleModelWrapper;

public final class VehicleModel
extends VehicleModelSchema {
    boolean shouldPreload = false;
    final CachedResource<DynamicVehicleModel> cachedModel;
    private final JsonReader modelPropertiesJsonReader;
    private final JsonReader positionDefinitionsJsonReader;
    public static final int MODEL_LIFESPAN = 60000;

    public VehicleModel(ReaderBase readerBase, ResourceProvider resourceProvider) {
        super(readerBase, resourceProvider);
        this.updateData(readerBase);
        this.modelPropertiesJsonReader = new JsonReader(Utilities.parseJson(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(this.modelPropertiesResource, "json"))));
        this.positionDefinitionsJsonReader = new JsonReader(Utilities.parseJson(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(this.positionDefinitionsResource, "json"))));
        this.cachedModel = new CachedResource<DynamicVehicleModel>(() -> this.createModel(new ModelProperties(this.modelPropertiesJsonReader), new PositionDefinitions(this.positionDefinitionsJsonReader), this.modelPropertiesResource), this.shouldPreload ? Integer.MAX_VALUE : 60000L);
    }

    public VehicleModel(ReaderBase readerBase, JsonReader modelPropertiesJsonReader, JsonReader positionDefinitionsJsonReader, String id, ResourceProvider resourceProvider) {
        super(readerBase, resourceProvider);
        this.updateData(readerBase);
        this.modelPropertiesJsonReader = modelPropertiesJsonReader;
        this.positionDefinitionsJsonReader = positionDefinitionsJsonReader;
        this.cachedModel = new CachedResource<DynamicVehicleModel>(() -> this.createModel(new ModelProperties(modelPropertiesJsonReader), new PositionDefinitions(positionDefinitionsJsonReader), id), this.shouldPreload ? Integer.MAX_VALUE : 60000L);
    }

    VehicleModel(String modelResource, String textureResource, String modelPropertiesResource, String positionDefinitionsResource, boolean flipTextureV, ResourceProvider resourceProvider) {
        super(modelResource, textureResource, modelPropertiesResource, positionDefinitionsResource, flipTextureV, resourceProvider);
        this.modelPropertiesJsonReader = new JsonReader(Utilities.parseJson(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(modelPropertiesResource, "json"))));
        this.positionDefinitionsJsonReader = new JsonReader(Utilities.parseJson(resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(positionDefinitionsResource, "json"))));
        this.cachedModel = new CachedResource<DynamicVehicleModel>(() -> this.createModel(new ModelProperties(this.modelPropertiesJsonReader), new PositionDefinitions(this.positionDefinitionsJsonReader), modelPropertiesResource), this.shouldPreload ? Integer.MAX_VALUE : 60000L);
    }

    public MinecraftModelResource getAsMinecraftResource() {
        return new MinecraftModelResource(this.modelResource, this.modelPropertiesResource, this.positionDefinitionsResource);
    }

    public void addToTextureResource(ObjectArraySet<String> textureResources) {
        ModelProperties modelProperties = new ModelProperties(this.modelPropertiesJsonReader);
        if (modelProperties.gangwayInnerSideTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayInnerSideTexture.data).toString());
        }
        if (modelProperties.gangwayInnerTopTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayInnerTopTexture.data).toString());
        }
        if (modelProperties.gangwayInnerBottomTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayInnerBottomTexture.data).toString());
        }
        if (modelProperties.gangwayOuterSideTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayOuterSideTexture.data).toString());
        }
        if (modelProperties.gangwayOuterTopTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayOuterTopTexture.data).toString());
        }
        if (modelProperties.gangwayOuterBottomTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.gangwayOuterBottomTexture.data).toString());
        }
        if (modelProperties.barrierInnerSideTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierInnerSideTexture.data).toString());
        }
        if (modelProperties.barrierInnerTopTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierInnerTopTexture.data).toString());
        }
        if (modelProperties.barrierInnerBottomTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierInnerBottomTexture.data).toString());
        }
        if (modelProperties.barrierOuterSideTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierOuterSideTexture.data).toString());
        }
        if (modelProperties.barrierOuterTopTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierOuterTopTexture.data).toString());
        }
        if (modelProperties.barrierOuterBottomTexture != null) {
            textureResources.add(((ResourceLocation)modelProperties.barrierOuterBottomTexture.data).toString());
        }
        textureResources.add(this.textureResource);
    }

    VehicleModelWrapper toVehicleModelWrapper() {
        ModelProperties modelProperties = new ModelProperties(this.modelPropertiesJsonReader);
        PositionDefinitions positionDefinitions = new PositionDefinitions(this.positionDefinitionsJsonReader);
        ObjectArrayList<ModelPropertiesPartWrapper> parts = new ObjectArrayList<ModelPropertiesPartWrapper>();
        modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.addToModelPropertiesPartWrapperMap(positionDefinitions, parts));
        return modelProperties.toVehicleModelWrapper(this.modelResource, this.textureResource, this.modelPropertiesResource, this.positionDefinitionsResource, this.flipTextureV, parts);
    }

    private DynamicVehicleModel createModel(ModelProperties modelProperties, PositionDefinitions positionDefinitions, String id) {
        Identifier textureId = CustomResourceTools.formatIdentifierWithDefault(this.textureResource, "png");
        if (this.modelResource.endsWith(".bbmodel")) {
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.beginReload();
            DynamicVehicleModel dynamicVehicleModel = new DynamicVehicleModel(new BlockbenchModel(new JsonReader(Utilities.parseJson(this.resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(this.modelResource, "bbmodel"))))), textureId, modelProperties, positionDefinitions, id);
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.finishReload();
            return dynamicVehicleModel;
        }
        if (this.modelResource.endsWith(".obj")) {
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.beginReload();
            DynamicVehicleModel dynamicVehicleModel = new DynamicVehicleModel(new Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel>(OptimizedModel.ObjModel.loadModel(this.resourceProvider.get(CustomResourceTools.formatIdentifierWithDefault(this.modelResource, "obj")), mtlString -> this.resourceProvider.get(CustomResourceTools.getResourceFromSamePath(this.modelResource, mtlString, "mtl")), textureString -> StringUtils.isEmpty((CharSequence)textureString) ? textureId : CustomResourceTools.getResourceFromSamePath(this.modelResource, textureString, "png"), null, true, this.flipTextureV)), textureId, modelProperties, positionDefinitions, id);
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.finishReload();
            return dynamicVehicleModel;
        }
        Init.LOGGER.error("[{}] Invalid model!", (Object)((ResourceLocation)textureId.data).toString());
        CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.beginReload();
        DynamicVehicleModel dynamicVehicleModel = new DynamicVehicleModel(new BlockbenchModel(new JsonReader(new JsonObject())), textureId, modelProperties, positionDefinitions, id);
        CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.finishReload();
        return dynamicVehicleModel;
    }
}

