/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Lift;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.EnumHelper;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.MTRScreenBase;

public class LiftCustomizationScreen
extends MTRScreenBase
implements IGui {
    private LiftStyle liftStyle;
    private Direction liftDirection;
    private final Lift lift;
    private final ButtonWidgetExtension buttonHeightMinus;
    private final ButtonWidgetExtension buttonHeightAdd;
    private final ButtonWidgetExtension buttonWidthMinus;
    private final ButtonWidgetExtension buttonWidthAdd;
    private final ButtonWidgetExtension buttonDepthMinus;
    private final ButtonWidgetExtension buttonDepthAdd;
    private final ButtonWidgetExtension buttonOffsetXMinus;
    private final ButtonWidgetExtension buttonOffsetXAdd;
    private final ButtonWidgetExtension buttonOffsetYMinus;
    private final ButtonWidgetExtension buttonOffsetYAdd;
    private final ButtonWidgetExtension buttonOffsetZMinus;
    private final ButtonWidgetExtension buttonOffsetZAdd;
    private final CheckboxWidgetExtension buttonIsDoubleSided;
    private final ButtonWidgetExtension buttonLiftStyle;
    private final ButtonWidgetExtension buttonRotateAnticlockwise;
    private final ButtonWidgetExtension buttonRotateClockwise;
    private final int width1;
    private final int width2;
    private static final int MIN_DIMENSION = 2;
    private static final int MAX_DIMENSION = 16;
    private static final int MAX_OFFSET = 16;

    public LiftCustomizationScreen(Lift lift) {
        this.lift = lift;
        this.liftStyle = EnumHelper.valueOf(LiftStyle.TRANSPARENT, lift.getStyle());
        this.liftDirection = Direction.fromRotation(lift.getAngle().angleDegrees);
        this.buttonHeightMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(Math.max(2.0, lift.getHeight() - 0.5), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonHeightAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(Math.min(16.0, lift.getHeight() + 0.5), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonWidthMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(lift.getHeight(), Math.max(2.0, lift.getWidth() - 1.0), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonWidthAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(lift.getHeight(), Math.min(16.0, lift.getWidth() + 1.0), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonDepthMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), Math.max(2.0, lift.getDepth() - 1.0), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonDepthAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), Math.min(16.0, lift.getDepth() + 1.0), lift.getOffsetX(), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonOffsetXMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), Math.max(-16.0, lift.getOffsetX() - 0.5), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonOffsetXAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), Math.min(16.0, lift.getOffsetX() + 0.5), lift.getOffsetY(), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonOffsetYMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), Math.max(-16.0, lift.getOffsetY() - 1.0), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonOffsetYAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), Math.min(16.0, lift.getOffsetY() + 1.0), lift.getOffsetZ());
            this.updateControls(true);
        });
        this.buttonOffsetZMinus = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), Math.max(-16.0, lift.getOffsetZ() - 0.5));
            this.updateControls(true);
        });
        this.buttonOffsetZAdd = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            lift.setDimensions(lift.getHeight(), lift.getWidth(), lift.getDepth(), lift.getOffsetX(), lift.getOffsetY(), Math.min(16.0, lift.getOffsetZ() + 0.5));
            this.updateControls(true);
        });
        MutableText doubleSidedText = TranslationProvider.GUI_MTR_LIFT_IS_DOUBLE_SIDED.getMutableText(new Object[0]);
        MutableText rotateAnticlockwiseText = TranslationProvider.GUI_MTR_ROTATE_ANTICLOCKWISE.getMutableText(new Object[0]);
        MutableText rotateClockwiseText = TranslationProvider.GUI_MTR_ROTATE_CLOCKWISE.getMutableText(new Object[0]);
        this.buttonIsDoubleSided = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {
            lift.setIsDoubleSided((boolean)checked);
            this.updateControls(true);
        });
        this.buttonIsDoubleSided.setMessage2(new Text((Component)doubleSidedText.data));
        this.buttonLiftStyle = new ButtonWidgetExtension(0, 0, 0, 20, button -> {
            this.liftStyle = LiftStyle.values()[(this.liftStyle.ordinal() + 1) % LiftStyle.values().length];
            lift.setStyle(this.liftStyle.toString());
            this.updateControls(true);
        });
        this.buttonRotateAnticlockwise = new ButtonWidgetExtension(0, 0, 0, 20, rotateAnticlockwiseText, button -> {
            this.liftDirection = this.liftDirection.rotateYCounterclockwise();
            lift.setAngle(Angle.fromAngle(this.liftDirection.asRotation()));
            this.updateControls(true);
        });
        this.buttonRotateClockwise = new ButtonWidgetExtension(0, 0, 0, 20, rotateClockwiseText, button -> {
            this.liftDirection = this.liftDirection.rotateYClockwise();
            lift.setAngle(Angle.fromAngle(this.liftDirection.asRotation()));
            this.updateControls(true);
        });
        this.width1 = Math.max(Math.max(60, GraphicsHolder.getTextWidth(doubleSidedText)), Math.max(GraphicsHolder.getTextWidth(rotateAnticlockwiseText), GraphicsHolder.getTextWidth(rotateClockwiseText))) + 12;
        this.width2 = this.width1 + 20;
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonHeightMinus, 0, 0, 20);
        IDrawing.setPositionAndWidth(this.buttonHeightAdd, this.width1, 0, 20);
        IDrawing.setPositionAndWidth(this.buttonWidthMinus, 0, 20, 20);
        IDrawing.setPositionAndWidth(this.buttonWidthAdd, this.width1, 20, 20);
        IDrawing.setPositionAndWidth(this.buttonDepthMinus, 0, 40, 20);
        IDrawing.setPositionAndWidth(this.buttonDepthAdd, this.width1, 40, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetXMinus, 0, 60, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetXAdd, this.width1, 60, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetYMinus, 0, 80, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetYAdd, this.width1, 80, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetZMinus, 0, 100, 20);
        IDrawing.setPositionAndWidth(this.buttonOffsetZAdd, this.width1, 100, 20);
        IDrawing.setPositionAndWidth(this.buttonIsDoubleSided, 0, 140, this.width2);
        IDrawing.setPositionAndWidth(this.buttonLiftStyle, 0, 160, this.width2);
        IDrawing.setPositionAndWidth(this.buttonRotateAnticlockwise, 0, 180, this.width2);
        IDrawing.setPositionAndWidth(this.buttonRotateClockwise, 0, 200, this.width2);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonHeightMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonHeightAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonWidthMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonWidthAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDepthMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDepthAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetXMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetXAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetYMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetYAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetZMinus));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOffsetZAdd));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsDoubleSided));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonRotateAnticlockwise));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonRotateClockwise));
        this.updateControls(false);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(0.0, 0.0, this.width2, this.f_96544_, -15592942);
        guiDrawing.finishDrawingRectangle();
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.drawCenteredText(TranslationProvider.TOOLTIP_MTR_RAIL_ACTION_HEIGHT.getMutableText(this.lift.getHeight()), this.width2 / 2, 6, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.TOOLTIP_MTR_RAIL_ACTION_WIDTH.getMutableText(this.lift.getWidth()), this.width2 / 2, 26, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.TOOLTIP_MTR_RAIL_ACTION_DEPTH.getMutableText(this.lift.getDepth()), this.width2 / 2, 46, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_OFFSET_X.getMutableText(this.lift.getOffsetX()), this.width2 / 2, 66, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_OFFSET_Y.getMutableText(this.lift.getOffsetY()), this.width2 / 2, 86, -1);
        graphicsHolder.drawCenteredText(TranslationProvider.GUI_MTR_OFFSET_Z.getMutableText(this.lift.getOffsetZ()), this.width2 / 2, 106, -1);
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void updateControls(boolean sendUpdate) {
        this.buttonHeightMinus.f_93623_ = this.lift.getHeight() > 2.0;
        this.buttonHeightAdd.f_93623_ = this.lift.getHeight() < 16.0;
        this.buttonWidthMinus.f_93623_ = this.lift.getWidth() > 2.0;
        this.buttonWidthAdd.f_93623_ = this.lift.getWidth() < 16.0;
        this.buttonDepthMinus.f_93623_ = this.lift.getDepth() > 2.0;
        this.buttonDepthAdd.f_93623_ = this.lift.getDepth() < 16.0;
        this.buttonOffsetXMinus.f_93623_ = this.lift.getOffsetX() > -16.0;
        this.buttonOffsetXAdd.f_93623_ = this.lift.getOffsetX() < 16.0;
        this.buttonOffsetYMinus.f_93623_ = this.lift.getOffsetY() > -16.0;
        this.buttonOffsetYAdd.f_93623_ = this.lift.getOffsetY() < 16.0;
        this.buttonOffsetZMinus.f_93623_ = this.lift.getOffsetZ() > -16.0;
        this.buttonOffsetZAdd.f_93623_ = this.lift.getOffsetZ() < 16.0;
        this.buttonIsDoubleSided.setChecked(this.lift.getIsDoubleSided());
        this.buttonLiftStyle.setMessage2(TranslationProvider.GUI_MTR_LIFT_STYLE.getText(this.lift.getStyle().toUpperCase(Locale.ENGLISH)));
        if (sendUpdate) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addLift(this.lift)));
        }
    }

    private static enum LiftStyle {
        TRANSPARENT,
        OPAQUE;

    }
}

