/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockSignalBase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.item.ItemSignalModifier;
import org.mtr.mod.packet.PacketUpdateSignalConfig;
import org.mtr.mod.render.RenderSignalBase;
import org.mtr.mod.screen.MTRScreenBase;

public class SignalColorScreen
extends MTRScreenBase
implements IGui {
    private final CheckboxWidgetExtension checkBoxSelectAll;
    private final CheckboxWidgetExtension[] checkBoxes = new CheckboxWidgetExtension[ItemSignalModifier.COLORS.length];
    private final BlockPos blockPos;
    private final IntAVLTreeSet signalColors;
    private final IntAVLTreeSet detectedColors = new IntAVLTreeSet();
    private final boolean isBackSide;

    public SignalColorScreen(BlockPos blockPos, BlockSignalBase.BlockEntityBase blockEntity) {
        this.blockPos = blockPos;
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        if (clientWorld == null) {
            this.signalColors = new IntAVLTreeSet();
            this.isBackSide = false;
        } else {
            float angle = BlockSignalBase.getAngle(clientWorld.getBlockState(blockPos));
            ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
            this.isBackSide = clientPlayerEntity == null ? false : blockEntity.isDoubleSided && Math.abs(Utilities.circularDifference(Math.round(EntityHelper.getYaw(new Entity((net.minecraft.world.entity.Entity)clientPlayerEntity.data))), Math.round(angle), 360L)) > 90L;
            this.signalColors = blockEntity.getSignalColors(this.isBackSide);
            RenderSignalBase.AspectState aspectState = RenderSignalBase.getAspectState(blockPos, angle + (float)(this.isBackSide ? 180 : 0) + 90.0f);
            this.detectedColors.addAll(aspectState == null ? new IntAVLTreeSet() : aspectState.detectedColors);
        }
        this.checkBoxSelectAll = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {
            if (checked.booleanValue()) {
                this.signalColors.clear();
            } else if (this.signalColors.isEmpty()) {
                this.signalColors.add(ItemSignalModifier.COLORS[0]);
            }
            this.setButtons();
        });
        this.checkBoxSelectAll.setMessage2(TranslationProvider.GUI_MTR_SELECT_ALL.getText(new Object[0]));
        for (int i = 0; i < ItemSignalModifier.COLORS.length; ++i) {
            int color = ItemSignalModifier.COLORS[i];
            this.checkBoxes[i] = new CheckboxWidgetExtension(0, 0, 0, 20, false, checked -> {
                if (checked.booleanValue()) {
                    this.signalColors.add(color);
                } else {
                    this.signalColors.remove(color);
                }
                this.setButtons();
            });
        }
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.checkBoxSelectAll, 20, 20, this.f_96543_ - 40);
        SignalColorScreen.iterateGrid((x, y, index) -> {
            IDrawing.setPositionAndWidth(this.checkBoxes[index], 20 + x * 20 * 2, 60 + y * 20, 40);
            this.addChild(new ClickableWidget((AbstractWidget)this.checkBoxes[index]));
        });
        this.addChild(new ClickableWidget((AbstractWidget)this.checkBoxSelectAll));
        this.setButtons();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        SignalColorScreen.iterateGrid((x, y, index) -> {
            int color = ItemSignalModifier.COLORS[index];
            guiDrawing.drawRectangle(40 + x * 20 * 2, 60 + y * 20, (float)(40 + x * 20 * 2) + 20.0f / (this.detectedColors.contains(color) ? 1.0f : 8.0f), 80 + y * 20, color | 0xFF000000);
        });
        guiDrawing.finishDrawingRectangle();
    }

    @Override
    public void onClose2() {
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateSignalConfig(this.blockPos, this.signalColors, this.isBackSide));
        super.onClose2();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void setButtons() {
        for (int i = 0; i < ItemSignalModifier.COLORS.length; ++i) {
            SignalColorScreen.setChecked(this.checkBoxes[i], this.signalColors.contains(ItemSignalModifier.COLORS[i]));
        }
        SignalColorScreen.setChecked(this.checkBoxSelectAll, this.signalColors.isEmpty());
    }

    private static void setChecked(CheckboxWidgetExtension checkboxWidgetExtension, boolean checked) {
        if (checkboxWidgetExtension.isChecked2() != checked) {
            checkboxWidgetExtension.setChecked(checked);
        }
    }

    private static void iterateGrid(GridConsumer gridConsumer) {
        for (int i = 0; i < ItemSignalModifier.COLORS.length; ++i) {
            gridConsumer.accept(i % 4, i / 4, i);
        }
    }

    @FunctionalInterface
    private static interface GridConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

