/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.operation;

import javax.annotation.Nonnull;
import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class DataRequestSchema
implements SerializedDataBase {
    protected final String clientId;
    protected final Position clientPosition;
    protected final long requestRadius;
    protected final LongArrayList existingStationIds = new LongArrayList();
    protected final LongArrayList existingPlatformIds = new LongArrayList();
    protected final LongArrayList existingSidingIds = new LongArrayList();
    protected final LongArrayList existingSimplifiedRouteIds = new LongArrayList();
    protected final LongArrayList existingDepotIds = new LongArrayList();
    protected final ObjectArrayList<String> existingRailIds = new ObjectArrayList();

    protected DataRequestSchema(String clientId, Position clientPosition, long requestRadius) {
        this.clientId = clientId;
        this.clientPosition = clientPosition;
        this.requestRadius = requestRadius;
    }

    protected DataRequestSchema(ReaderBase readerBase) {
        this.clientId = readerBase.getString("clientId", "");
        this.clientPosition = new Position(readerBase.getChild("clientPosition"));
        this.requestRadius = readerBase.getLong("requestRadius", 0L);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateLongArray("existingStationIds", this.existingStationIds::clear, this.existingStationIds::add);
        readerBase.iterateLongArray("existingPlatformIds", this.existingPlatformIds::clear, this.existingPlatformIds::add);
        readerBase.iterateLongArray("existingSidingIds", this.existingSidingIds::clear, this.existingSidingIds::add);
        readerBase.iterateLongArray("existingSimplifiedRouteIds", this.existingSimplifiedRouteIds::clear, this.existingSimplifiedRouteIds::add);
        readerBase.iterateLongArray("existingDepotIds", this.existingDepotIds::clear, this.existingDepotIds::add);
        readerBase.iterateStringArray("existingRailIds", this.existingRailIds::clear, this.existingRailIds::add);
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("clientId", this.clientId);
        if (this.clientPosition != null) {
            this.clientPosition.serializeData(writerBase.writeChild("clientPosition"));
        }
        writerBase.writeLong("requestRadius", this.requestRadius);
        this.serializeExistingStationIds(writerBase);
        this.serializeExistingPlatformIds(writerBase);
        this.serializeExistingSidingIds(writerBase);
        this.serializeExistingSimplifiedRouteIds(writerBase);
        this.serializeExistingDepotIds(writerBase);
        this.serializeExistingRailIds(writerBase);
    }

    @Nonnull
    public String toString() {
        return "clientId: " + this.clientId + "\nclientPosition: " + this.clientPosition + "\nrequestRadius: " + this.requestRadius + "\nexistingStationIds: " + this.existingStationIds + "\nexistingPlatformIds: " + this.existingPlatformIds + "\nexistingSidingIds: " + this.existingSidingIds + "\nexistingSimplifiedRouteIds: " + this.existingSimplifiedRouteIds + "\nexistingDepotIds: " + this.existingDepotIds + "\nexistingRailIds: " + this.existingRailIds + "\n";
    }

    protected void serializeExistingStationIds(WriterBase writerBase) {
        WriterBase.Array existingStationIdsWriterBaseArray = writerBase.writeArray("existingStationIds");
        this.existingStationIds.forEach(existingStationIdsWriterBaseArray::writeLong);
    }

    protected void serializeExistingPlatformIds(WriterBase writerBase) {
        WriterBase.Array existingPlatformIdsWriterBaseArray = writerBase.writeArray("existingPlatformIds");
        this.existingPlatformIds.forEach(existingPlatformIdsWriterBaseArray::writeLong);
    }

    protected void serializeExistingSidingIds(WriterBase writerBase) {
        WriterBase.Array existingSidingIdsWriterBaseArray = writerBase.writeArray("existingSidingIds");
        this.existingSidingIds.forEach(existingSidingIdsWriterBaseArray::writeLong);
    }

    protected void serializeExistingSimplifiedRouteIds(WriterBase writerBase) {
        WriterBase.Array existingSimplifiedRouteIdsWriterBaseArray = writerBase.writeArray("existingSimplifiedRouteIds");
        this.existingSimplifiedRouteIds.forEach(existingSimplifiedRouteIdsWriterBaseArray::writeLong);
    }

    protected void serializeExistingDepotIds(WriterBase writerBase) {
        WriterBase.Array existingDepotIdsWriterBaseArray = writerBase.writeArray("existingDepotIds");
        this.existingDepotIds.forEach(existingDepotIdsWriterBaseArray::writeLong);
    }

    protected void serializeExistingRailIds(WriterBase writerBase) {
        WriterBase.Array existingRailIdsWriterBaseArray = writerBase.writeArray("existingRailIds");
        this.existingRailIds.forEach(existingRailIdsWriterBaseArray::writeString);
    }
}

