/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.shader;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.shader.PatchingResourceProvider;
import org.mtr.mapping.render.tool.Utilities;
import org.mtr.mapping.tool.DummyClass;

public final class ShaderManager {
    private final Map<String, class_5944> shaders = new HashMap<String, class_5944>();
    private static final class_296 MINECRAFT_ELEMENT_MATRIX = new class_296(0, class_296.class_297.field_1623, class_296.class_298.field_20782, 16);
    private static final class_293 MINECRAFT_VERTEX_FORMAT_BLOCK = new class_293(ImmutableMap.builder().put((Object)"Position", (Object)class_290.field_1587).put((Object)"Color", (Object)class_290.field_1581).put((Object)"UV0", (Object)class_290.field_1591).put((Object)"UV1", (Object)class_290.field_1583).put((Object)"UV2", (Object)class_290.field_20886).put((Object)"Normal", (Object)class_290.field_1579).put((Object)"ModelMat", (Object)MINECRAFT_ELEMENT_MATRIX).put((Object)"Padding", (Object)class_290.field_1578).build());

    public boolean isReady() {
        return !this.shaders.isEmpty();
    }

    public void reloadShaders() {
        this.shaders.values().forEach(class_5944::close);
        this.shaders.clear();
        PatchingResourceProvider patchingResourceProvider = new PatchingResourceProvider(MinecraftClient.getInstance().getResourceManager());
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.CUTOUT));
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.TRANSLUCENT));
        this.loadShader(patchingResourceProvider, ShaderManager.getShaderName(OptimizedModel.ShaderType.CUTOUT_GLOWING));
    }

    private void loadShader(PatchingResourceProvider resourceManager, String shaderName) {
        try {
            this.shaders.put(shaderName, new class_5944((class_5912)resourceManager, shaderName, MINECRAFT_VERTEX_FORMAT_BLOCK));
        }
        catch (Exception e) {
            DummyClass.logException(e);
        }
    }

    public void setupShaderBatchState(MaterialProperties materialProperties) {
        class_5944 shaderProgram;
        if (Utilities.canUseCustomShader()) {
            shaderProgram = this.shaders.get(ShaderManager.getShaderName(materialProperties.shaderType));
            materialProperties.setupCompositeState();
        } else {
            materialProperties.getBlazeRenderType().startDrawing();
            shaderProgram = RenderSystem.getShader();
        }
        if (shaderProgram == null) {
            throw new IllegalArgumentException("Cannot get shader: " + materialProperties.shaderType);
        }
        for (int i = 0; i < 8; ++i) {
            shaderProgram.method_34583("Sampler" + i, (Object)RenderSystem.getShaderTexture((int)i));
        }
        if (shaderProgram.field_29470 != null) {
            shaderProgram.field_29470.method_1250((class_1159)Utilities.copy((Matrix4f)new Matrix4f((class_1159)RenderSystem.getModelViewMatrix())).data);
        }
        if (shaderProgram.field_29471 != null) {
            shaderProgram.field_29471.method_1250(RenderSystem.getProjectionMatrix());
        }
        if (shaderProgram.field_36323 != null) {
            shaderProgram.field_36323.method_39978(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shaderProgram.field_29474 != null) {
            shaderProgram.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderProgram.field_29477 != null) {
            shaderProgram.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shaderProgram.field_29478 != null) {
            shaderProgram.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shaderProgram.field_29479 != null) {
            shaderProgram.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shaderProgram.field_36373 != null) {
            shaderProgram.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shaderProgram.field_29472 != null) {
            shaderProgram.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderProgram.field_29481 != null) {
            shaderProgram.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderProgram.field_29473 != null) {
            Window window = MinecraftClient.getInstance().getWindow();
            shaderProgram.field_29473.method_35650(window.getWidth(), window.getHeight());
        }
        RenderSystem.setupShaderLights((class_5944)shaderProgram);
        shaderProgram.method_34586();
    }

    public void cleanupShaderBatchState() {
        class_5944 shaderProgram;
        if (!Utilities.canUseCustomShader() && (shaderProgram = RenderSystem.getShader()) != null && shaderProgram.field_29470 != null) {
            shaderProgram.field_29470.method_1250(RenderSystem.getModelViewMatrix());
            shaderProgram.method_34586();
        }
    }

    private static String getShaderName(OptimizedModel.ShaderType shaderType) {
        switch (shaderType) {
            default: {
                return "rendertype_entity_cutout";
            }
            case TRANSLUCENT: 
            case TRANSLUCENT_BRIGHT: {
                return "rendertype_entity_translucent_cull";
            }
            case CUTOUT_GLOWING: 
            case TRANSLUCENT_GLOWING: 
        }
        return "rendertype_beacon_beam";
    }
}

