/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL33;
import org.mtr.mapping.holder.Matrix4f;
import org.mtr.mapping.holder.OverlayTexture;
import org.mtr.mapping.holder.Vector3f;
import org.mtr.mapping.render.tool.GlStateTracker;
import org.mtr.mapping.render.tool.Utilities;
import org.mtr.mapping.render.vertex.VertexAttributeType;

public final class VertexAttributeState {
    public final Integer color;
    public final Integer lightmapUV;
    public final Vector3f position;
    public final Float textureU;
    public final Float textureV;
    public final Integer overlayUV;
    public final Vector3f normal;
    public final Matrix4f matrix4f;

    public VertexAttributeState(int color, int lightmapUV, Matrix4f matrix4f) {
        this.color = color;
        this.lightmapUV = Utilities.exchangeLightmapUVBits(lightmapUV);
        this.position = null;
        this.textureU = null;
        this.textureV = null;
        this.overlayUV = Utilities.exchangeLightmapUVBits(OverlayTexture.getDefaultUvMapped());
        this.normal = null;
        this.matrix4f = matrix4f;
    }

    public VertexAttributeState(@Nullable Integer color, @Nullable Integer lightmapUV) {
        this.color = color;
        this.lightmapUV = lightmapUV;
        this.position = null;
        this.textureU = null;
        this.textureV = null;
        this.overlayUV = null;
        this.normal = null;
        this.matrix4f = null;
    }

    public void apply() {
        block9: for (VertexAttributeType vertexAttributeType : VertexAttributeType.values()) {
            switch (vertexAttributeType) {
                case POSITION: {
                    if (this.position == null) continue block9;
                    GL33.glVertexAttrib3f((int)vertexAttributeType.location, (float)this.position.getX(), (float)this.position.getY(), (float)this.position.getZ());
                    continue block9;
                }
                case COLOR: {
                    if (this.color == null) continue block9;
                    GL33.glVertexAttrib4f((int)vertexAttributeType.location, (float)((float)(this.color >>> 24 & 0xFF) / 255.0f), (float)((float)(this.color >>> 16 & 0xFF) / 255.0f), (float)((float)(this.color >>> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f));
                    continue block9;
                }
                case UV_TEXTURE: {
                    if (this.textureU == null || this.textureV == null) continue block9;
                    GL33.glVertexAttrib2f((int)vertexAttributeType.location, (float)this.textureU.floatValue(), (float)this.textureV.floatValue());
                    continue block9;
                }
                case UV_OVERLAY: {
                    if (this.overlayUV == null) continue block9;
                    if (!GlStateTracker.isGl4ES()) {
                        GL33.glVertexAttribI2i((int)vertexAttributeType.location, (int)((short)(this.overlayUV >>> 16)), (int)((short)this.overlayUV.intValue()));
                        continue block9;
                    }
                    GL33.glVertexAttrib2f((int)vertexAttributeType.location, (float)((short)(this.overlayUV >>> 16)), (float)((short)this.overlayUV.intValue()));
                    continue block9;
                }
                case UV_LIGHTMAP: {
                    if (this.lightmapUV == null) continue block9;
                    if (!GlStateTracker.isGl4ES()) {
                        GL33.glVertexAttribI2i((int)vertexAttributeType.location, (int)((short)(this.lightmapUV >>> 16)), (int)((short)this.lightmapUV.intValue()));
                        continue block9;
                    }
                    GL33.glVertexAttrib2f((int)vertexAttributeType.location, (float)((short)(this.lightmapUV >>> 16)), (float)((short)this.lightmapUV.intValue()));
                    continue block9;
                }
                case NORMAL: {
                    if (this.normal == null) continue block9;
                    GL33.glVertexAttrib3f((int)vertexAttributeType.location, (float)this.normal.getX(), (float)this.normal.getY(), (float)this.normal.getZ());
                    continue block9;
                }
                case MATRIX_MODEL: {
                    if (this.matrix4f == null) continue block9;
                    if (Utilities.canUseCustomShader()) {
                        FloatBuffer floatBuffer = ByteBuffer.allocate(64).asFloatBuffer();
                        Utilities.store(this.matrix4f, floatBuffer);
                        GL33.glVertexAttrib4f((int)vertexAttributeType.location, (float)floatBuffer.get(0), (float)floatBuffer.get(1), (float)floatBuffer.get(2), (float)floatBuffer.get(3));
                        GL33.glVertexAttrib4f((int)(vertexAttributeType.location + 1), (float)floatBuffer.get(4), (float)floatBuffer.get(5), (float)floatBuffer.get(6), (float)floatBuffer.get(7));
                        GL33.glVertexAttrib4f((int)(vertexAttributeType.location + 2), (float)floatBuffer.get(8), (float)floatBuffer.get(9), (float)floatBuffer.get(10), (float)floatBuffer.get(11));
                        GL33.glVertexAttrib4f((int)(vertexAttributeType.location + 3), (float)floatBuffer.get(12), (float)floatBuffer.get(13), (float)floatBuffer.get(14), (float)floatBuffer.get(15));
                        continue block9;
                    }
                    class_5944 shaderProgram = RenderSystem.getShader();
                    if (shaderProgram == null || shaderProgram.field_29470 == null) continue block9;
                    shaderProgram.field_29470.method_1250((class_1159)this.matrix4f.data);
                    shaderProgram.method_34586();
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VertexAttributeState)) {
            return false;
        }
        VertexAttributeState vertexAttributeState = (VertexAttributeState)object;
        return Objects.equals(this.color, vertexAttributeState.color) && Objects.equals(this.lightmapUV, vertexAttributeState.lightmapUV) && Objects.equals(this.position, vertexAttributeState.position) && Objects.equals(this.textureU, vertexAttributeState.textureU) && Objects.equals(this.textureV, vertexAttributeState.textureV) && Objects.equals(this.overlayUV, vertexAttributeState.overlayUV) && Objects.equals(this.normal, vertexAttributeState.normal) && Objects.equals(this.matrix4f, vertexAttributeState.matrix4f);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.color, this.textureU, this.textureV, this.lightmapUV, this.normal, this.overlayUV, this.matrix4f);
    }
}

