/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.class_339;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.screen.MTRScreenBase;
import org.mtr.mod.screen.WidgetColorSelector;

public abstract class EditNameColorScreenBase<T extends NameColorDataBase>
extends MTRScreenBase
implements Utilities,
IGui {
    private int nameStart;
    private int colorStart;
    private int colorEnd;
    protected final T data;
    private final MutableText nameText;
    private final MutableText colorText;
    private final TextFieldWidgetExtension textFieldName;
    private final WidgetColorSelector colorSelector;

    public EditNameColorScreenBase(T data, TranslationProvider.TranslationHolder nameKey, TranslationProvider.TranslationHolder colorKey, ScreenExtension previousScreenExtension) {
        super(previousScreenExtension);
        this.data = data;
        this.nameText = nameKey.getMutableText(new Object[0]);
        this.colorText = colorKey.getMutableText(new Object[0]);
        this.textFieldName = new TextFieldWidgetExtension(0, 0, 0, 20, 1024, TextCase.DEFAULT, null, null);
        this.colorSelector = new WidgetColorSelector(this, true, () -> {});
    }

    @Override
    public void tick2() {
        this.textFieldName.tick2();
    }

    @Override
    public void onClose2() {
        super.onClose2();
        this.saveData();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    protected void setPositionsAndInit(int nameStart, int colorStart, int colorEnd) {
        this.nameStart = nameStart;
        this.colorStart = colorStart;
        this.colorEnd = colorEnd;
        super.init2();
        int yStart = 22;
        IDrawing.setPositionAndWidth(this.textFieldName, nameStart + 2, 22, colorStart - nameStart - 4);
        IDrawing.setPositionAndWidth(this.colorSelector, colorStart + 2, 22, colorEnd - colorStart - 4);
        this.textFieldName.setText2(((NameColorDataBase)this.data).getName());
        this.colorSelector.setColor(((NameColorDataBase)this.data).getColor());
        this.addChild(new ClickableWidget((class_339)this.textFieldName));
        this.addChild(new ClickableWidget((class_339)this.colorSelector));
    }

    protected void renderTextFields(GraphicsHolder graphicsHolder) {
        graphicsHolder.drawCenteredText(this.nameText, (this.nameStart + this.colorStart) / 2, 6, -1);
        graphicsHolder.drawCenteredText(this.colorText, (this.colorStart + this.colorEnd) / 2, 6, -1);
    }

    protected void saveData() {
        ((NameColorDataBase)this.data).setName(this.textFieldName.getText2());
        ((NameColorDataBase)this.data).setColor(this.colorSelector.getColor());
    }
}

