/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.blaze3d.platform.NativeImage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum NativeImageFormat {
    RGBA(NativeImage.Format.RGBA),
    RGB(NativeImage.Format.RGB),
    LUMINANCE_ALPHA(NativeImage.Format.LUMINANCE_ALPHA),
    LUMINANCE(NativeImage.Format.LUMINANCE);

    public final NativeImage.Format data;

    private NativeImageFormat(NativeImage.Format data) {
        this.data = data;
    }

    public static NativeImageFormat convert(@Nullable NativeImage.Format data) {
        return data == null ? null : NativeImageFormat.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable NativeImageFormat data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getBgrMapped() {
        return NativeImageFormat.convert(NativeImage.Format.RGB);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getLuminanceMapped() {
        return NativeImageFormat.convert(NativeImage.Format.LUMINANCE);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getLuminanceAlphaMapped() {
        return NativeImageFormat.convert(NativeImage.Format.LUMINANCE_ALPHA);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getAbgrMapped() {
        return NativeImageFormat.convert(NativeImage.Format.RGBA);
    }
}

