/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GuiDrawing
extends DummyClass {
    private VertexConsumer vertexConsumer;
    private GuiGraphics drawContext;
    private BufferBuilder bufferBuilder;
    private Matrix4f matrix;
    private final GraphicsHolder graphicsHolder;

    @MappedMethod
    public GuiDrawing(GraphicsHolder graphicsHolder) {
        this.graphicsHolder = graphicsHolder;
    }

    @MappedMethod
    public void beginDrawingRectangle() {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.m_85850_().m_252922_();
        this.vertexConsumer = this.graphicsHolder.vertexConsumerProvider == null ? null : this.graphicsHolder.vertexConsumerProvider.m_6299_(RenderType.m_285907_());
        this.drawContext = this.graphicsHolder.drawContext;
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, int color) {
        if (this.matrix != null && this.vertexConsumer != null && this.drawContext != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.vertexConsumer.m_252986_(this.matrix, (float)x1, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x1, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x2, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x2, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
            });
        }
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int color) {
        if (this.matrix != null && this.vertexConsumer != null && this.drawContext != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.vertexConsumer.m_252986_(this.matrix, (float)x1, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x2, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x3, (float)y3, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.vertexConsumer.m_252986_(this.matrix, (float)x4, (float)y4, 0.0f).m_6122_(r, g, b, a).m_5752_();
            });
        }
    }

    @MappedMethod
    public void finishDrawingRectangle() {
        if (this.vertexConsumer != null && this.drawContext != null) {
            this.drawContext.m_280262_();
        }
    }

    @MappedMethod
    public void beginDrawingTexture(Identifier identifier) {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.m_85850_().m_252922_();
        this.bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)identifier.data));
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
    }

    @MappedMethod
    public void drawTexture(double x1, double y1, double x2, double y2, float u1, float v1, float u2, float v2) {
        if (this.matrix != null && this.bufferBuilder != null) {
            this.bufferBuilder.m_252986_(this.matrix, (float)x1, (float)y1, 0.0f).m_7421_(u1, v1).m_5752_();
            this.bufferBuilder.m_252986_(this.matrix, (float)x1, (float)y2, 0.0f).m_7421_(u1, v2).m_5752_();
            this.bufferBuilder.m_252986_(this.matrix, (float)x2, (float)y2, 0.0f).m_7421_(u2, v2).m_5752_();
            this.bufferBuilder.m_252986_(this.matrix, (float)x2, (float)y1, 0.0f).m_7421_(u2, v1).m_5752_();
        }
    }

    @MappedMethod
    public void finishDrawingTexture() {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)this.bufferBuilder.m_231175_());
    }
}

