/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.util.Locale;
import java.util.function.BiConsumer;
import org.mtr.core.data.Data;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Route;
import org.mtr.core.data.SimplifiedRoute;
import org.mtr.core.data.SimplifiedRoutePlatform;
import org.mtr.core.data.Station;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageFormat;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;

public class RouteMapGenerator
implements IGui {
    private static int scale;
    private static int lineSize;
    private static int lineSpacing;
    private static int fontSizeBig;
    private static int fontSizeSmall;
    public static final int PIXEL_SCALE = 4;
    private static final int MIN_VERTICAL_SIZE = 5;
    private static final String LOGO_RESOURCE = "textures/block/sign/logo.png";
    private static final String EXIT_RESOURCE = "textures/block/sign/exit_letter_blank.png";
    private static final String ARROW_RESOURCE = "textures/block/sign/arrow.png";
    private static final String CIRCLE_RESOURCE = "textures/block/sign/circle.png";
    private static final String TEMP_CIRCULAR_MARKER_CLOCKWISE;
    private static final String TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
    private static final int PIXEL_RESOLUTION = 24;

    public static void setConstants() {
        scale = (int)Math.pow(2.0, Config.getClient().getDynamicTextureResolution() + 5);
        lineSize = scale / 8;
        lineSpacing = lineSize * 3 / 2;
        fontSizeBig = lineSize * 2;
        fontSizeSmall = fontSizeBig / 2;
    }

    public static NativeImage generatePixelatedText(String text, int textColor, int maxWidth, double cjkSizeRatio, boolean fullPixel) {
        try {
            int scale = fullPixel ? 1 : 4;
            int newMaxWidth = maxWidth / scale;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(text, dimensions, newMaxWidth, Integer.MAX_VALUE, (int)Math.round(24.0 * (cjkSizeRatio > 0.0 ? cjkSizeRatio + 1.0 : 1.0)), (int)Math.round(24.0 * (cjkSizeRatio < 0.0 ? 1.0 - cjkSizeRatio : 1.0)), 0, IGui.HorizontalAlignment.CENTER);
            int width = Math.min(newMaxWidth, dimensions[0]) * scale;
            int height = dimensions[1] * scale;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, 0);
            RouteMapGenerator.drawStringPixelated(nativeImage, pixels, dimensions, textColor, fullPixel);
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateColorStrip(long platformId) {
        try {
            IntArrayList colors = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {});
            if (colors.isEmpty()) {
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), 1, 1, false);
                nativeImage.setPixelColor(0, 0, 0);
                return nativeImage;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), 1, colors.size(), false);
            for (int i = 0; i < colors.size(); ++i) {
                RouteMapGenerator.drawPixelSafe(nativeImage, 0, i, 0xFF000000 | colors.getInt(i));
            }
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationName(String stationName, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int height = scale * 2;
            int width = Math.round((float)height * aspectRatio);
            int padding = scale / 16;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(stationName, dimensions, width - padding * 2, height - padding * 2, fontSizeBig * 2, fontSizeSmall * 2, padding, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateTallStationName(int textColor, String stationName, int stationColor, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int width = Math.round((float)scale * 1.6f);
            int height = Math.round((float)width / aspectRatio);
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(IGui.formatVerticalChinese(stationName), dimensions, width, height, fontSizeBig * 2, fontSizeSmall * 2, 0, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0xFF000000 | stationColor, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(0xFF000000 | stationColor));
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNameEntrance(int textColor, String stationName, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int size = scale * 2;
            int width = Math.round((float)size * aspectRatio);
            int padding = scale / 16;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(stationName, dimensions, width - size - padding, size - padding * 2, fontSizeBig * 3, fontSizeSmall * 3, padding, IGui.HorizontalAlignment.LEFT);
            int xOffset = (width - dimensions[0] - size) / 2;
            int fakeBackgroundColor = textColor == -16777216 ? textColor + 65793 : 0;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, size, false);
            nativeImage.fillRect(0, 0, width, size, fakeBackgroundColor);
            RouteMapGenerator.drawResource(nativeImage, LOGO_RESOURCE, xOffset, 0, size, size, false, 0.0f, 1.0f, 0, true);
            RouteMapGenerator.drawString(nativeImage, pixels, size + xOffset, size / 2, dimensions, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, fakeBackgroundColor, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(fakeBackgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateSingleRowStationName(long platformId, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(RouteMapGenerator.getStationName(platformId).replace("|", " | "), dimensions, fontSizeBig, fontSizeSmall);
            int padding = dimensions[1] / 2;
            int height = dimensions[1] + padding;
            int width = Math.max(Math.round((float)height * aspectRatio), dimensions[0] + padding);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, -1);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateSignText(String text, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        try {
            int height = scale;
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            int tilePadding = tileSize / 4;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(text, dimensions, Integer.MAX_VALUE, (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, horizontalAlignment);
            int width = dimensions[0] - tilePadding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateLiftPanel(String text, int textColor) {
        try {
            int width = Math.round((float)scale * 1.5f);
            int height = fontSizeSmall * 2 * text.split("\\|").length;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(text.toUpperCase(Locale.ENGLISH), dimensions, width, height, fontSizeSmall * 2, fontSizeSmall * 2, 0, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, 0);
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, -16777216, textColor, false);
            RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(-16777216));
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateExitSignLetter(String exitLetter, String exitNumber, int backgroundColor) {
        try {
            int size = scale / 2;
            boolean noNumber = exitNumber.isEmpty();
            int textSize = size * 7 / 8;
            int[] dimensions1 = new int[2];
            byte[] pixels1 = DynamicTextureCache.instance.getTextPixels(exitLetter, dimensions1, noNumber ? textSize : textSize * 2 / 3, textSize, textSize, size, size, IGui.HorizontalAlignment.CENTER);
            int[] dimensions2 = new int[2];
            byte[] pixels2 = noNumber ? null : DynamicTextureCache.instance.getTextPixels(exitNumber, dimensions2, textSize / 3, textSize, textSize / 2, textSize / 2, size, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), size, size, false);
            nativeImage.fillRect(0, 0, size, size, backgroundColor);
            RouteMapGenerator.drawResource(nativeImage, EXIT_RESOURCE, 0, 0, size, size, false, 0.0f, 1.0f, 0, true);
            RouteMapGenerator.drawString(nativeImage, pixels1, size / 2 - (noNumber ? 0 : textSize / 6 - size / 32), size / 2, dimensions1, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            if (!noNumber) {
                RouteMapGenerator.drawString(nativeImage, pixels2, size / 2 + textSize / 3 - size / 32, size / 2 + textSize / 8, dimensions2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        try {
            int padding = scale / 32;
            int[] dimensions = new int[2];
            byte[] pixels = DynamicTextureCache.instance.getTextPixels(routeName, dimensions, Integer.MAX_VALUE, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f), fontSizeBig, fontSizeSmall, padding, horizontalAlignment);
            int width = dimensions[0] + padding * 2;
            int height = dimensions[1] + padding * 2;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, RouteMapGenerator.invertColor(0xFF000000 | color));
            RouteMapGenerator.drawString(nativeImage, pixels, width / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int circleX;
            ObjectArrayList<String> destinations = new ObjectArrayList<String>();
            IntArrayList colors = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> destinations.add((switch (simplifiedRoute.getCircularState()) {
                case Route.CircularState.CLOCKWISE -> TEMP_CIRCULAR_MARKER_CLOCKWISE;
                case Route.CircularState.ANTICLOCKWISE -> TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                default -> "";
            }) + simplifiedRoute.getPlatforms().get((int)currentStationIndex).getDestination()));
            boolean isTerminating = destinations.isEmpty();
            boolean leftToRight = horizontalAlignment == IGui.HorizontalAlignment.CENTER ? hasLeft || !hasRight : horizontalAlignment != IGui.HorizontalAlignment.RIGHT;
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            DynamicTextureCache clientCache = DynamicTextureCache.instance;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            nativeImage.fillRect(0, 0, width, height, RouteMapGenerator.invertColor(backgroundColor));
            if (isTerminating) {
                circleX = (int)horizontalAlignment.getOffset(0.0f, tileSize - width);
            } else {
                String destinationString = IGui.mergeStations(destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    if (isClockwise) {
                        destinationString = IGui.insertTranslation(TranslationProvider.GUI_MTR_CLOCKWISE_VIA_CJK, TranslationProvider.GUI_MTR_CLOCKWISE_VIA, 1, destinationString);
                    } else if (isAnticlockwise) {
                        destinationString = IGui.insertTranslation(TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA_CJK, TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA, 1, destinationString);
                    } else if (showToString) {
                        destinationString = IGui.insertTranslation(TranslationProvider.GUI_MTR_TO_CJK, TranslationProvider.GUI_MTR_TO, 1, destinationString);
                    }
                }
                int tilePadding = tileSize / 4;
                int leftSize = ((hasLeft ? 1 : 0) + (leftToRight ? 1 : 0)) * (tileSize + tilePadding);
                int rightSize = ((hasRight ? 1 : 0) + (leftToRight ? 0 : 1)) * (tileSize + tilePadding);
                int[] dimensionsDestination = new int[2];
                byte[] pixelsDestination = clientCache.getTextPixels(destinationString, dimensionsDestination, width - leftSize - rightSize - padding * (showToString ? 2 : 1), (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, leftToRight ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                int leftPadding = (int)horizontalAlignment.getOffset(0.0f, leftSize + rightSize + dimensionsDestination[0] - tilePadding * 2 - width);
                RouteMapGenerator.drawString(nativeImage, pixelsDestination, leftPadding + leftSize - tilePadding, height / 2, dimensionsDestination, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                if (hasLeft) {
                    RouteMapGenerator.drawResource(nativeImage, ARROW_RESOURCE, leftPadding, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
                }
                if (hasRight) {
                    RouteMapGenerator.drawResource(nativeImage, ARROW_RESOURCE, leftPadding + leftSize + dimensionsDestination[0] - tilePadding * 2 + rightSize - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor, false);
                }
                circleX = leftPadding + leftSize + (leftToRight ? -tileSize - tilePadding : dimensionsDestination[0] - tilePadding);
            }
            for (int i = 0; i < colors.size(); ++i) {
                RouteMapGenerator.drawResource(nativeImage, CIRCLE_RESOURCE, circleX, padding, tileSize, tileSize, false, (float)i / (float)colors.size(), ((float)i + 1.0f) / (float)colors.size(), colors.getInt(i), false);
            }
            Platform platform = (Platform)MinecraftClientData.getInstance().platformIdMap.get(platformId);
            if (platform != null) {
                int[] dimensionsPlatformNumber = new int[2];
                byte[] pixelsPlatformNumber = clientCache.getTextPixels(platform.getName(), dimensionsPlatformNumber, tileSize, (int)((float)tileSize * 1.25f * 3.0f / 4.0f), tileSize * 3 / 4, tileSize * 3 / 4, 0, IGui.HorizontalAlignment.CENTER);
                RouteMapGenerator.drawString(nativeImage, pixelsPlatformNumber, circleX + tileSize / 2, padding + tileSize / 2, dimensionsPlatformNumber, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            if (transparentColor != 0) {
                RouteMapGenerator.clearColor(nativeImage, RouteMapGenerator.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            ObjectArrayList routeDetails = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> routeDetails.add(new ObjectIntImmutablePair<SimplifiedRoute>((SimplifiedRoute)simplifiedRoute, (int)currentStationIndex)));
            int routeCount = routeDetails.size();
            if (routeCount > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                float yOffset;
                float extraPadding;
                float rawHeight;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList<LongArrayList> stationsIdsBefore = new ObjectArrayList<LongArrayList>();
                ObjectArrayList<LongArrayList> stationsIdsAfter = new ObjectArrayList<LongArrayList>();
                ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>> stationPositions = new ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add(new LongArrayList());
                    stationsIdsAfter.add(new LongArrayList());
                    stationPositions.add(new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList<SimplifiedRoutePlatform> simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = simplifiedRoutePlatforms.get(stationIndex).getStationId();
                        if (stationIndex < currentIndex) {
                            stationsIdsBefore.get(stationsIdsBefore.size() - 1).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                float[] bounds = new float[3];
                RouteMapGenerator.setup(stationPositions, flip ? stationsIdsBefore : stationsIdsAfter, colorIndices, bounds, flip, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup(stationPositions, flip ? stationsIdsAfter : stationsIdsBefore, colorIndices, bounds, !flip, false);
                float rawHeightPart = Math.abs(bounds[1]) + (vertical ? 0.6f : 1.0f);
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + (vertical ? 0.6f : 1.0f);
                if (vertical && rawHeightTotal < 5.0f) {
                    rawHeight = 5.0f;
                    extraPadding = (5.0f - rawHeightTotal) / 2.0f;
                    yOffset = rawHeightPart + extraPadding;
                } else {
                    rawHeight = rawHeightTotal;
                    extraPadding = 0.0f;
                    yOffset = rawHeightPart;
                }
                if (rawWidth / rawHeight > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeight / (float)scale;
                } else {
                    height = Math.round(rawHeight * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                nativeImage.fillRect(0, 0, width, height, -1);
                Object2ObjectOpenHashMap<String, ObjectOpenHashSet> stationPositionsGrouped = new Object2ObjectOpenHashMap<String, ObjectOpenHashSet>();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap<StationPosition> routeStationPositions = stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            RouteMapGenerator.drawLine(nativeImage, stationPosition, routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !stationPositionsGrouped.getOrDefault(key2, new ObjectOpenHashSet()).stream().noneMatch(stationPosition2 -> stationPosition2.stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList<String> interchangeNames = new ObjectArrayList<String>();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeColors.add(color);
                                interchangeRouteNamesForColor.forEach(interchangeNames::add);
                            }
                        });
                        Data.put(stationPositionsGrouped, key2, new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)((vertical ? heightScale : widthScale) / 2.0f + extraPadding / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    int lines;
                    int x = Math.round((stationPositionGrouped.stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((stationPositionGrouped.stationPosition.y + yOffset) * (float)scale * heightScale);
                    int n = lines = stationPositionGrouped.stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean textBelow = vertical || (stationPositionGrouped.stationPosition.isCommon ? Math.abs(stationPositionGrouped.stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale);
                    boolean currentStation = stationPositionGrouped.stationOffset == 0;
                    boolean passed = stationPositionGrouped.stationOffset < 0;
                    IntArrayList interchangeColors = stationPositionGrouped.interchangeColors;
                    if (!interchangeColors.isEmpty() && !currentStation) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / (float)interchangeColors.size());
                        for (int i = 0; i < interchangeColors.size(); ++i) {
                            for (int drawX = 0; drawX < lineWidth; ++drawX) {
                                for (int drawY = 0; drawY < lineHeight; ++drawY) {
                                    RouteMapGenerator.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + (textBelow ? -1 : lines * lineSpacing) + (textBelow ? -drawY : drawY), passed ? -5592406 : 0xFF000000 | interchangeColors.getInt(i));
                                }
                            }
                        }
                        int[] dimensions = new int[2];
                        byte[] pixels = clientCache.getTextPixels(IGui.mergeStations(stationPositionGrouped.interchangeNames), dimensions, maxStringWidth - (vertical ? lineHeight : 0), (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, vertical ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER);
                        RouteMapGenerator.drawString(nativeImage, pixels, x, y + (textBelow ? -1 - lineHeight : lines * lineSpacing + lineHeight), dimensions, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.TOP, 0, passed ? -5592406 : -16777216, vertical);
                    }
                    RouteMapGenerator.drawStation(nativeImage, x, y, heightScale, lines, passed);
                    int[] dimensions = new int[2];
                    byte[] pixels = clientCache.getTextPixels(key.split("\\|\\|")[0], dimensions, maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f), fontSizeBig, fontSizeSmall, fontSizeSmall / 4, vertical ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.CENTER);
                    RouteMapGenerator.drawString(nativeImage, pixels, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, dimensions, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? -16777216 : 0, passed ? -5592406 : (currentStation ? -1 : -16777216), vertical);
                }));
                if (transparentWhite) {
                    RouteMapGenerator.clearColor(nativeImage, -1);
                }
                return nativeImage;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), 1, 1, false);
            nativeImage.setPixelColor(0, 0, transparentWhite ? 0 : -1);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    public static void scrollTextLightRail(GraphicsHolder graphicsHolder, int rows, float availableWidth, float availableHeight, int imageWidth, int imageHeight) {
        float scale = availableHeight / (float)imageHeight * (float)rows;
        int delayTime = 3000;
        int slideTime = 8;
        int totalTime = 3000 + (int)Math.floor(availableWidth / scale) * 8;
        int totalStep = (int)(System.currentTimeMillis() % (long)(totalTime * rows));
        int step = totalStep % totalTime;
        int row = totalStep / totalTime;
        float xOffset = (availableWidth - (float)imageWidth * scale) / 2.0f;
        float x = xOffset - (float)Math.max(0, step - 3000) * scale / 8.0f;
        IDrawing.drawTexture(graphicsHolder, Math.max(x, 0.0f), 0.0f, (float)imageWidth * scale + Math.min(x, 0.0f), availableHeight, Math.max(-x, 0.0f) / (float)imageWidth / scale, (float)row / (float)rows, 1.0f, (float)(row + 1) / (float)rows, Direction.UP, -1, GraphicsHolder.getDefaultLight());
    }

    private static void setup(ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>> stationPositions, ObjectArrayList<LongArrayList> stationsIdLists, int[] colorIndices, float[] bounds, boolean passed, boolean reverse) {
        int passedMultiplier = passed ? -1 : 1;
        int reverseMultiplier = reverse ? -1 : 1;
        bounds[0] = 0.0f;
        LongArrayList commonStationIds = new LongArrayList();
        stationsIdLists.get(0).forEach(stationId -> {
            if (stationId != 0L && !commonStationIds.contains(stationId) && stationsIdLists.stream().allMatch(stationsIds -> stationsIds.contains(stationId))) {
                commonStationIds.add(stationId);
            }
        });
        int positionXOffset = 0;
        int routeCount = stationsIdLists.size();
        int[] traverseIndex = new int[routeCount];
        for (int commonStationIndex = 0; commonStationIndex <= commonStationIds.size(); ++commonStationIndex) {
            int routeIndex;
            boolean lastStation = commonStationIndex == commonStationIds.size();
            long commonStationId = lastStation ? -1L : commonStationIds.getLong(commonStationIndex);
            int intermediateSegmentsMaxCount = 0;
            int[] intermediateSegmentsCounts = new int[routeCount];
            for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                intermediateSegmentsCounts[routeIndex2] = (lastStation ? stationsIdLists.get(routeIndex2).size() : stationsIdLists.get(routeIndex2).indexOf(commonStationId) + 1) - traverseIndex[routeIndex2];
                intermediateSegmentsMaxCount = Math.max(intermediateSegmentsMaxCount, intermediateSegmentsCounts[routeIndex2]);
            }
            IntArrayList routesIndicesInSection = new IntArrayList();
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (lastStation && intermediateSegmentsCounts[routeIndex] <= 0) continue;
                routesIndicesInSection.add(routeIndex);
            }
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (intermediateSegmentsCounts[routeIndex] <= 0) continue;
                float increment = (float)intermediateSegmentsMaxCount / (float)intermediateSegmentsCounts[routeIndex];
                for (int j = 0; j < intermediateSegmentsCounts[routeIndex] - (lastStation ? 0 : 1); ++j) {
                    float stationX = (float)positionXOffset + increment * (float)(j + 1);
                    bounds[0] = Math.max(bounds[0], stationX / 2.0f);
                    float stationY = (float)routesIndicesInSection.indexOf(routeIndex) - (float)(routesIndicesInSection.size() - 1) / 2.0f + RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                    bounds[1] = Math.min(bounds[1], stationY);
                    bounds[2] = Math.max(bounds[2], stationY);
                    stationPositions.get(routeIndex).put(passedMultiplier * (j + traverseIndex[routeIndex] + 1), new StationPosition((float)reverseMultiplier * stationX / 2.0f, stationY, false));
                }
                int n = routeIndex;
                traverseIndex[n] = traverseIndex[n] + intermediateSegmentsCounts[routeIndex];
            }
            if (lastStation) continue;
            positionXOffset += intermediateSegmentsMaxCount;
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                float stationY = RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                bounds[1] = Math.min(bounds[1], stationY);
                bounds[2] = Math.max(bounds[2], stationY);
                stationPositions.get(routeIndex).put(passedMultiplier * traverseIndex[routeIndex], new StationPosition((float)(reverseMultiplier * positionXOffset) / 2.0f, stationY, true));
            }
            bounds[0] = (float)positionXOffset / 2.0f;
        }
    }

    private static float getLineOffset(int routeIndex, int[] colorIndices) {
        return (float)lineSpacing / (float)scale * ((float)colorIndices[routeIndex] - (float)colorIndices[colorIndices.length - 1] / 2.0f);
    }

    private static IntArrayList getRouteStream(long platformId, BiConsumer<SimplifiedRoute, Integer> nonTerminatingCallback) {
        IntArrayList colors = new IntArrayList();
        IntArrayList terminatingColors = new IntArrayList();
        MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0 && !simplifiedRoute.getName().isEmpty()).sorted().forEach(simplifiedRoute -> {
            int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
            if (currentStationIndex < simplifiedRoute.getPlatforms().size() - 1) {
                nonTerminatingCallback.accept((SimplifiedRoute)simplifiedRoute, currentStationIndex);
                if (!colors.contains(simplifiedRoute.getColor())) {
                    colors.add(simplifiedRoute.getColor());
                }
            } else if (!terminatingColors.contains(simplifiedRoute.getColor())) {
                terminatingColors.add(simplifiedRoute.getColor());
            }
        });
        if (colors.isEmpty()) {
            colors.addAll(terminatingColors);
        }
        return colors;
    }

    private static String getStationName(long platformId) {
        Platform platform = (Platform)MinecraftClientData.getInstance().platformIdMap.get(platformId);
        Station station = platform == null ? null : (Station)platform.area;
        return station == null ? "" : station.getName();
    }

    private static void drawLine(NativeImage nativeImage, StationPosition stationPosition1, StationPosition stationPosition2, float widthScale, float heightScale, float xOffset, float yOffset, int color) {
        int x1 = Math.round((stationPosition1.x + xOffset) * (float)scale * widthScale);
        int x2 = Math.round((stationPosition2.x + xOffset) * (float)scale * widthScale);
        int y1 = Math.round((stationPosition1.y + yOffset) * (float)scale * heightScale);
        int y2 = Math.round((stationPosition2.y + yOffset) * (float)scale * heightScale);
        int xChange = x2 - x1;
        int yChange = y2 - y1;
        int xChangeAbs = Math.abs(xChange);
        int yChangeAbs = Math.abs(yChange);
        int changeDifference = Math.abs(yChangeAbs - xChangeAbs);
        if (xChangeAbs > yChangeAbs) {
            boolean y1OffsetGreater = Math.abs((float)y1 - yOffset * (float)scale) > Math.abs((float)y2 - yOffset * (float)scale);
            RouteMapGenerator.drawLine(nativeImage, x1, y1, x2 - x1, y1OffsetGreater ? 0 : y2 - y1, y1OffsetGreater ? changeDifference : yChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, x2, y2, x1 - x2, y1OffsetGreater ? y1 - y2 : 0, y1OffsetGreater ? yChangeAbs : changeDifference, color);
        } else {
            int halfXChangeAbs = xChangeAbs / 2;
            RouteMapGenerator.drawLine(nativeImage, x1, y1, x2 - x1, y2 - y1, halfXChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, x2, y2, x1 - x2, y1 - y2, halfXChangeAbs, color);
            RouteMapGenerator.drawLine(nativeImage, (x1 + x2) / 2, y1 + (int)Math.copySign(halfXChangeAbs, y2 - y1), 0, y2 - y1, changeDifference, color);
        }
    }

    private static void drawLine(NativeImage nativeImage, int x, int y, int directionX, int directionY, int length, int color) {
        int xWidth;
        int halfLineHeight = lineSize / 2;
        int n = xWidth = directionX == 0 ? halfLineHeight : 0;
        int yWidth = directionX == 0 ? 0 : (directionY == 0 ? halfLineHeight : Math.round((float)lineSize * MathHelper.getSquareRootOfTwoMapped() / 2.0f));
        int yMin = y - halfLineHeight - (directionY < 0 ? length : 0) + 1;
        int yMax = y + halfLineHeight + (directionY > 0 ? length : 0) - 1;
        int drawOffset = directionX != 0 && directionY != 0 ? halfLineHeight : 0;
        for (int i = -drawOffset; i < Math.abs(length) + drawOffset; ++i) {
            int drawX = x + (directionX == 0 ? 0 : (int)Math.copySign(i, directionX)) + (directionX < 0 ? -1 : 0);
            int drawY = y + (directionY == 0 ? 0 : (int)Math.copySign(i, directionY)) + (directionY < 0 ? -1 : 0);
            for (int xOffset = 0; xOffset < xWidth; ++xOffset) {
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX - xOffset - 1, drawY, color);
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX + xOffset, drawY, color);
            }
            for (int yOffset = 0; yOffset < yWidth; ++yOffset) {
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX, Math.max(drawY - yOffset, yMin) - 1, color);
                RouteMapGenerator.drawPixelSafe(nativeImage, drawX, Math.min(drawY + yOffset, yMax), color);
            }
        }
    }

    private static void drawStation(NativeImage nativeImage, int x, int y, float heightScale, int lines, boolean passed) {
        for (int offsetX = -lineSize; offsetX < lineSize; ++offsetX) {
            for (int offsetY = -lineSize; offsetY < lineSize; ++offsetY) {
                int i;
                int extraOffsetY = offsetY > 0 ? (int)((float)(lines * lineSpacing) * heightScale) : 0;
                int repeatDraw = offsetY == 0 ? (int)((float)(lines * lineSpacing) * heightScale) : 0;
                double squareSum = ((double)offsetX + 0.5) * ((double)offsetX + 0.5) + ((double)offsetY + 0.5) * ((double)offsetY + 0.5);
                if (squareSum <= 0.5 * (double)lineSize * (double)lineSize) {
                    for (i = 0; i <= repeatDraw; ++i) {
                        RouteMapGenerator.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, -1);
                    }
                    continue;
                }
                if (!(squareSum <= (double)(lineSize * lineSize))) continue;
                for (i = 0; i <= repeatDraw; ++i) {
                    RouteMapGenerator.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, passed ? -5592406 : -16777216);
                }
            }
        }
    }

    private static void drawString(NativeImage nativeImage, byte[] pixels, int x, int y, int[] textDimensions, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor, boolean rotate90) {
        int drawY;
        int drawX;
        if ((backgroundColor >> 24 & 0xFF) > 0) {
            for (drawX = 0; drawX < textDimensions[rotate90 ? 1 : 0]; ++drawX) {
                for (drawY = 0; drawY < textDimensions[rotate90 ? 0 : 1]; ++drawY) {
                    RouteMapGenerator.drawPixelSafe(nativeImage, (int)horizontalAlignment.getOffset(drawX + x, textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset(drawY + y, textDimensions[rotate90 ? 0 : 1]), backgroundColor);
                }
            }
        }
        drawX = 0;
        drawY = rotate90 ? textDimensions[0] - 1 : 0;
        for (int i = 0; i < textDimensions[0] * textDimensions[1]; ++i) {
            RouteMapGenerator.blendPixel(nativeImage, (int)horizontalAlignment.getOffset(x + drawX, textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset(y + drawY, textDimensions[rotate90 ? 0 : 1]), ((pixels[i] & 0xFF) << 24) + (textColor & 0xFFFFFF));
            if (rotate90) {
                if (--drawY >= 0) continue;
                drawY = textDimensions[0] - 1;
                ++drawX;
                continue;
            }
            if (++drawX != textDimensions[0]) continue;
            drawX = 0;
            ++drawY;
        }
    }

    private static void drawStringPixelated(NativeImage nativeImage, byte[] pixels, int[] textDimensions, int textColor, boolean fullPixel) {
        int yOffset = (textDimensions[1] * (fullPixel ? 1 : 4) - nativeImage.getHeight()) / 2;
        int drawX = 0;
        int drawY = 0;
        for (int i = 0; i < textDimensions[0] * textDimensions[1]; ++i) {
            if ((pixels[i] & 0xFF) > 127) {
                if (fullPixel) {
                    RouteMapGenerator.drawPixelSafe(nativeImage, drawX, drawY - yOffset, textColor);
                } else {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            RouteMapGenerator.drawPixelSafe(nativeImage, drawX * 4 + j, drawY * 4 + k - yOffset, textColor);
                        }
                    }
                }
            }
            if (++drawX != textDimensions[0]) continue;
            drawX = 0;
            ++drawY;
        }
    }

    private static void drawResource(NativeImage nativeImage, String resource, int x, int y, int width, int height, boolean flipX, float v1, float v2, int color, boolean useActualColor) {
        ResourceManagerHelper.readResource(new Identifier("mtr", resource), inputStream2 -> {
            try {
                NativeImage nativeImageResource = NativeImage.read(NativeImageFormat.getAbgrMapped(), inputStream2);
                int resourceWidth = nativeImageResource.getWidth();
                int resourceHeight = nativeImageResource.getHeight();
                for (int drawX = 0; drawX < width; ++drawX) {
                    for (int drawY = Math.round(v1 * (float)height); drawY < Math.round(v2 * (float)height); ++drawY) {
                        int newColor;
                        float pixelX = (float)drawX / (float)width * (float)resourceWidth;
                        float pixelY = (float)drawY / (float)height * (float)resourceHeight;
                        int floorX = (int)pixelX;
                        int floorY = (int)pixelY;
                        int ceilX = floorX + 1;
                        int ceilY = floorY + 1;
                        float percentX1 = (float)ceilX - pixelX;
                        float percentY1 = (float)ceilY - pixelY;
                        float percentX2 = pixelX - (float)floorX;
                        float percentY2 = pixelY - (float)floorY;
                        int pixel1 = nativeImageResource.getColor(MathHelper.clamp(floorX, 0, resourceWidth - 1), MathHelper.clamp(floorY, 0, resourceHeight - 1));
                        int pixel2 = nativeImageResource.getColor(MathHelper.clamp(ceilX, 0, resourceWidth - 1), MathHelper.clamp(floorY, 0, resourceHeight - 1));
                        int pixel3 = nativeImageResource.getColor(MathHelper.clamp(floorX, 0, resourceWidth - 1), MathHelper.clamp(ceilY, 0, resourceHeight - 1));
                        int pixel4 = nativeImageResource.getColor(MathHelper.clamp(ceilX, 0, resourceWidth - 1), MathHelper.clamp(ceilY, 0, resourceHeight - 1));
                        if (useActualColor) {
                            newColor = RouteMapGenerator.invertColor(pixel1);
                        } else {
                            float luminance1 = (float)(pixel1 >> 24 & 0xFF) * percentX1 * percentY1;
                            float luminance2 = (float)(pixel2 >> 24 & 0xFF) * percentX2 * percentY1;
                            float luminance3 = (float)(pixel3 >> 24 & 0xFF) * percentX1 * percentY2;
                            float luminance4 = (float)(pixel4 >> 24 & 0xFF) * percentX2 * percentY2;
                            newColor = (color & 0xFFFFFF) + ((int)(luminance1 + luminance2 + luminance3 + luminance4) << 24);
                        }
                        RouteMapGenerator.blendPixel(nativeImage, (flipX ? width - drawX - 1 : drawX) + x, drawY + y, newColor);
                    }
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        });
    }

    private static void blendPixel(NativeImage nativeImage, int x, int y, int color) {
        float percent;
        if (Utilities.isBetween(x, 0.0, nativeImage.getWidth() - 1) && Utilities.isBetween(y, 0.0, nativeImage.getHeight() - 1) && (percent = (float)(color >> 24 & 0xFF) / 255.0f) > 0.0f) {
            int existingPixel = nativeImage.getColor(x, y);
            boolean existingTransparent = (existingPixel >> 24 & 0xFF) == 0;
            int r1 = existingTransparent ? 255 : existingPixel & 0xFF;
            int g1 = existingTransparent ? 255 : existingPixel >> 8 & 0xFF;
            int b1 = existingTransparent ? 255 : existingPixel >> 16 & 0xFF;
            int r2 = color >> 16 & 0xFF;
            int g2 = color >> 8 & 0xFF;
            int b2 = color & 0xFF;
            float inversePercent = 1.0f - percent;
            int finalColor = 0xFF000000 | ((int)((float)r1 * inversePercent + (float)r2 * percent) << 16) + ((int)((float)g1 * inversePercent + (float)g2 * percent) << 8) + (int)((float)b1 * inversePercent + (float)b2 * percent);
            RouteMapGenerator.drawPixelSafe(nativeImage, x, y, finalColor);
        }
    }

    private static void drawPixelSafe(NativeImage nativeImage, int x, int y, int color) {
        if (Utilities.isBetween(x, 0.0, nativeImage.getWidth() - 1) && Utilities.isBetween(y, 0.0, nativeImage.getHeight() - 1)) {
            nativeImage.setPixelColor(x, y, RouteMapGenerator.invertColor(color));
        }
    }

    private static int invertColor(int color) {
        return ((color & 0xFF000000) != 0 ? -16777216 : 0) + ((color & 0xFF) << 16) + (color & 0xFF00) + ((color & 0xFF0000) >> 16);
    }

    private static void clearColor(NativeImage nativeImage, int color) {
        for (int x = 0; x < nativeImage.getWidth(); ++x) {
            for (int y = 0; y < nativeImage.getHeight(); ++y) {
                if (nativeImage.getColor(x, y) != color) continue;
                nativeImage.setPixelColor(x, y, 0);
            }
        }
    }

    static {
        TEMP_CIRCULAR_MARKER_CLOCKWISE = String.format("temp_circular_marker_%s_clockwise", Init.randomString());
        TEMP_CIRCULAR_MARKER_ANTICLOCKWISE = String.format("temp_circular_marker_%s_anticlockwise", Init.randomString());
    }

    private static class StationPosition {
        private final float x;
        private final float y;
        private final boolean isCommon;

        private StationPosition(float x, float y, boolean isCommon) {
            this.x = x;
            this.y = y;
            this.isCommon = isCommon;
        }
    }

    private static class StationPositionGrouped {
        private final StationPosition stationPosition;
        private final int stationOffset;
        private final IntArrayList interchangeColors;
        private final ObjectArrayList<String> interchangeNames;

        private StationPositionGrouped(StationPosition stationPosition, int stationOffset, IntArrayList interchangeColors, ObjectArrayList<String> interchangeNames) {
            this.stationPosition = stationPosition;
            this.stationOffset = stationOffset;
            this.interchangeColors = interchangeColors;
            this.interchangeNames = interchangeNames;
        }
    }
}

