/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRouteBase;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderAPGGlass
extends RenderRouteBase<BlockAPGGlass.BlockEntity> {
    private static final float COLOR_STRIP_START = 0.75f;
    private static final float COLOR_STRIP_END = 0.78125f;

    public RenderAPGGlass(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher, 4.0f, 8.0f, 4.0f, 8.0f, false, 2, BlockAPGGlass.ARROW_DIRECTION);
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(World world, BlockPos pos, BlockState state) {
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.LOWER) {
            return RenderRouteBase.RenderType.NONE;
        }
        if (Math.floorMod(pos.getX(), 8) < 4 == Math.floorMod(pos.getZ(), 8) < 4) {
            return RenderRouteBase.RenderType.ARROW;
        }
        return RenderRouteBase.RenderType.ROUTE;
    }

    @Override
    protected void renderAdditional(StoredMatrixTransformations storedMatrixTransformations, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER && IBlock.getStatePropertySafe(state, SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            MainRenderer.scheduleRender(DynamicTextureCache.instance.getColorStrip((long)platformId).identifier, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, isLeft ? this.sidePadding : 0.0f, 0.75f, 0.0f, isRight ? 1.0f - this.sidePadding : 1.0f, 0.78125f, 0.0f, facing, color, light);
                IDrawing.drawTexture(graphicsHolder, isRight ? 1.0f - this.sidePadding : 1.0f, 0.75f, 0.125f, isLeft ? this.sidePadding : 0.0f, 0.78125f, 0.125f, facing, color, light);
                graphicsHolder.pop();
            });
            float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
            float height = 1.0f - this.topPadding - this.bottomPadding;
            MainRenderer.scheduleRender(DynamicTextureCache.instance.getSingleRowStationName((long)platformId, (float)(width / height)).identifier, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, 1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f), this.topPadding, 0.125f, leftBlocks == 0 ? this.sidePadding : 0.0f, 1.0f - this.bottomPadding, 0.125f, ((float)rightBlocks - (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width, 0.0f, (width - (float)leftBlocks + (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width, 1.0f, facing, color, light);
                graphicsHolder.pop();
            });
        }
    }
}

