/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

public final class Interpolation {
    private long startMillis;
    private double oldValue;
    private double latestValue;
    private final int duration;

    public Interpolation(int duration) {
        this.duration = duration;
    }

    public void setValue(double value, boolean startInterpolation) {
        if (startInterpolation && this.oldValue != value) {
            this.oldValue = this.getValue();
            this.startMillis = System.currentTimeMillis();
        }
        this.latestValue = value;
    }

    public void setValueDirect(double value) {
        this.startMillis = 0L;
        this.oldValue = value;
        this.latestValue = value;
    }

    public double getValue() {
        long difference = System.currentTimeMillis() - this.startMillis;
        if (difference < (long)this.duration) {
            return (double)(1.0f - (float)difference / (float)this.duration) * this.oldValue + (double)((float)difference / (float)this.duration) * this.latestValue;
        }
        this.oldValue = this.latestValue;
        return this.latestValue;
    }
}

