/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Route;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.RouteType;
import org.mtr.core.data.Station;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketCheckRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketSetRouteIdHasDisabledAnnouncements;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.EditNameColorScreenBase;

public class EditRouteScreen
extends EditNameColorScreenBase<Route>
implements IGui {
    private final MutableText lightRailRouteNumberText = TranslationProvider.GUI_MTR_LIGHT_RAIL_ROUTE_NUMBER.getMutableText(new Object[0]);
    private final TextFieldWidgetExtension textFieldLightRailRouteNumber = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, null);
    private final ButtonWidgetExtension buttonRouteType = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_ADD_VALUE.getMutableText(new Object[0]), button -> this.setRouteType(route, route.getRouteType().next()));
    private final CheckboxWidgetExtension buttonIsRouteHidden = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsRouteHidden);
    private final CheckboxWidgetExtension buttonDisableNextStationAnnouncements;
    private final CheckboxWidgetExtension buttonIsClockwiseRoute;
    private final CheckboxWidgetExtension buttonIsAntiClockwiseRoute;
    private final boolean isCircular;
    private static final int CHECKBOX_WIDTH = 160;

    public EditRouteScreen(Route route, ScreenExtension previousScreenExtension) {
        super(route, TranslationProvider.GUI_MTR_ROUTE_NAME, TranslationProvider.GUI_MTR_ROUTE_COLOR, previousScreenExtension);
        this.buttonIsRouteHidden.setMessage2(TranslationProvider.GUI_MTR_IS_ROUTE_HIDDEN.getText(new Object[0]));
        this.buttonDisableNextStationAnnouncements = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setDisableNextStationAnnouncements);
        this.buttonDisableNextStationAnnouncements.setMessage2(TranslationProvider.GUI_MTR_DISABLE_NEXT_STATION_ANNOUNCEMENTS.getText(new Object[0]));
        this.buttonIsClockwiseRoute = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsClockwise);
        this.buttonIsClockwiseRoute.setMessage2(TranslationProvider.GUI_MTR_IS_CLOCKWISE_ROUTE.getText(new Object[0]));
        this.buttonIsAntiClockwiseRoute = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsAntiClockwise);
        this.buttonIsAntiClockwiseRoute.setMessage2(TranslationProvider.GUI_MTR_IS_ANTICLOCKWISE_ROUTE.getText(new Object[0]));
        if (!route.getRoutePlatforms().isEmpty()) {
            Station firstStation = (Station)((RoutePlatformData)Utilities.getElement(route.getRoutePlatforms(), (int)0)).platform.area;
            Station lastStation = (Station)((RoutePlatformData)Utilities.getElement(route.getRoutePlatforms(), (int)-1)).platform.area;
            this.isCircular = firstStation != null && lastStation != null && firstStation.getId() == lastStation.getId();
        } else {
            this.isCircular = false;
        }
    }

    @Override
    protected void init2() {
        this.setPositionsAndInit(20, this.f_96543_ / 4 * 3 - 20, this.f_96543_ - 20);
        IDrawing.setPositionAndWidth(this.buttonRouteType, 20, 60, 160);
        this.setRouteType((Route)this.data, ((Route)this.data).getRouteType());
        IDrawing.setPositionAndWidth(this.buttonIsRouteHidden, 20, 80, 160);
        IDrawing.setPositionAndWidth(this.buttonDisableNextStationAnnouncements, 20, 100, 160);
        IDrawing.setPositionAndWidth(this.textFieldLightRailRouteNumber, 22, 142, 156);
        this.textFieldLightRailRouteNumber.setText2(((Route)this.data).getRouteNumber());
        IDrawing.setPositionAndWidth(this.buttonIsClockwiseRoute, 20, 164, 160);
        IDrawing.setPositionAndWidth(this.buttonIsAntiClockwiseRoute, 20, 184, 160);
        if (((Route)this.data).getTransportMode().hasRouteTypeVariation) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonRouteType));
        }
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldLightRailRouteNumber));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsRouteHidden));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDisableNextStationAnnouncements));
        if (this.isCircular) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsClockwiseRoute));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsAntiClockwiseRoute));
        }
        this.setIsRouteHidden(((Route)this.data).getHidden());
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketCheckRouteIdHasDisabledAnnouncements(((Route)this.data).getId(), this::setDisableNextStationAnnouncements));
        this.setIsClockwise(((Route)this.data).getCircularState() == Route.CircularState.CLOCKWISE);
        this.setIsAntiClockwise(((Route)this.data).getCircularState() == Route.CircularState.ANTICLOCKWISE);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            this.renderTextFields(graphicsHolder);
            if (this.textFieldLightRailRouteNumber.f_93624_) {
                graphicsHolder.drawText(this.lightRailRouteNumberText, 20, 126, -1, false, GraphicsHolder.getDefaultLight());
            }
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Route)this.data).setRouteNumber(this.textFieldLightRailRouteNumber.getText2());
        ((Route)this.data).setHidden(this.buttonIsRouteHidden.isChecked2());
        boolean routeIdHasDisabledAnnouncements = this.buttonDisableNextStationAnnouncements.isChecked2();
        MinecraftClientData.getInstance().setRouteIdHasDisabledAnnouncements(((Route)this.data).getId(), routeIdHasDisabledAnnouncements);
        if (this.isCircular) {
            ((Route)this.data).setCircularState(this.buttonIsClockwiseRoute.isChecked2() ? Route.CircularState.CLOCKWISE : (this.buttonIsAntiClockwiseRoute.isChecked2() ? Route.CircularState.ANTICLOCKWISE : Route.CircularState.NONE));
        } else {
            ((Route)this.data).setCircularState(Route.CircularState.NONE);
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute((Route)this.data)));
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketSetRouteIdHasDisabledAnnouncements(((Route)this.data).getId(), routeIdHasDisabledAnnouncements));
    }

    private void setRouteType(Route route, RouteType newRouteType) {
        route.setRouteType(newRouteType);
        this.buttonRouteType.setMessage2(EditRouteScreen.getRouteTypeText(route));
    }

    private void setIsRouteHidden(boolean isRouteHidden) {
        this.buttonIsRouteHidden.setChecked(isRouteHidden);
    }

    private void setDisableNextStationAnnouncements(boolean hasNextStationAnnouncements) {
        this.buttonDisableNextStationAnnouncements.setChecked(hasNextStationAnnouncements);
    }

    private void setIsClockwise(boolean isClockwise) {
        this.buttonIsClockwiseRoute.setChecked(isClockwise);
        if (isClockwise) {
            this.buttonIsAntiClockwiseRoute.setChecked(false);
        }
    }

    private void setIsAntiClockwise(boolean isAntiClockwise) {
        this.buttonIsAntiClockwiseRoute.setChecked(isAntiClockwise);
        if (isAntiClockwise) {
            this.buttonIsClockwiseRoute.setChecked(false);
        }
    }

    private static Text getRouteTypeText(Route route) {
        RouteType routeType = route.getRouteType();
        switch (route.getTransportMode()) {
            case TRAIN: {
                return (routeType == RouteType.LIGHT_RAIL ? TranslationProvider.GUI_MTR_ROUTE_TYPE_TRAIN_LIGHT_RAIL : (routeType == RouteType.HIGH_SPEED ? TranslationProvider.GUI_MTR_ROUTE_TYPE_TRAIN_HIGH_SPEED : TranslationProvider.GUI_MTR_ROUTE_TYPE_TRAIN_NORMAL)).getText(new Object[0]);
            }
            case BOAT: {
                return (routeType == RouteType.LIGHT_RAIL ? TranslationProvider.GUI_MTR_ROUTE_TYPE_BOAT_LIGHT_RAIL : (routeType == RouteType.HIGH_SPEED ? TranslationProvider.GUI_MTR_ROUTE_TYPE_BOAT_HIGH_SPEED : TranslationProvider.GUI_MTR_ROUTE_TYPE_BOAT_NORMAL)).getText(new Object[0]);
            }
        }
        return new Text((Component)TextHelper.literal((String)"").data);
    }
}

