/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Position;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class RailSchema
extends TwoPositionsBase {
    protected final Position position1;
    protected final Angle angle1;
    protected final Position position2;
    protected final Angle angle2;
    protected final Rail.Shape shape;
    protected final double verticalRadius;
    protected final ObjectArrayList<String> styles = new ObjectArrayList();
    protected final long speedLimit1;
    protected final long speedLimit2;
    protected final boolean isPlatform;
    protected final boolean isSiding;
    protected final boolean canAccelerate;
    protected final boolean canTurnBack;
    protected final boolean canConnectRemotely;
    protected final boolean canHaveSignal;
    protected final LongArrayList signalColors = new LongArrayList();
    protected final TransportMode transportMode;
    protected boolean stylesMigratedLegacy;

    protected RailSchema(Position position1, Angle angle1, Position position2, Angle angle2, Rail.Shape shape, double verticalRadius, long speedLimit1, long speedLimit2, boolean isPlatform, boolean isSiding, boolean canAccelerate, boolean canTurnBack, boolean canConnectRemotely, boolean canHaveSignal, TransportMode transportMode) {
        this.position1 = position1;
        this.angle1 = angle1;
        this.position2 = position2;
        this.angle2 = angle2;
        this.shape = shape;
        this.verticalRadius = verticalRadius;
        this.speedLimit1 = speedLimit1;
        this.speedLimit2 = speedLimit2;
        this.isPlatform = isPlatform;
        this.isSiding = isSiding;
        this.canAccelerate = canAccelerate;
        this.canTurnBack = canTurnBack;
        this.canConnectRemotely = canConnectRemotely;
        this.canHaveSignal = canHaveSignal;
        this.transportMode = transportMode;
    }

    protected RailSchema(ReaderBase readerBase) {
        this.position1 = new Position(readerBase.getChild("position1"));
        this.angle1 = EnumHelper.valueOf(Angle.values()[0], readerBase.getString("angle1", ""));
        this.position2 = new Position(readerBase.getChild("position2"));
        this.angle2 = EnumHelper.valueOf(Angle.values()[0], readerBase.getString("angle2", ""));
        this.shape = EnumHelper.valueOf(Rail.Shape.values()[0], readerBase.getString("shape", ""));
        this.verticalRadius = readerBase.getDouble("verticalRadius", 0.0);
        this.speedLimit1 = readerBase.getLong("speedLimit1", 0L);
        this.speedLimit2 = readerBase.getLong("speedLimit2", 0L);
        this.isPlatform = readerBase.getBoolean("isPlatform", false);
        this.isSiding = readerBase.getBoolean("isSiding", false);
        this.canAccelerate = readerBase.getBoolean("canAccelerate", false);
        this.canTurnBack = readerBase.getBoolean("canTurnBack", false);
        this.canConnectRemotely = readerBase.getBoolean("canConnectRemotely", false);
        this.canHaveSignal = readerBase.getBoolean("canHaveSignal", false);
        this.transportMode = EnumHelper.valueOf(TransportMode.values()[0], readerBase.getString("transportMode", ""));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateStringArray("styles", this.styles::clear, this.styles::add);
        readerBase.iterateLongArray("signalColors", this.signalColors::clear, this.signalColors::add);
        readerBase.unpackBoolean("stylesMigratedLegacy", value -> {
            this.stylesMigratedLegacy = value;
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        if (this.position1 != null) {
            this.position1.serializeData(writerBase.writeChild("position1"));
        }
        writerBase.writeString("angle1", this.angle1.toString());
        if (this.position2 != null) {
            this.position2.serializeData(writerBase.writeChild("position2"));
        }
        writerBase.writeString("angle2", this.angle2.toString());
        writerBase.writeString("shape", this.shape.toString());
        writerBase.writeDouble("verticalRadius", this.verticalRadius);
        this.serializeStyles(writerBase);
        writerBase.writeLong("speedLimit1", this.speedLimit1);
        writerBase.writeLong("speedLimit2", this.speedLimit2);
        writerBase.writeBoolean("isPlatform", this.isPlatform);
        writerBase.writeBoolean("isSiding", this.isSiding);
        writerBase.writeBoolean("canAccelerate", this.canAccelerate);
        writerBase.writeBoolean("canTurnBack", this.canTurnBack);
        writerBase.writeBoolean("canConnectRemotely", this.canConnectRemotely);
        writerBase.writeBoolean("canHaveSignal", this.canHaveSignal);
        this.serializeSignalColors(writerBase);
        writerBase.writeString("transportMode", this.transportMode.toString());
        this.serializeStylesMigratedLegacy(writerBase);
    }

    @Nonnull
    public String toString() {
        return "position1: " + this.position1 + "\nangle1: " + (Object)((Object)this.angle1) + "\nposition2: " + this.position2 + "\nangle2: " + (Object)((Object)this.angle2) + "\nshape: " + (Object)((Object)this.shape) + "\nverticalRadius: " + this.verticalRadius + "\nstyles: " + this.styles + "\nspeedLimit1: " + this.speedLimit1 + "\nspeedLimit2: " + this.speedLimit2 + "\nisPlatform: " + this.isPlatform + "\nisSiding: " + this.isSiding + "\ncanAccelerate: " + this.canAccelerate + "\ncanTurnBack: " + this.canTurnBack + "\ncanConnectRemotely: " + this.canConnectRemotely + "\ncanHaveSignal: " + this.canHaveSignal + "\nsignalColors: " + this.signalColors + "\ntransportMode: " + (Object)((Object)this.transportMode) + "\nstylesMigratedLegacy: " + this.stylesMigratedLegacy + "\n";
    }

    protected void serializeStyles(WriterBase writerBase) {
        WriterBase.Array stylesWriterBaseArray = writerBase.writeArray("styles");
        this.styles.forEach(stylesWriterBaseArray::writeString);
    }

    protected void serializeSignalColors(WriterBase writerBase) {
        WriterBase.Array signalColorsWriterBaseArray = writerBase.writeArray("signalColors");
        this.signalColors.forEach(signalColorsWriterBaseArray::writeLong);
    }

    protected void serializeStylesMigratedLegacy(WriterBase writerBase) {
        writerBase.writeBoolean("stylesMigratedLegacy", this.stylesMigratedLegacy);
    }
}

