/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.okhttp3.internal.connection;

import java.io.IOException;
import org.mtr.libraries.kotlin.Metadata;
import org.mtr.libraries.kotlin.collections.ArrayDeque;
import org.mtr.libraries.kotlin.jvm.internal.DefaultConstructorMarker;
import org.mtr.libraries.kotlin.jvm.internal.Intrinsics;
import org.mtr.libraries.okhttp3.Address;
import org.mtr.libraries.okhttp3.HttpUrl;
import org.mtr.libraries.okhttp3.internal.connection.RealConnection;
import org.mtr.libraries.org.jetbrains.annotations.NotNull;
import org.mtr.libraries.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0014\u0015J\u0014\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH&J\b\u0010\u000f\u001a\u00020\fH&J\b\u0010\u0010\u001a\u00020\bH&J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner;", "", "address", "Lorg/mtr/libraries/okhttp3/Address;", "getAddress", "()Lokhttp3/Address;", "deferredPlans", "Lorg/mtr/libraries/kotlin/collections/ArrayDeque;", "Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner$Plan;", "getDeferredPlans", "()Lkotlin/collections/ArrayDeque;", "hasNext", "", "failedConnection", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnection;", "isCanceled", "plan", "sameHostAndPort", "url", "Lorg/mtr/libraries/okhttp3/HttpUrl;", "ConnectResult", "Plan", "okhttp"})
public interface RoutePlanner {
    @NotNull
    public Address getAddress();

    @NotNull
    public ArrayDeque<Plan> getDeferredPlans();

    public boolean isCanceled();

    @NotNull
    public Plan plan() throws IOException;

    public boolean hasNext(@Nullable RealConnection var1);

    public static /* synthetic */ boolean hasNext$default(RoutePlanner routePlanner, RealConnection realConnection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hasNext");
        }
        if ((n & 1) != 0) {
            realConnection = null;
        }
        return routePlanner.hasNext(realConnection);
    }

    public boolean sameHostAndPort(@NotNull HttpUrl var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner$ConnectResult;", "", "plan", "Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner$Plan;", "nextPlan", "throwable", "", "(Lokhttp3/internal/connection/RoutePlanner$Plan;Lokhttp3/internal/connection/RoutePlanner$Plan;Ljava/lang/Throwable;)V", "isSuccess", "", "()Z", "getNextPlan", "()Lokhttp3/internal/connection/RoutePlanner$Plan;", "getPlan", "getThrowable", "()Ljava/lang/Throwable;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "okhttp"})
    public static final class ConnectResult {
        @NotNull
        private final Plan plan;
        @Nullable
        private final Plan nextPlan;
        @Nullable
        private final Throwable throwable;

        public ConnectResult(@NotNull Plan plan, @Nullable Plan nextPlan, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter(plan, "plan");
            this.plan = plan;
            this.nextPlan = nextPlan;
            this.throwable = throwable;
        }

        public /* synthetic */ ConnectResult(Plan plan, Plan plan2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                plan2 = null;
            }
            if ((n & 4) != 0) {
                throwable = null;
            }
            this(plan, plan2, throwable);
        }

        @NotNull
        public final Plan getPlan() {
            return this.plan;
        }

        @Nullable
        public final Plan getNextPlan() {
            return this.nextPlan;
        }

        @Nullable
        public final Throwable getThrowable() {
            return this.throwable;
        }

        public final boolean isSuccess() {
            return this.nextPlan == null && this.throwable == null;
        }

        @NotNull
        public final Plan component1() {
            return this.plan;
        }

        @Nullable
        public final Plan component2() {
            return this.nextPlan;
        }

        @Nullable
        public final Throwable component3() {
            return this.throwable;
        }

        @NotNull
        public final ConnectResult copy(@NotNull Plan plan, @Nullable Plan nextPlan, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter(plan, "plan");
            return new ConnectResult(plan, nextPlan, throwable);
        }

        public static /* synthetic */ ConnectResult copy$default(ConnectResult connectResult, Plan plan, Plan plan2, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                plan = connectResult.plan;
            }
            if ((n & 2) != 0) {
                plan2 = connectResult.nextPlan;
            }
            if ((n & 4) != 0) {
                throwable = connectResult.throwable;
            }
            return connectResult.copy(plan, plan2, throwable);
        }

        @NotNull
        public String toString() {
            return "ConnectResult(plan=" + this.plan + ", nextPlan=" + this.nextPlan + ", throwable=" + this.throwable + ')';
        }

        public int hashCode() {
            int result = this.plan.hashCode();
            result = result * 31 + (this.nextPlan == null ? 0 : this.nextPlan.hashCode());
            result = result * 31 + (this.throwable == null ? 0 : this.throwable.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectResult)) {
                return false;
            }
            ConnectResult connectResult = (ConnectResult)other;
            if (!Intrinsics.areEqual(this.plan, connectResult.plan)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nextPlan, connectResult.nextPlan)) {
                return false;
            }
            return Intrinsics.areEqual(this.throwable, connectResult.throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\bH&J\b\u0010\n\u001a\u00020\u000bH&J\n\u0010\f\u001a\u0004\u0018\u00010\u0000H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner$Plan;", "", "isReady", "", "()Z", "cancel", "", "connectTcp", "Lorg/mtr/libraries/okhttp3/internal/connection/RoutePlanner$ConnectResult;", "connectTlsEtc", "handleSuccess", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnection;", "retry", "okhttp"})
    public static interface Plan {
        public boolean isReady();

        @NotNull
        public ConnectResult connectTcp();

        @NotNull
        public ConnectResult connectTlsEtc();

        @NotNull
        public RealConnection handleSuccess();

        public void cancel();

        @Nullable
        public Plan retry();
    }
}

