/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.block.IBlock;

public interface DoubleVerticalBlock
extends IBlock,
DirectionHelper {
    @Nonnull
    public static BlockState getStateForNeighborUpdate(BlockState blockState, Direction direction, boolean isThis, BlockState defaultBlockState) {
        boolean isTop;
        boolean bl = isTop = IBlock.getStatePropertySafe(blockState, HALF) == IBlock.DoubleBlockHalf.UPPER;
        if ((isTop && direction == Direction.DOWN || !isTop && direction == Direction.UP) && !isThis) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return defaultBlockState;
    }

    public static void onPlaced(World world, BlockPos blockPos, BlockState blockState, BlockState defaultPlacementState) {
        if (!world.isClient()) {
            Direction direction = IBlock.getStatePropertySafe(blockState, FACING);
            world.setBlockState(blockPos.up(), defaultPlacementState.with(new Property((class_2769)DoubleVerticalBlock.FACING.data), direction.data).with(new Property((class_2769)DoubleVerticalBlock.HALF.data), IBlock.DoubleBlockHalf.UPPER), 3);
            world.updateNeighbors(blockPos, Blocks.getAirMapped());
            blockState.updateNeighbors(new WorldAccess((class_1936)world.data), blockPos, 3);
        }
    }

    @Nullable
    public static BlockState getPlacementState(ItemPlacementContext itemPlacementContext, BlockState defaultPlacementState) {
        Direction direction = itemPlacementContext.getPlayerFacing();
        return IBlock.isReplaceable(itemPlacementContext, Direction.UP, 2) ? defaultPlacementState.with(new Property((class_2769)DoubleVerticalBlock.FACING.data), direction.data).with(new Property((class_2769)DoubleVerticalBlock.HALF.data), IBlock.DoubleBlockHalf.LOWER) : null;
    }

    public static void onBreak(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        BlockPos breakBlockPos = IBlock.getStatePropertySafe(blockState, HALF) == IBlock.DoubleBlockHalf.UPPER ? blockPos.down() : blockPos;
        IBlock.onBreakCreative(world, playerEntity, breakBlockPos);
    }
}

