/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.BlockStationNameEntrance;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderStationNameBase;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderStationNameTiled<T extends BlockStationNameBase.BlockEntityBase>
extends RenderStationNameBase<T> {
    private final boolean showLogo;

    public RenderStationNameTiled(BlockEntityRenderer.Argument dispatcher, boolean showLogo) {
        super(dispatcher);
        this.showLogo = showLogo;
    }

    @Override
    protected void drawStationName(World world, BlockPos pos, BlockState state, Direction facing, StoredMatrixTransformations storedMatrixTransformations, String stationName, int stationColor, int color, int light) {
        int lengthLeft = this.getLength(world, pos, false);
        int lengthRight = this.getLength(world, pos, true);
        int totalLength = lengthLeft + lengthRight - 1;
        if (this.showLogo) {
            int propagateProperty = IBlock.getStatePropertySafe(world, pos, BlockStationNameEntrance.STYLE);
            float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
            MainRenderer.scheduleRender(DynamicTextureCache.instance.getStationNameEntrance((int)(propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216), (String)IGui.insertTranslation((TranslationProvider.TranslationHolder)TranslationProvider.GUI_MTR_STATION_CJK, (TranslationProvider.TranslationHolder)TranslationProvider.GUI_MTR_STATION, (int)1, (String[])new String[]{stationName}), (float)((float)totalLength / logoSize)).identifier, false, QueuedRenderLayer.INTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.5f, -logoSize / 2.0f, 1.0f, logoSize, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                graphicsHolder.pop();
            });
        } else {
            MainRenderer.scheduleRender(DynamicTextureCache.instance.getStationName((String)stationName, (float)((float)totalLength)).identifier, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.5f, -0.5f, 1.0f, 1.0f, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                graphicsHolder.pop();
            });
        }
    }

    private int getLength(@Nullable World world, BlockPos pos, boolean lookRight) {
        if (world == null) {
            return 1;
        }
        Direction facing = IBlock.getStatePropertySafe(world, pos, BlockStationNameBase.FACING);
        Block thisBlock = world.getBlockState(pos).getBlock();
        int length = 1;
        while (true) {
            Block checkBlock = world.getBlockState(pos.offset(lookRight ? facing.rotateYClockwise() : facing.rotateYCounterclockwise(), length)).getBlock();
            if (!(checkBlock.data instanceof BlockStationNameBase) || checkBlock.data != thisBlock.data) break;
            ++length;
        }
        return length;
    }
}

