/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.class_2561;
import net.minecraft.class_339;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockEyeCandy;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateEyeCandyConfig;
import org.mtr.mod.resource.ObjectResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.EyeCandyObjectSelectionScreen;

public class EyeCandyScreen
extends ScreenExtension
implements IGui {
    private final ButtonWidgetExtension buttonSelectModel;
    private final TextFieldWidgetExtension textFieldTranslateX;
    private final TextFieldWidgetExtension textFieldTranslateY;
    private final TextFieldWidgetExtension textFieldTranslateZ;
    private final TextFieldWidgetExtension textFieldRotateX;
    private final TextFieldWidgetExtension textFieldRotateY;
    private final TextFieldWidgetExtension textFieldRotateZ;
    private final CheckboxWidgetExtension buttonFullBrightness;
    private static final MutableText SELECT_MODEL_TEXT = TranslationProvider.GUI_MTR_SELECT_MODEL.getMutableText(new Object[0]);
    private static final MutableText MODEL_TRANSLATION_TEXT = TranslationProvider.GUI_MTR_MODEL_TRANSLATION.getMutableText(new Object[0]);
    private static final MutableText MODEL_ROTATION_TEXT = TranslationProvider.GUI_MTR_MODEL_ROTATION.getMutableText(new Object[0]);
    private static final MutableText X_TEXT = TextHelper.literal("X");
    private static final MutableText Y_TEXT = TextHelper.literal("Y");
    private static final MutableText Z_TEXT = TextHelper.literal("Z");
    private static final int MAX_NUMBER_TEXT_LENGTH = 10;
    private final BlockPos blockPos;
    private final BlockEyeCandy.BlockEntity blockEntity;
    private final ObjectImmutableList<ObjectResource> loadedObjects = CustomResourceLoader.getObjects();
    private final LongArrayList selectedModelIndices = new LongArrayList();
    private final int xStart;

    public EyeCandyScreen(BlockPos blockPos, BlockEyeCandy.BlockEntity blockEntity) {
        this.blockPos = blockPos;
        this.blockEntity = blockEntity;
        ObjectArrayList<DashboardListItem> objectsForList = new ObjectArrayList<DashboardListItem>();
        for (int i = 0; i < this.loadedObjects.size(); ++i) {
            ObjectResource objectResource = this.loadedObjects.get(i);
            objectsForList.add(new DashboardListItem(i, objectResource.getName(), objectResource.getColor() | 0xFF000000));
            if (!objectResource.getId().equals(blockEntity.getModelId())) continue;
            this.selectedModelIndices.add(i);
        }
        this.buttonSelectModel = new ButtonWidgetExtension(0, 0, 0, 20, button -> MinecraftClient.getInstance().openScreen(new Screen(new EyeCandyObjectSelectionScreen(new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)objectsForList), this.selectedModelIndices, this::sendUpdate, this))));
        this.buttonSelectModel.setMessage2(new Text((class_2561)TextHelper.translatable((String)"selectWorld.edit", (Object[])new Object[0]).data));
        this.textFieldTranslateX = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldTranslateX.setChangedListener2(text -> this.sendUpdate());
        this.textFieldTranslateY = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldTranslateY.setChangedListener2(text -> this.sendUpdate());
        this.textFieldTranslateZ = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldTranslateZ.setChangedListener2(text -> this.sendUpdate());
        this.textFieldRotateX = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldRotateX.setChangedListener2(text -> this.sendUpdate());
        this.textFieldRotateY = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldRotateY.setChangedListener2(text -> this.sendUpdate());
        this.textFieldRotateZ = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
        this.textFieldRotateZ.setChangedListener2(text -> this.sendUpdate());
        this.buttonFullBrightness = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> this.sendUpdate());
        this.buttonFullBrightness.setMessage2(TranslationProvider.GUI_MTR_MODEL_FULL_BRIGHTNESS.getText(new Object[0]));
        this.xStart = Math.max(GraphicsHolder.getTextWidth(X_TEXT), Math.max(GraphicsHolder.getTextWidth(Y_TEXT), GraphicsHolder.getTextWidth(Z_TEXT)));
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonSelectModel, 20 + GraphicsHolder.getTextWidth(SELECT_MODEL_TEXT) + 6, 20, 60);
        IDrawing.setPositionAndWidth(this.textFieldTranslateX, 20 + this.xStart + 6, 62, 80);
        IDrawing.setPositionAndWidth(this.textFieldTranslateY, 20 + this.xStart + 6, 86, 80);
        IDrawing.setPositionAndWidth(this.textFieldTranslateZ, 20 + this.xStart + 6, 110, 80);
        IDrawing.setPositionAndWidth(this.textFieldRotateX, this.field_22789 / 2 + this.xStart + 6, 62, 80);
        IDrawing.setPositionAndWidth(this.textFieldRotateY, this.field_22789 / 2 + this.xStart + 6, 86, 80);
        IDrawing.setPositionAndWidth(this.textFieldRotateZ, this.field_22789 / 2 + this.xStart + 6, 110, 80);
        IDrawing.setPositionAndWidth(this.buttonFullBrightness, this.field_22789 / 2, 20, this.field_22789);
        this.textFieldTranslateX.setText2(String.valueOf(this.blockEntity.getTranslateX()));
        this.textFieldTranslateY.setText2(String.valueOf(this.blockEntity.getTranslateY()));
        this.textFieldTranslateZ.setText2(String.valueOf(this.blockEntity.getTranslateZ()));
        this.textFieldRotateX.setText2(String.valueOf(Math.toDegrees(this.blockEntity.getRotateX())));
        this.textFieldRotateY.setText2(String.valueOf(Math.toDegrees(this.blockEntity.getRotateY())));
        this.textFieldRotateZ.setText2(String.valueOf(Math.toDegrees(this.blockEntity.getRotateZ())));
        this.buttonFullBrightness.setChecked(this.blockEntity.getFullBrightness());
        this.addChild(new ClickableWidget((class_339)this.buttonSelectModel));
        this.addChild(new ClickableWidget((class_339)this.textFieldTranslateX));
        this.addChild(new ClickableWidget((class_339)this.textFieldTranslateY));
        this.addChild(new ClickableWidget((class_339)this.textFieldTranslateZ));
        this.addChild(new ClickableWidget((class_339)this.textFieldRotateX));
        this.addChild(new ClickableWidget((class_339)this.textFieldRotateY));
        this.addChild(new ClickableWidget((class_339)this.textFieldRotateZ));
        this.addChild(new ClickableWidget((class_339)this.buttonFullBrightness));
    }

    @Override
    public void tick2() {
        super.tick2();
        this.textFieldTranslateX.tick2();
        this.textFieldTranslateY.tick2();
        this.textFieldTranslateZ.tick2();
        this.textFieldRotateX.tick2();
        this.textFieldRotateY.tick2();
        this.textFieldRotateZ.tick2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.drawText(SELECT_MODEL_TEXT, 20, 26, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(MODEL_TRANSLATION_TEXT, 20, 46, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(X_TEXT, 20, 68, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(Y_TEXT, 20, 92, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(Z_TEXT, 20, 116, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(MODEL_ROTATION_TEXT, this.field_22789 / 2, 46, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(X_TEXT, this.field_22789 / 2, 68, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(Y_TEXT, this.field_22789 / 2, 92, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(Z_TEXT, this.field_22789 / 2, 116, -1, false, GraphicsHolder.getDefaultLight());
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void sendUpdate() {
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateEyeCandyConfig(this.blockPos, this.selectedModelIndices.isEmpty() ? null : ((ObjectResource)Utilities.getElement(this.loadedObjects, (int)this.selectedModelIndices.getLong(0))).getId(), EyeCandyScreen.parse(this.textFieldTranslateX.getText2()), EyeCandyScreen.parse(this.textFieldTranslateY.getText2()), EyeCandyScreen.parse(this.textFieldTranslateZ.getText2()), (float)Math.toRadians(EyeCandyScreen.parse(this.textFieldRotateX.getText2())), (float)Math.toRadians(EyeCandyScreen.parse(this.textFieldRotateY.getText2())), (float)Math.toRadians(EyeCandyScreen.parse(this.textFieldRotateZ.getText2())), this.buttonFullBrightness.isChecked2()));
    }

    private static float parse(String text) {
        try {
            return Float.parseFloat(text);
        }
        catch (Exception ignored) {
            return 0.0f;
        }
    }
}

