/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.resource.CustomResourcesConverter;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.javax.servlet.AsyncContext;
import org.mtr.libraries.javax.servlet.http.HttpServletRequest;
import org.mtr.libraries.javax.servlet.http.HttpServletResponse;
import org.mtr.libraries.javax.servlet.http.Part;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.resource.CustomResources;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.ModelWrapper;
import org.mtr.mod.resource.ResourceWrapper;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.resource.VehicleResource;
import org.mtr.mod.resource.VehicleResourceWrapper;
import org.mtr.mod.screen.ReloadCustomResourcesScreen;
import org.mtr.mod.servlet.AbstractResourcePackCreatorServlet;

public final class ResourcePackCreatorUploadServlet
extends AbstractResourcePackCreatorServlet {
    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AsyncContext asyncContext = httpServletRequest.startAsync();
        asyncContext.setTimeout(0L);
        ResourcePackCreatorUploadServlet.setEncoding(httpServletRequest, httpServletResponse);
        switch (httpServletRequest.getPathInfo()) {
            case "/reset": {
                ResourcePackCreatorUploadServlet.reset();
                MinecraftClient minecraftClient = MinecraftClient.getInstance();
                minecraftClient.execute(() -> minecraftClient.openScreen(new Screen(new ReloadCustomResourcesScreen(() -> {
                    CustomResourceLoader.reload();
                    ResourcePackCreatorUploadServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
                }))));
                break;
            }
            case "/export": {
                ResourcePackCreatorUploadServlet.export(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            default: {
                ResourcePackCreatorUploadServlet.returnErrorResponse(httpServletResponse, asyncContext);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AsyncContext asyncContext = httpServletRequest.startAsync();
        asyncContext.setTimeout(0L);
        ResourcePackCreatorUploadServlet.setEncoding(httpServletRequest, httpServletResponse);
        switch (httpServletRequest.getPathInfo()) {
            case "/zip": {
                ResourcePackCreatorUploadServlet.reset();
                ResourcePackCreatorUploadServlet.uploadZip(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            case "/resources": {
                ResourcePackCreatorUploadServlet.uploadResource(httpServletRequest, httpServletResponse, asyncContext);
                break;
            }
            default: {
                ResourcePackCreatorUploadServlet.returnErrorResponse(httpServletResponse, asyncContext);
            }
        }
    }

    static String getModel(String name) {
        return (String)MODELS.get(name);
    }

    private static void reset() {
        ObjectArrayList texturesToDestroy = new ObjectArrayList(TEXTURES.keySet());
        resourceWrapper = null;
        MODELS.clear();
        TEXTURES.clear();
        try {
            Files.deleteIfExists(ResourcePackCreatorUploadServlet.getBackupFile());
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        minecraftClient.execute(() -> texturesToDestroy.forEach(texture -> {
            try {
                minecraftClient.getTextureManager().destroyTexture(new Identifier((String)texture));
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }));
    }

    private static void uploadZip(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        block16: {
            try {
                Iterator<Part> iterator2 = httpServletRequest.getParts().iterator();
                if (!iterator2.hasNext()) break block16;
                Part part = iterator2.next();
                Init.LOGGER.info("Processing {} uploaded from the Resource Pack Creator", (Object)part.getSubmittedFileName());
                JsonObject customResourcesObject = null;
                Object2ObjectAVLTreeMap<String, String> jsonCache = new Object2ObjectAVLTreeMap<String, String>();
                ObjectArrayList<Runnable> resourceUploadTasks = new ObjectArrayList<Runnable>();
                String lastNameRead = "";
                try (ZipInputStream zipInputStream = new ZipInputStream(part.getInputStream());){
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String name;
                        lastNameRead = name = ResourcePackCreatorUploadServlet.pathToIdentifier(zipEntry.getName());
                        Init.LOGGER.debug("Reading {}", (Object)name);
                        byte[] bytes = IOUtils.toByteArray((InputStream)zipInputStream);
                        String content = new String(bytes);
                        if (name.equals(String.format("%s:%s.json", "mtr", "mtr_custom_resources"))) {
                            customResourcesObject = Utilities.parseJson(content);
                        } else if (name.endsWith(".png") || name.endsWith(".bbmodel") || name.endsWith(".obj") || name.endsWith(".mtl")) {
                            resourceUploadTasks.add(() -> ResourcePackCreatorUploadServlet.uploadResource(name, bytes, content));
                        } else if (name.endsWith(".json")) {
                            jsonCache.put(name, content);
                        }
                        zipInputStream.closeEntry();
                    }
                }
                catch (Exception e) {
                    Init.LOGGER.error("Processing {} failed; last successful file read was {}", (Object)part.getSubmittedFileName(), (Object)lastNameRead);
                    Init.LOGGER.error("", (Throwable)e);
                }
                if (customResourcesObject != null) {
                    JsonObject newCustomResourcesObject = customResourcesObject;
                    MinecraftClient minecraftClient = MinecraftClient.getInstance();
                    minecraftClient.execute(() -> minecraftClient.openScreen(new Screen(new ReloadCustomResourcesScreen(() -> {
                        ObjectArrayList<VehicleResourceWrapper> vehicles = new ObjectArrayList<VehicleResourceWrapper>();
                        CustomResourcesConverter.convert(newCustomResourcesObject, identifier -> jsonCache.getOrDefault(((class_2960)identifier.data).toString(), ResourceManagerHelper.readResource(identifier))).iterateVehicles(vehicleResource -> vehicles.add(vehicleResource.toVehicleResourceWrapper()));
                        resourceWrapper = new ResourceWrapper(vehicles, new ObjectArrayList<ModelWrapper>(), new ObjectArrayList<String>(), CustomResourceLoader.getMinecraftModelResources(), CustomResourceLoader.getTextureResources());
                        resourceUploadTasks.forEach(Runnable::run);
                        ResourcePackCreatorUploadServlet.returnStandardResponse(httpServletResponse, asyncContext, "");
                    }))));
                    return;
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
        ResourcePackCreatorUploadServlet.returnErrorResponse(httpServletResponse, asyncContext);
    }

    private static void uploadResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        if (resourceWrapper != null) {
            try {
                for (Part part : httpServletRequest.getParts()) {
                    try {
                        InputStream inputStream2 = part.getInputStream();
                        try {
                            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream2);
                            ResourcePackCreatorUploadServlet.uploadResource(String.format("%s:%s", "mtr", part.getSubmittedFileName()), bytes, new String(bytes));
                        }
                        finally {
                            if (inputStream2 == null) continue;
                            inputStream2.close();
                        }
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                }
                ResourcePackCreatorUploadServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
                return;
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
        ResourcePackCreatorUploadServlet.returnErrorResponse(httpServletResponse, asyncContext);
    }

    private static void export(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AsyncContext asyncContext) {
        String name = httpServletRequest.getParameter("name");
        String description = httpServletRequest.getParameter("description");
        if (resourceWrapper != null && name != null && description != null) {
            JsonObject vehiclesFlattened = resourceWrapper.flatten();
            MinecraftClient.getInstance().execute(() -> {
                ObjectArrayList<VehicleResource> vehicles = new ObjectArrayList<VehicleResource>();
                Object2ObjectArrayMap modelPropertiesMap = new Object2ObjectArrayMap();
                Object2ObjectArrayMap positionDefinitionsMap = new Object2ObjectArrayMap();
                new ResourceWrapper(new JsonReader(vehiclesFlattened), new ObjectArrayList<MinecraftModelResource>(), new ObjectArrayList<String>()).iterateVehicles(vehicleResourceWrapper -> vehicles.add(vehicleResourceWrapper.toVehicleResource(identifier -> {
                    String modelString = ResourcePackCreatorUploadServlet.getModel(((class_2960)identifier.data).toString());
                    return modelString == null ? ResourceManagerHelper.readResource(identifier) : modelString;
                }, modelPropertiesMap, positionDefinitionsMap)));
                CustomResources customResources = new CustomResources(vehicles, new ObjectArrayList<SignResource>());
                String resourcePackFolder = String.format("%s/resourcepacks", MinecraftClient.getInstance().getRunDirectoryMapped());
                String filePath = String.format("%s/%s-%s.zip", resourcePackFolder, name, DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(LocalDateTime.now()));
                Init.LOGGER.info("Exporting Resource Pack at {}", (Object)filePath);
                try (FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                     ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                    ResourcePackCreatorUploadServlet.writeToZipOutputStream(modelPropertiesMap, zipOutputStream, modelProperties -> IOUtils.write((String)Utilities.getJsonObjectFromData(modelProperties).toString(), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8));
                    ResourcePackCreatorUploadServlet.writeToZipOutputStream(positionDefinitionsMap, zipOutputStream, positionDefinitions -> IOUtils.write((String)Utilities.getJsonObjectFromData(positionDefinitions).toString(), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8));
                    ResourcePackCreatorUploadServlet.writeToZipOutputStream(MODELS, zipOutputStream, modelString -> IOUtils.write((String)modelString, (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8));
                    ResourcePackCreatorUploadServlet.writeToZipOutputStream(TEXTURES, zipOutputStream, textureBytes -> IOUtils.write((byte[])textureBytes, (OutputStream)zipOutputStream));
                    zipOutputStream.putNextEntry(new ZipEntry(String.format("assets/%s/%s.json", "mtr", "mtr_custom_resources")));
                    IOUtils.write((String)Utilities.getJsonObjectFromData(customResources).toString(), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                    zipOutputStream.putNextEntry(new ZipEntry("pack.mcmeta"));
                    JsonObject packInfoObject = new JsonObject();
                    packInfoObject.addProperty("pack_format", ResourceManagerHelper.getResourcePackVersion());
                    packInfoObject.addProperty("description", description);
                    JsonObject packObject = new JsonObject();
                    packObject.add("pack", packInfoObject);
                    IOUtils.write((String)Utilities.prettyPrint(packObject), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                    ResourceManagerHelper.readResource(new Identifier("mtr", "textures/block/sign/logo_grayscale.png"), inputStream2 -> {
                        try {
                            zipOutputStream.putNextEntry(new ZipEntry("pack.png"));
                            IOUtils.write((byte[])IOUtils.toByteArray((InputStream)inputStream2), (OutputStream)zipOutputStream);
                        }
                        catch (Exception e) {
                            Init.LOGGER.error("", (Throwable)e);
                        }
                    });
                }
                catch (Exception e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
                Util.getOperatingSystem().open(new File(resourcePackFolder));
            });
            ResourcePackCreatorUploadServlet.returnStandardResponse(httpServletResponse, asyncContext, null);
        } else {
            ResourcePackCreatorUploadServlet.returnErrorResponse(httpServletResponse, asyncContext);
        }
    }

    private static <T> void writeToZipOutputStream(Object2ObjectMap<String, T> dataMap, ZipOutputStream zipOutputStream, DataConsumer<T> writeData) {
        dataMap.forEach((name, data) -> {
            try {
                zipOutputStream.putNextEntry(new ZipEntry(ResourcePackCreatorUploadServlet.identifierToPath(name)));
                writeData.accept(data);
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        });
    }

    private static String pathToIdentifier(String name) {
        String[] nameSplit = name.split("/");
        if (nameSplit.length >= 3) {
            CharSequence[] newNameSplit = new String[nameSplit.length - 2];
            System.arraycopy(nameSplit, 2, newNameSplit, 0, newNameSplit.length);
            return String.format("%s:%s", nameSplit[1], String.join((CharSequence)"/", newNameSplit));
        }
        return "";
    }

    private static String identifierToPath(String identifierString) {
        String[] stringSplit = identifierString.split(":");
        if (stringSplit.length == 2) {
            return String.format("assets/%s/%s", stringSplit[0], stringSplit[1]);
        }
        Init.LOGGER.error("Invalid identifier {}", (Object)identifierString);
        return Init.randomString();
    }

    @FunctionalInterface
    private static interface DataConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

