/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import javax.annotation.Nullable;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3i;

public final class ScheduledSound {
    private BlockPos blockPos;
    private final SoundEvent soundEvent;
    private final float gain;
    private final float pitch;
    private static final Object2ObjectAVLTreeMap<String, ScheduledSound> SCHEDULED_SOUNDS = new Object2ObjectAVLTreeMap();

    private ScheduledSound(BlockPos blockPos, SoundEvent soundEvent, float gain, float pitch) {
        this.blockPos = blockPos;
        this.soundEvent = soundEvent;
        this.gain = Math.min(1.0f, gain);
        this.pitch = pitch;
    }

    private void play() {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null) {
            SCHEDULED_SOUNDS.values().forEach(scheduledSound -> clientWorld.playSoundAtBlockCenter(this.blockPos, this.soundEvent, SoundCategory.getBlocksMapped(), this.gain, this.pitch, false));
        }
    }

    public static void schedule(BlockPos blockPos, @Nullable SoundEvent soundEvent, float gain, float pitch) {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (soundEvent != null && clientPlayerEntity != null) {
            String currentKey = String.format("%s_%s_%s", ((class_2960)soundEvent.getId().data).toString(), Float.valueOf(gain), Float.valueOf(pitch));
            ScheduledSound scheduledSound = SCHEDULED_SOUNDS.computeIfAbsent(currentKey, key -> new ScheduledSound(blockPos, soundEvent, gain, pitch));
            Vector3i clientPos = new Vector3i((class_2382)clientPlayerEntity.getBlockPos().data);
            if (blockPos.getManhattanDistance(clientPos) < scheduledSound.blockPos.getManhattanDistance(clientPos)) {
                scheduledSound.blockPos = blockPos;
            }
        }
    }

    public static void playScheduledSounds() {
        SCHEDULED_SOUNDS.values().forEach(ScheduledSound::play);
        SCHEDULED_SOUNDS.clear();
    }
}

