/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.legacy.resource;

import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.TransportMode;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.JsonWriter;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.generated.resource.VehicleResourceSchema;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.VehicleModel;
import org.mtr.mod.resource.VehicleResource;

public final class LegacyVehicleResource
extends VehicleResourceSchema {
    public LegacyVehicleResource(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public void convert(ObjectArrayList<VehicleResource> vehicleResources, String id, ResourceProvider resourceProvider) {
        for (int i = 0; i < Variation.values().length; ++i) {
            Variation variation = Variation.values()[i];
            VehicleResource[] baseVehicleResource = new VehicleResource[]{null};
            for (TransportMode transportMode : TransportMode.values()) {
                String newBaseTrainType = transportMode == TransportMode.CABLE_CAR || this.base_train_type.startsWith("light_rail") ? (this.base_train_type.endsWith("_rht") || this.base_train_type.endsWith("_lht") ? this.base_train_type : this.base_train_type + "_lht") : String.format("%s_%s", this.base_train_type, variation.key);
                CustomResourceLoader.getVehicleById(transportMode, newBaseTrainType, vehicleResourceDetails -> {
                    baseVehicleResource[0] = (VehicleResource)vehicleResourceDetails.left();
                });
                if (baseVehicleResource[0] != null) break;
            }
            JsonObject baseObject = new JsonObject();
            if (baseVehicleResource[0] != null) {
                baseVehicleResource[0].serializeData(new JsonWriter(baseObject));
            }
            baseObject.addProperty("id", String.format("mtr_custom_train_%s_%s", id, variation.key));
            baseObject.addProperty("name", this.name + variation.description);
            baseObject.addProperty("color", this.color);
            if (!this.description.isEmpty()) {
                baseObject.addProperty("description", this.description);
            }
            if (!this.wikipedia_article.isEmpty()) {
                baseObject.addProperty("wikipediaArticle", this.wikipedia_article);
            }
            if (!this.bve_sound_base_id.isEmpty()) {
                baseObject.addProperty("bveSoundBaseResource", this.bve_sound_base_id);
            }
            if (!this.speed_sound_base_id.isEmpty()) {
                baseObject.addProperty("legacySpeedSoundBaseResource", this.speed_sound_base_id);
            }
            if (!this.door_sound_base_id.isEmpty()) {
                baseObject.addProperty("legacyDoorSoundBaseResource", this.door_sound_base_id);
            }
            if (this.speed_sound_count != 0L) {
                baseObject.addProperty("legacySpeedSoundCount", this.speed_sound_count);
            }
            if (this.accel_sound_at_coast) {
                baseObject.addProperty("legacyUseAccelerationSoundsWhenCoasting", this.accel_sound_at_coast);
            }
            if (this.const_playback_speed) {
                baseObject.addProperty("legacyConstantPlaybackSpeed", this.const_playback_speed);
            }
            baseObject.addProperty("legacyDoorCloseSoundTime", this.door_close_sound_time == 0.0 ? 0.5 : this.door_close_sound_time);
            if (baseVehicleResource[0] == null) {
                JsonObject propertiesObject;
                JsonObject jsonObject = propertiesObject = this.model_properties.isEmpty() ? null : Utilities.parseJson(resourceProvider.get(new Identifier(this.model_properties)));
                if (propertiesObject == null) continue;
                double length = 0.0;
                double width = 0.0;
                double doorMax = 0.0;
                try {
                    baseObject.addProperty("transportMode", propertiesObject.get("transport_mode").getAsString());
                    length = propertiesObject.get("length").getAsDouble() + 1.0;
                    width = propertiesObject.get("width").getAsDouble();
                }
                catch (Exception ignored1) {
                    try {
                        String[] baseTrainTypeSplit = (this.base_train_type.startsWith("base_") ? this.base_train_type.replace("base_", "train_") : this.base_train_type).toUpperCase(Locale.ENGLISH).replace("CABLE_CAR", "CABLE-CAR").split("_");
                        baseObject.addProperty("transportMode", baseTrainTypeSplit[0].replace("CABLE-CAR", "CABLE_CAR"));
                        length = Double.parseDouble(baseTrainTypeSplit[1]) + 1.0;
                        width = Double.parseDouble(baseTrainTypeSplit[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    doorMax = propertiesObject.get("door_max").getAsDouble();
                }
                catch (Exception ignored1) {
                    // empty catch block
                }
                if (length == 0.0 || width == 0.0) continue;
                baseObject.addProperty("length", length);
                baseObject.addProperty("width", width);
                double bogiePosition = length < 10.0 ? 0.0 : length * 0.34;
                baseObject.addProperty("bogie1Position", -bogiePosition);
                baseObject.addProperty("bogie2Position", bogiePosition);
                baseObject.addProperty("couplingPadding1", (i & 1) == 0 ? 0 : 1);
                baseObject.addProperty("couplingPadding2", (i & 2) == 0 ? 0 : 1);
                baseObject.addProperty("hasGangway1", (!this.gangway_connection_id.isEmpty() || this.has_gangway_connection) && (i & 1) == 0);
                baseObject.addProperty("hasGangway2", (!this.gangway_connection_id.isEmpty() || this.has_gangway_connection) && (i & 2) == 0);
                baseObject.addProperty("hasBarrier1", !this.train_barrier_id.isEmpty() && (i & 1) == 0);
                baseObject.addProperty("hasBarrier2", !this.train_barrier_id.isEmpty() && (i & 2) == 0);
                baseObject.addProperty("legacyRiderOffset", this.rider_offset);
                double finalDoorMax = doorMax;
                vehicleResources.add(new VehicleResource(new JsonReader(baseObject), (currentCar, totalCars) -> {
                    boolean isObj = false;
                    boolean reversed = false;
                    ObjectArrayList<JsonObject> modelObjects = new ObjectArrayList<JsonObject>();
                    String[] modelSplit = LegacyVehicleResource.splitWithEmptyStrings(this.model, '|');
                    for (int j = 0; j < modelSplit.length; j += 2) {
                        String[] conditions;
                        String[] stringArray = conditions = j + 1 < modelSplit.length ? LegacyVehicleResource.splitWithEmptyStrings(modelSplit[j + 1], ';') : new String[]{};
                        if (conditions.length >= 2 && LegacyVehicleResource.matchesFilter(conditions[1].split(","), currentCar, totalCars) > LegacyVehicleResource.matchesFilter(conditions[0].split(","), currentCar, totalCars)) continue;
                        JsonObject modelObject2 = new JsonObject();
                        modelObject2.addProperty("modelResource", modelSplit[j]);
                        modelObject2.addProperty("textureResource", this.texture_id);
                        modelObject2.addProperty("flipTextureV", this.flipV);
                        modelObjects.add(modelObject2);
                        if (modelSplit[j].endsWith(".obj")) {
                            isObj = true;
                        }
                        if (conditions.length < 3 || !conditions[2].equals("reversed")) continue;
                        reversed = true;
                    }
                    JsonArray positionDefinitionsArray = new JsonArray();
                    JsonArray partsArray = new JsonArray();
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_normal"), positionDefinitionsArray, partsArray, finalDoorMax, "NORMAL", null, null);
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_1"), positionDefinitionsArray, partsArray, finalDoorMax, "NORMAL", "1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_2"), positionDefinitionsArray, partsArray, finalDoorMax, "NORMAL", "-1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_1_headlights"), positionDefinitionsArray, partsArray, finalDoorMax, "ON_ROUTE_FORWARDS", "1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_2_headlights"), positionDefinitionsArray, partsArray, finalDoorMax, "ON_ROUTE_BACKWARDS", "-1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_1_tail_lights"), positionDefinitionsArray, partsArray, finalDoorMax, "ON_ROUTE_BACKWARDS", "1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_head_2_tail_lights"), positionDefinitionsArray, partsArray, finalDoorMax, "ON_ROUTE_FORWARDS", "-1", "%1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_end_1"), positionDefinitionsArray, partsArray, finalDoorMax, "NORMAL", "%1", "1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_end_2"), positionDefinitionsArray, partsArray, finalDoorMax, "NORMAL", "%1", "-1");
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_door_opened"), positionDefinitionsArray, partsArray, finalDoorMax, "DOORS_OPENED", null, null);
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts_door_closed"), positionDefinitionsArray, partsArray, finalDoorMax, "DOORS_CLOSED", null, null);
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    try {
                        this.processModel(currentCar, totalCars, isObj, reversed, propertiesObject.getAsJsonArray("parts"), positionDefinitionsArray, partsArray, finalDoorMax, null, null, null);
                    }
                    catch (Exception modelObject2) {
                        // empty catch block
                    }
                    JsonObject modelPropertiesObject = new JsonObject();
                    modelPropertiesObject.addProperty("modelYOffset", 1);
                    modelPropertiesObject.addProperty("gangwayInnerSideResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_side.png");
                    modelPropertiesObject.addProperty("gangwayInnerTopResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_roof.png");
                    modelPropertiesObject.addProperty("gangwayInnerBottomResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_floor.png");
                    modelPropertiesObject.addProperty("gangwayOuterSideResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                    modelPropertiesObject.addProperty("gangwayOuterTopResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                    modelPropertiesObject.addProperty("gangwayOuterBottomResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                    modelPropertiesObject.addProperty("gangwayWidth", 1.5);
                    modelPropertiesObject.addProperty("gangwayHeight", 2.25);
                    modelPropertiesObject.addProperty("gangwayYOffset", 1);
                    modelPropertiesObject.addProperty("gangwayZOffset", 0.5);
                    modelPropertiesObject.addProperty("barrierInnerSideResource", this.train_barrier_id + "_exterior.png");
                    modelPropertiesObject.addProperty("barrierOuterSideResource", this.train_barrier_id + "_exterior.png");
                    modelPropertiesObject.addProperty("barrierWidth", 2.25);
                    modelPropertiesObject.addProperty("barrierHeight", 1);
                    modelPropertiesObject.addProperty("barrierYOffset", 1.25);
                    modelPropertiesObject.addProperty("barrierZOffset", 0.25);
                    modelPropertiesObject.add("parts", partsArray);
                    JsonObject positionDefinitionsObject = new JsonObject();
                    positionDefinitionsObject.add("positionDefinitions", positionDefinitionsArray);
                    return modelObjects.stream().map(modelObject -> new VehicleModel(new JsonReader((JsonElement)modelObject), new JsonReader(modelPropertiesObject), new JsonReader(positionDefinitionsObject), id, resourceProvider)).collect(Collectors.toCollection(ObjectArrayList::new));
                }, resourceProvider));
                continue;
            }
            baseObject.getAsJsonArray("models").forEach(jsonElement -> {
                JsonObject modelObject = jsonElement.getAsJsonObject();
                if (!LegacyVehicleResource.tryGet(modelObject, "textureResource").contains("overlay")) {
                    modelObject.addProperty("textureResource", this.texture_id);
                }
            });
            vehicleResources.add(new VehicleResource(new JsonReader(baseObject), resourceProvider));
        }
    }

    private void processModel(int currentCar, int totalCars, boolean isObj, boolean reversed, JsonArray propertiesPartsArray, JsonArray positionDefinitionsArray, JsonArray partsArray, double doorMax, @Nullable String renderConditionOverride, @Nullable String whitelistedCarsOverride, @Nullable String blacklistedCarsOverride) {
        propertiesPartsArray.forEach(jsonElement -> {
            JsonObject propertiesPartsObject = jsonElement.getAsJsonObject();
            String[] whitelistedCarsFilters = (whitelistedCarsOverride == null ? LegacyVehicleResource.tryGet(propertiesPartsObject, "whitelisted_cars") : whitelistedCarsOverride).split(",");
            String[] blacklistedCarsFilters = (blacklistedCarsOverride == null ? LegacyVehicleResource.tryGet(propertiesPartsObject, "blacklisted_cars") : blacklistedCarsOverride).split(",");
            if (LegacyVehicleResource.matchesFilter(blacklistedCarsFilters, currentCar, totalCars) <= LegacyVehicleResource.matchesFilter(whitelistedCarsFilters, currentCar, totalCars)) {
                double doorZMultiplier;
                double doorXMultiplier;
                JsonObject partsObject = new JsonObject();
                partsArray.add(partsObject);
                if (propertiesPartsObject.has("name")) {
                    LegacyVehicleResource.addSingleArrayItem(partsObject, "names", LegacyVehicleResource.tryGet(propertiesPartsObject, "name"));
                } else {
                    LegacyVehicleResource.addSingleArrayItem(partsObject, "names", LegacyVehicleResource.tryGet(propertiesPartsObject, "part_name"));
                }
                partsObject.addProperty("renderStage", LegacyVehicleResource.tryGet(propertiesPartsObject, "stage").toUpperCase(Locale.ENGLISH));
                partsObject.addProperty("doorAnimationType", this.door_animation_type);
                if (renderConditionOverride == null) {
                    String renderCondition;
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "render_condition").toUpperCase(Locale.ENGLISH)) {
                        case "DOORS_OPEN": 
                        case "DOORS_LEFT_OPEN": 
                        case "DOORS_RIGHT_OPEN": {
                            renderCondition = "DOORS_OPENED";
                            break;
                        }
                        case "DOORS_CLOSED": 
                        case "DOORS_LEFT_CLOSED": 
                        case "DOORS_RIGHT_CLOSED": {
                            renderCondition = "DOORS_CLOSED";
                            break;
                        }
                        case "MOVING_FORWARDS": {
                            renderCondition = "ON_ROUTE_FORWARDS";
                            break;
                        }
                        case "MOVING_BACKWARDS": {
                            renderCondition = "ON_ROUTE_BACKWARDS";
                            break;
                        }
                        default: {
                            renderCondition = "NORMAL";
                        }
                    }
                    partsObject.addProperty("condition", renderCondition);
                } else {
                    partsObject.addProperty("condition", renderConditionOverride);
                }
                if (propertiesPartsObject.has("display")) {
                    partsObject.addProperty("type", "DISPLAY");
                    JsonObject displayObject = propertiesPartsObject.getAsJsonObject("display");
                    partsObject.addProperty("displayXPadding", LegacyVehicleResource.tryGetNumber(displayObject, "x_padding"));
                    partsObject.addProperty("displayYPadding", LegacyVehicleResource.tryGetNumber(displayObject, "y_padding"));
                    partsObject.addProperty("displayCjkSizeRatio", LegacyVehicleResource.tryGetNumber(displayObject, "cjk_size_ratio"));
                    partsObject.addProperty("displayColorCjk", LegacyVehicleResource.tryGet(displayObject, "color_cjk"));
                    partsObject.addProperty("displayColor", LegacyVehicleResource.tryGet(displayObject, "color"));
                    partsObject.addProperty("displayPadZeros", LegacyVehicleResource.tryGetNumber(displayObject, "display_pad_zeros"));
                    String displayType = LegacyVehicleResource.tryGet(displayObject, "type");
                    partsObject.addProperty("displayType", "NEXT_STATION_PLAIN".equals(displayType) ? "NEXT_STATION" : displayType);
                    JsonArray displayOptionsArray = new JsonArray();
                    partsObject.add("displayOptions", displayOptionsArray);
                    if (LegacyVehicleResource.tryGetBoolean(displayObject, "should_scroll")) {
                        displayOptionsArray.add("SCROLL_NORMAL");
                    }
                    if (LegacyVehicleResource.tryGetBoolean(displayObject, "force_upper_case")) {
                        displayOptionsArray.add("UPPER_CASE");
                    }
                    if (LegacyVehicleResource.tryGetBoolean(displayObject, "force_single_line")) {
                        displayOptionsArray.add("SINGLE_LINE");
                    }
                } else {
                    partsObject.addProperty("type", "NORMAL");
                }
                boolean mirror = LegacyVehicleResource.tryGetBoolean(propertiesPartsObject, "mirror");
                if (propertiesPartsObject.has("door_offset")) {
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT_NEGATIVE": {
                            doorXMultiplier = mirror ? -1.0 : 1.0;
                            doorZMultiplier = -doorMax;
                            break;
                        }
                        case "RIGHT_NEGATIVE": {
                            doorXMultiplier = mirror ? 1.0 : -1.0;
                            doorZMultiplier = -doorMax;
                            break;
                        }
                        case "LEFT_POSITIVE": {
                            doorXMultiplier = mirror ? -1.0 : 1.0;
                            doorZMultiplier = doorMax;
                            break;
                        }
                        case "RIGHT_POSITIVE": {
                            doorXMultiplier = mirror ? 1.0 : -1.0;
                            doorZMultiplier = doorMax;
                            break;
                        }
                        default: {
                            doorXMultiplier = 0.0;
                            doorZMultiplier = 0.0;
                            break;
                        }
                    }
                } else {
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset_x").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT": 
                        case "LEFT_NEGATIVE": 
                        case "RIGHT": 
                        case "RIGHT_NEGATIVE": {
                            doorXMultiplier = -1.0;
                            break;
                        }
                        default: {
                            doorXMultiplier = 0.0;
                        }
                    }
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset_z").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT_NEGATIVE": 
                        case "RIGHT_NEGATIVE": {
                            doorZMultiplier = -doorMax;
                            break;
                        }
                        case "LEFT": 
                        case "RIGHT": {
                            doorZMultiplier = doorMax;
                            break;
                        }
                        default: {
                            doorZMultiplier = 0.0;
                        }
                    }
                }
                partsObject.addProperty("doorXMultiplier", doorXMultiplier);
                partsObject.addProperty("doorZMultiplier", (double)(isObj ? -1 : 1) * doorZMultiplier);
                String positionDefinitionName = "definition_" + Init.randomString();
                JsonArray positionDefinitionPositionsArray = new JsonArray();
                JsonArray positionDefinitionPositionsFlippedArray = new JsonArray();
                JsonObject positionDefinitionObject = new JsonObject();
                positionDefinitionObject.addProperty("name", positionDefinitionName);
                positionDefinitionObject.add("positions", reversed ? positionDefinitionPositionsFlippedArray : positionDefinitionPositionsArray);
                positionDefinitionObject.add("positionsFlipped", reversed ? positionDefinitionPositionsArray : positionDefinitionPositionsFlippedArray);
                positionDefinitionsArray.add(positionDefinitionObject);
                LegacyVehicleResource.processPositions(propertiesPartsObject, "positions", reversed, mirror ? positionDefinitionPositionsFlippedArray : positionDefinitionPositionsArray);
                LegacyVehicleResource.processPositions(propertiesPartsObject, "positions_flipped", reversed, positionDefinitionPositionsFlippedArray);
                LegacyVehicleResource.addSingleArrayItem(partsObject, "positionDefinitions", positionDefinitionName);
            }
        });
    }

    private static void processPositions(JsonObject propertiesPartsObject, String property, boolean reversed, JsonArray positionDefinitionPositionsArray) {
        try {
            propertiesPartsObject.getAsJsonArray(property).forEach(jsonElement -> {
                JsonObject positionDefinitionObject = new JsonObject();
                positionDefinitionObject.addProperty("x", jsonElement.getAsJsonArray().get(0).getAsDouble());
                positionDefinitionObject.addProperty("z", jsonElement.getAsJsonArray().get(1).getAsDouble() * (double)(reversed ? -1 : 1));
                positionDefinitionPositionsArray.add(positionDefinitionObject);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addSingleArrayItem(JsonObject jsonObject, String property, String string) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(string);
        jsonObject.add(property, jsonArray);
    }

    private static String tryGet(JsonObject jsonObject, String property) {
        try {
            return jsonObject.get(property).getAsString();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static double tryGetNumber(JsonObject jsonObject, String property) {
        try {
            return jsonObject.get(property).getAsDouble();
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }

    private static boolean tryGetBoolean(JsonObject jsonObject, String property) {
        try {
            return jsonObject.has(property) && jsonObject.get(property).getAsBoolean();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static int matchesFilter(String[] filters, int currentCar, int totalCars) {
        int strength = filters.length == 0 ? 1 : 0;
        for (String filter : filters) {
            if (filter.isEmpty()) continue;
            if (filter.contains("%")) {
                try {
                    int additional;
                    String[] filterSplit = filter.split("\\+");
                    int multiple = Integer.parseInt(filterSplit[0].replace("%", ""));
                    int n = additional = filterSplit.length == 1 ? 0 : Integer.parseInt(filterSplit[1]);
                    if ((currentCar + 1 + additional) % multiple != 0) continue;
                    strength = 2;
                }
                catch (Exception filterSplit) {}
                continue;
            }
            try {
                int car = Integer.parseInt(filter);
                if (car != currentCar + 1 && car != currentCar - totalCars) continue;
                return 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strength;
    }

    private static String[] splitWithEmptyStrings(String string, char token) {
        String filler = Init.randomString();
        String[] firstSplit = string.replace(String.valueOf(token), String.format("%1$s%2$s%1$s", filler, Character.valueOf(token))).split("\\" + token);
        String[] finalSplit = new String[firstSplit.length];
        for (int i = 0; i < firstSplit.length; ++i) {
            finalSplit[i] = firstSplit[i].replace(filler, "");
        }
        return finalSplit;
    }

    private static enum Variation {
        TRAILER(" (Trailer)"),
        CAB_1(" Cab (Forwards)"),
        CAB_2(" Cab (Backwards)"),
        CAB_3(" Cab (Double)");

        private final String key = this.toString().toLowerCase(Locale.ENGLISH);
        private final String description;

        private Variation(String description) {
            this.description = description;
        }
    }
}

