/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ActionResultType;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum ActionResult {
    SUCCESS(ActionResultType.SUCCESS),
    CONSUME(ActionResultType.CONSUME),
    PASS(ActionResultType.PASS),
    FAIL(ActionResultType.FAIL);

    public final ActionResultType data;

    private ActionResult(ActionResultType data) {
        this.data = data;
    }

    public static ActionResult convert(@Nullable ActionResultType data) {
        return data == null ? null : ActionResult.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable ActionResult data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static ActionResult success(boolean arg0) {
        return ActionResult.convert(ActionResultType.func_233537_a_((boolean)arg0));
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getConsumeMapped() {
        return ActionResult.convert(ActionResultType.CONSUME);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getFailMapped() {
        return ActionResult.convert(ActionResultType.FAIL);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getPassMapped() {
        return ActionResult.convert(ActionResultType.PASS);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getSuccessMapped() {
        return ActionResult.convert(ActionResultType.SUCCESS);
    }
}

