/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Direction;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Random;

@ParametersAreNonnullByDefault
public enum Axis {
    X(Direction.Axis.X),
    Y(Direction.Axis.Y),
    Z(Direction.Axis.Z);

    public final Direction.Axis data;

    private Axis(Direction.Axis data) {
        this.data = data;
    }

    public static Axis convert(@Nullable Direction.Axis data) {
        return data == null ? null : Axis.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable Axis data) {
        return data != null && this.data == data.data;
    }

    @MappedMethod
    public boolean test(@Nullable Direction arg0) {
        return this.data.test(arg0 == null ? null : arg0.data);
    }

    @Nonnull
    @MappedMethod
    public String asString() {
        return this.data.func_176610_l();
    }

    @MappedMethod
    public boolean isVertical() {
        return this.data.func_200128_b();
    }

    @MappedMethod
    public double choose(double arg0, double arg1, double arg2) {
        return this.data.func_196051_a(arg0, arg1, arg2);
    }

    @MappedMethod
    public int choose(int arg0, int arg1, int arg2) {
        return this.data.func_196052_a(arg0, arg1, arg2);
    }

    @Nullable
    @MappedMethod
    public static Axis fromName(String arg0) {
        Direction.Axis tempData = Direction.Axis.func_176717_a((String)arg0);
        return tempData == null ? null : Axis.convert(tempData);
    }

    @MappedMethod
    public boolean isHorizontal() {
        return this.data.func_176722_c();
    }

    @Nonnull
    @MappedMethod
    public String getName() {
        return this.data.func_176719_a();
    }

    @Nonnull
    @MappedMethod
    public static Axis pickRandomAxis(Random arg0) {
        return Axis.convert(Direction.Axis.func_239634_a_((java.util.Random)((java.util.Random)arg0.data)));
    }

    @Nonnull
    @MappedMethod
    public static Axis getXMapped() {
        return Axis.convert(Direction.Axis.X);
    }

    @Nonnull
    @MappedMethod
    public static Axis getYMapped() {
        return Axis.convert(Direction.Axis.Y);
    }

    @Nonnull
    @MappedMethod
    public static Axis getZMapped() {
        return Axis.convert(Direction.Axis.Z);
    }
}

