/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import java.io.IOException;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.ClientChunkManager;
import org.mtr.mapping.holder.ClientPlayNetworkHandler;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Difficulty;
import org.mtr.mapping.holder.DimensionType;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.FluidState;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ParticleEffect;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.Scoreboard;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.holder.WorldRenderer;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ClientWorld
extends HolderBase<net.minecraft.client.world.ClientWorld> {
    public ClientWorld(net.minecraft.client.world.ClientWorld data) {
        super(data);
    }

    @MappedMethod
    public static ClientWorld cast(HolderBase<?> data) {
        return new ClientWorld((net.minecraft.client.world.ClientWorld)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof net.minecraft.client.world.ClientWorld;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((net.minecraft.client.world.ClientWorld)this.data).equals(((HolderBase)data).data);
    }

    @Nullable
    @MappedMethod
    public BlockHitResult raycastBlock(Vector3d arg0, Vector3d arg1, BlockPos arg2, VoxelShape arg3, BlockState arg4) {
        BlockRayTraceResult tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_217296_a((net.minecraft.util.math.vector.Vector3d)arg0.data, (net.minecraft.util.math.vector.Vector3d)arg1.data, (net.minecraft.util.math.BlockPos)arg2.data, (net.minecraft.util.math.shapes.VoxelShape)arg3.data, (net.minecraft.block.BlockState)arg4.data);
        return tempData == null ? null : new BlockHitResult(tempData);
    }

    @Nullable
    @MappedMethod
    public BlockView getChunkAsView(int arg0, int arg1) {
        IBlockReader tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_225522_c_(arg0, arg1);
        return tempData == null ? null : new BlockView(tempData);
    }

    @MappedMethod
    public long getLunarTime() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_241851_ab();
    }

    @Nonnull
    @MappedMethod
    public BlockPos getRandomPosInChunk(int arg0, int arg1, int arg2, int arg3) {
        return new BlockPos(((net.minecraft.client.world.ClientWorld)this.data).func_217383_a(arg0, arg1, arg2, arg3));
    }

    @MappedMethod
    public void updateNeighbors(BlockPos arg0, Block arg1) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_195593_d((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.Block)arg1.data);
    }

    @MappedMethod
    public double getDismountHeight(BlockPos arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_242403_h((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @MappedMethod
    public boolean isPlayerInRange(double arg0, double arg1, double arg2, double arg3) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_217358_a(arg0, arg1, arg2, arg3);
    }

    @MappedMethod
    public void addSyncedBlockEvent(BlockPos arg0, Block arg1, int arg2, int arg3) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_175641_c((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.Block)arg1.data, arg2, arg3);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(double arg0, double arg1, double arg2, double arg3, boolean arg4) {
        net.minecraft.entity.player.PlayerEntity tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_217366_a(arg0, arg1, arg2, arg3, arg4);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(Entity arg0, double arg1) {
        net.minecraft.entity.player.PlayerEntity tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_217362_a((net.minecraft.entity.Entity)arg0.data, arg1);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public void playSound(@Nullable PlayerEntity arg0, BlockPos arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_184133_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data, (net.minecraft.util.SoundEvent)arg2.data, arg3.data, arg4, arg5);
    }

    @Nonnull
    @MappedMethod
    public Difficulty getDifficulty() {
        return Difficulty.convert(((net.minecraft.client.world.ClientWorld)this.data).func_175659_aa());
    }

    @MappedMethod
    public int getSeaLevel() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_181545_F();
    }

    @MappedMethod
    public boolean canPlace(BlockState arg0, BlockPos arg1, ShapeContext arg2) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_226663_a_((net.minecraft.block.BlockState)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data, (ISelectionContext)arg2.data);
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(BlockPos arg0) {
        return new Chunk(((net.minecraft.client.world.ClientWorld)this.data).func_217349_x((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2) {
        return new Chunk(((net.minecraft.client.world.ClientWorld)this.data).func_217348_a(arg0, arg1, (net.minecraft.world.chunk.ChunkStatus)arg2.data));
    }

    @MappedMethod
    public int getLightLevel(LightType arg0, BlockPos arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_226658_a_(arg0.data, (net.minecraft.util.math.BlockPos)arg1.data);
    }

    @MappedMethod
    public boolean containsFluid(Box arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_72953_d((AxisAlignedBB)arg0.data);
    }

    @MappedMethod
    public void setMobSpawnOptions(boolean arg0, boolean arg1) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_72891_a(arg0, arg1);
    }

    @Nullable
    @MappedMethod
    public MinecraftServer getServer() {
        net.minecraft.server.MinecraftServer tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_73046_m();
        return tempData == null ? null : new MinecraftServer(tempData);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175656_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data);
    }

    @MappedMethod
    public boolean isDirectionSolid(BlockPos arg0, Entity arg1, Direction arg2) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_234929_a_((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.entity.Entity)arg1.data, arg2.data);
    }

    @MappedMethod
    public long getTime() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_82737_E();
    }

    @MappedMethod
    public void playSound(double arg0, double arg1, double arg2, SoundEvent arg3, SoundCategory arg4, float arg5, float arg6, boolean arg7) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_184134_a(arg0, arg1, arg2, (net.minecraft.util.SoundEvent)arg3.data, arg4.data, arg5, arg6, arg7);
    }

    @MappedMethod
    public void playSoundAtBlockCenter(BlockPos arg0, SoundEvent arg1, SoundCategory arg2, float arg3, float arg4, boolean arg5) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_184156_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.util.SoundEvent)arg1.data, arg2.data, arg3, arg4, arg5);
    }

    @MappedMethod
    public int getMoonPhase() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_242414_af();
    }

    @MappedMethod
    public boolean isAir(BlockPos arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175623_d((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public BlockPos getSpawnPos() {
        return new BlockPos(((net.minecraft.client.world.ClientWorld)this.data).func_239140_u_());
    }

    @Deprecated
    public ClientWorld(ClientPlayNetworkHandler arg0, ClientWorld.ClientWorldInfo arg1, RegistryKey<World> arg2, DimensionType arg3, int arg4, Supplier<IProfiler> arg5, WorldRenderer arg6, boolean arg7, long arg8) {
        super(new net.minecraft.client.world.ClientWorld((ClientPlayNetHandler)arg0.data, arg1, arg2, (net.minecraft.world.DimensionType)arg3.data, arg4, arg5, (net.minecraft.client.renderer.WorldRenderer)arg6.data, arg7, arg8));
    }

    @MappedMethod
    public void setSpawnPos(BlockPos arg0, float arg1) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_239136_a_((net.minecraft.util.math.BlockPos)arg0.data, arg1);
    }

    @MappedMethod
    public boolean isDay() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_72935_r();
    }

    @MappedMethod
    public int getHeight() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_234938_ad_();
    }

    @MappedMethod
    public void sendEntityStatus(Entity arg0, byte arg1) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_72960_a((net.minecraft.entity.Entity)arg0.data, arg1);
    }

    @Nullable
    @MappedMethod
    public BlockEntity getBlockEntity(BlockPos arg0) {
        TileEntity tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_175625_s((net.minecraft.util.math.BlockPos)arg0.data);
        return tempData == null ? null : new BlockEntity(tempData);
    }

    @Nonnull
    @MappedMethod
    public String asString() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_72827_u();
    }

    @MappedMethod
    public final boolean isDebugWorld() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_234925_Z_();
    }

    @MappedMethod
    public boolean canPlayerModifyAt(PlayerEntity arg0, BlockPos arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175660_a((net.minecraft.entity.player.PlayerEntity)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data);
    }

    @MappedMethod
    public void addImportantParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_195589_b((IParticleData)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @MappedMethod
    public void addImportantParticle(ParticleEffect arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_217404_b((IParticleData)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @Nonnull
    @MappedMethod
    public BlockState getBlockState(BlockPos arg0) {
        return new BlockState(((net.minecraft.client.world.ClientWorld)this.data).func_180495_p((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public WorldChunk getWorldChunk(BlockPos arg0) {
        return new WorldChunk(((net.minecraft.client.world.ClientWorld)this.data).func_175726_f((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @MappedMethod
    public void updateListeners(BlockPos arg0, BlockState arg1, BlockState arg2, int arg3) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_184138_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data, (net.minecraft.block.BlockState)arg2.data, arg3);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2, int arg3) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_241211_a_((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data, arg2, arg3);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_180501_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data, arg2);
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_195590_a((IParticleData)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_195594_a((IParticleData)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @MappedMethod
    public void updateNeighborsExcept(BlockPos arg0, Block arg1, Direction arg2) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_175695_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.Block)arg1.data, arg2.data);
    }

    @MappedMethod
    public boolean spawnEntity(Entity arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_217376_c((net.minecraft.entity.Entity)arg0.data);
    }

    @Nullable
    @MappedMethod
    public Entity getEntityById(int arg0) {
        net.minecraft.entity.Entity tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_73045_a(arg0);
        return tempData == null ? null : new Entity(tempData);
    }

    @Nonnull
    @MappedMethod
    public BlockPos getTopPosition(HeightMapType arg0, BlockPos arg1) {
        return new BlockPos(((net.minecraft.client.world.ClientWorld)this.data).func_205770_a(arg0.data, (net.minecraft.util.math.BlockPos)arg1.data));
    }

    @MappedMethod
    public void setScoreboard(Scoreboard arg0) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_96443_a((net.minecraft.scoreboard.Scoreboard)arg0.data);
    }

    @MappedMethod
    public boolean isRegionLoaded(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_217344_a(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    @MappedMethod
    public boolean isRegionLoaded(BlockPos arg0, BlockPos arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175707_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data);
    }

    @Nonnull
    @MappedMethod
    public Scoreboard getScoreboard() {
        return new Scoreboard(((net.minecraft.client.world.ClientWorld)this.data).func_96441_U());
    }

    @MappedMethod
    public void playSound(@Nullable PlayerEntity arg0, double arg1, double arg2, double arg3, SoundEvent arg4, SoundCategory arg5, float arg6, float arg7) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_184148_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, arg1, arg2, arg3, (net.minecraft.util.SoundEvent)arg4.data, arg5.data, arg6, arg7);
    }

    @MappedMethod
    public void playSoundFromEntity(@Nullable PlayerEntity arg0, Entity arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_217384_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, (net.minecraft.entity.Entity)arg1.data, (net.minecraft.util.SoundEvent)arg2.data, arg3.data, arg4, arg5);
    }

    @MappedMethod
    public float getBrightness(Direction arg0, boolean arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_230487_a_(arg0.data, arg1);
    }

    @MappedMethod
    public int getTopY(HeightMapType arg0, int arg1, int arg2) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_201676_a(arg0.data, arg1, arg2);
    }

    @MappedMethod
    public void close() throws IOException {
        ((net.minecraft.client.world.ClientWorld)this.data).close();
    }

    @MappedMethod
    public boolean isSpaceEmpty(Box arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_226664_a_((AxisAlignedBB)arg0.data);
    }

    @MappedMethod
    public void updateNeighbor(BlockPos arg0, Block arg1, BlockPos arg2) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_190524_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.Block)arg1.data, (net.minecraft.util.math.BlockPos)arg2.data);
    }

    @MappedMethod
    public boolean isNight() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_226690_K_();
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayerByUuid(UUID arg0) {
        net.minecraft.entity.player.PlayerEntity tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_217371_b(arg0);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public boolean isTopSolid(BlockPos arg0, Entity arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_217400_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.entity.Entity)arg1.data);
    }

    @MappedMethod
    public boolean isRaining() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_72896_J();
    }

    @MappedMethod
    public boolean isWater(BlockPos arg0) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_201671_F((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175655_b((net.minecraft.util.math.BlockPos)arg0.data, arg1);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_225521_a_((net.minecraft.util.math.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.entity.Entity)arg2.data);
    }

    @MappedMethod
    public void disconnect() {
        ((net.minecraft.client.world.ClientWorld)this.data).func_72882_A();
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        IChunk tempData = ((net.minecraft.client.world.ClientWorld)this.data).func_217353_a(arg0, arg1, (net.minecraft.world.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @Nonnull
    @MappedMethod
    public WorldChunk getChunk(int arg0, int arg1) {
        return new WorldChunk(((net.minecraft.client.world.ClientWorld)this.data).func_212866_a_(arg0, arg1));
    }

    @MappedMethod
    public boolean isThundering() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_72911_I();
    }

    @MappedMethod
    public boolean doesNotIntersectEntities(@Nullable Entity arg0, VoxelShape arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_195585_a(arg0 == null ? null : (net.minecraft.entity.Entity)arg0.data, (net.minecraft.util.math.shapes.VoxelShape)arg1.data);
    }

    @Nonnull
    @MappedMethod
    public ClientChunkManager getChunkManager() {
        return new ClientChunkManager(((net.minecraft.client.world.ClientWorld)this.data).func_72863_F());
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(BlockPos arg0) {
        return new FluidState(((net.minecraft.client.world.ClientWorld)this.data).func_204610_c((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @MappedMethod
    public boolean isEmittingRedstonePower(BlockPos arg0, Direction arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_175709_b((net.minecraft.util.math.BlockPos)arg0.data, arg1.data);
    }

    @Nonnull
    @MappedMethod
    public DimensionType getDimension() {
        return new DimensionType(((net.minecraft.client.world.ClientWorld)this.data).func_230315_m_());
    }

    @Nonnull
    @MappedMethod
    public Vector3d getCloudsColor(float arg0) {
        return new Vector3d(((net.minecraft.client.world.ClientWorld)this.data).func_228328_h_(arg0));
    }

    @MappedMethod
    public int getMaxLightLevel() {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_201572_C();
    }

    @MappedMethod
    public void tick(BooleanSupplier arg0) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_72835_b(arg0);
    }

    @MappedMethod
    public void tickEntities() {
        ((net.minecraft.client.world.ClientWorld)this.data).func_217419_d();
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2, int arg3) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_241212_a_((net.minecraft.util.math.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.entity.Entity)arg2.data, arg3);
    }

    @MappedMethod
    public void syncWorldEvent(@Nullable PlayerEntity arg0, int arg1, BlockPos arg2, int arg3) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_217378_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, arg1, (net.minecraft.util.math.BlockPos)arg2.data, arg3);
    }

    @MappedMethod
    public void addFireworkParticle(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, @Nullable CompoundTag arg6) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_92088_a(arg0, arg1, arg2, arg3, arg4, arg5, arg6 == null ? null : (CompoundNBT)arg6.data);
    }

    @MappedMethod
    public boolean removeBlock(BlockPos arg0, boolean arg1) {
        return ((net.minecraft.client.world.ClientWorld)this.data).func_217377_a((net.minecraft.util.math.BlockPos)arg0.data, arg1);
    }

    @Nonnull
    @MappedMethod
    public Random getRandom() {
        return new Random(((net.minecraft.client.world.ClientWorld)this.data).func_201674_k());
    }

    @MappedMethod
    public void removeBlockEntity(BlockPos arg0) {
        ((net.minecraft.client.world.ClientWorld)this.data).func_175713_t((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @MappedMethod
    public boolean getIsClientMapped() {
        return ((net.minecraft.client.world.ClientWorld)this.data).field_72995_K;
    }

    @Nonnull
    @MappedMethod
    public Random getRandomMapped() {
        return new Random(((net.minecraft.client.world.ClientWorld)this.data).field_73012_v);
    }
}

