/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.GameType;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum GameMode {
    NOT_SET(GameType.NOT_SET),
    SURVIVAL(GameType.SURVIVAL),
    CREATIVE(GameType.CREATIVE),
    ADVENTURE(GameType.ADVENTURE),
    SPECTATOR(GameType.SPECTATOR);

    public final GameType data;

    private GameMode(GameType data) {
        this.data = data;
    }

    public static GameMode convert(@Nullable GameType data) {
        return data == null ? null : GameMode.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable GameMode data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public String getName() {
        return this.data.func_77149_b();
    }

    @MappedMethod
    public boolean isCreative() {
        return this.data.func_77145_d();
    }

    @MappedMethod
    public int getId() {
        return this.data.func_77148_a();
    }

    @Nonnull
    @MappedMethod
    public static GameMode byName(String arg0) {
        return GameMode.convert(GameType.func_77142_a((String)arg0));
    }

    @Nullable
    @MappedMethod
    public static GameMode byName(String arg0, @Nullable GameMode arg1) {
        GameType tempData = GameType.func_185328_a((String)arg0, (GameType)(arg1 == null ? null : arg1.data));
        return tempData == null ? null : GameMode.convert(tempData);
    }

    @Nonnull
    @MappedMethod
    public static GameMode byId(int arg0) {
        return GameMode.convert(GameType.func_77146_a((int)arg0));
    }

    @Nonnull
    @MappedMethod
    public static GameMode getSurvivalMapped() {
        return GameMode.convert(GameType.SURVIVAL);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getSpectatorMapped() {
        return GameMode.convert(GameType.SPECTATOR);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getDefaultMapped() {
        return GameMode.convert(GameType.NOT_SET);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getCreativeMapped() {
        return GameMode.convert(GameType.CREATIVE);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getAdventureMapped() {
        return GameMode.convert(GameType.ADVENTURE);
    }
}

