/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.gen.Heightmap;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum HeightMapType {
    WORLD_SURFACE_WG(Heightmap.Type.WORLD_SURFACE_WG),
    WORLD_SURFACE(Heightmap.Type.WORLD_SURFACE),
    OCEAN_FLOOR_WG(Heightmap.Type.OCEAN_FLOOR_WG),
    OCEAN_FLOOR(Heightmap.Type.OCEAN_FLOOR),
    MOTION_BLOCKING(Heightmap.Type.MOTION_BLOCKING),
    MOTION_BLOCKING_NO_LEAVES(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);

    public final Heightmap.Type data;

    private HeightMapType(Heightmap.Type data) {
        this.data = data;
    }

    public static HeightMapType convert(@Nullable Heightmap.Type data) {
        return data == null ? null : HeightMapType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable HeightMapType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getOceanFloorMapped() {
        return HeightMapType.convert(Heightmap.Type.OCEAN_FLOOR);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getMotionBlockingNoLeavesMapped() {
        return HeightMapType.convert(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getMotionBlockingMapped() {
        return HeightMapType.convert(Heightmap.Type.MOTION_BLOCKING);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getOceanFloorWgMapped() {
        return HeightMapType.convert(Heightmap.Type.OCEAN_FLOOR_WG);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getWorldSurfaceMapped() {
        return HeightMapType.convert(Heightmap.Type.WORLD_SURFACE);
    }

    @Nonnull
    @MappedMethod
    public static HeightMapType getWorldSurfaceWgMapped() {
        return HeightMapType.convert(Heightmap.Type.WORLD_SURFACE_WG);
    }
}

