/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.RayTraceResult;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum HitResultType {
    MISS(RayTraceResult.Type.MISS),
    BLOCK(RayTraceResult.Type.BLOCK),
    ENTITY(RayTraceResult.Type.ENTITY);

    public final RayTraceResult.Type data;

    private HitResultType(RayTraceResult.Type data) {
        this.data = data;
    }

    public static HitResultType convert(@Nullable RayTraceResult.Type data) {
        return data == null ? null : HitResultType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable HitResultType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getMissMapped() {
        return HitResultType.convert(RayTraceResult.Type.MISS);
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getBlockMapped() {
        return HitResultType.convert(RayTraceResult.Type.BLOCK);
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getEntityMapped() {
        return HitResultType.convert(RayTraceResult.Type.ENTITY);
    }
}

